/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;

public class ClassElementValue
extends ElementValue {
    private int idx;

    public ClassElementValue(int type, int idx, ConstantPool cpool) {
        super(type, cpool);
        this.idx = idx;
    }

    public int getIndex() {
        return this.idx;
    }

    public String getClassString() {
        ConstantUtf8 c = (ConstantUtf8)this.cpool.getConstant(this.idx, (byte)1);
        return c.getBytes();
    }

    public String stringifyValue() {
        ConstantUtf8 cu8 = (ConstantUtf8)this.cpool.getConstant(this.idx, (byte)1);
        return cu8.getBytes();
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeByte(this.type);
        dos.writeShort(this.idx);
    }
}

