/*
 * Decompiled with CFR 0.152.
 */
package com.vldocking.swing.docking;

import com.vldocking.swing.docking.DockGroup;
import com.vldocking.swing.docking.DockView;
import com.vldocking.swing.docking.Dockable;
import com.vldocking.swing.docking.DockableState;
import com.vldocking.swing.docking.TabbedDockableContainer;
import com.vldocking.swing.docking.event.DockDragEvent;
import com.vldocking.swing.docking.event.DockDropEvent;
import com.vldocking.swing.docking.event.DockEvent;
import com.vldocking.swing.docking.event.DockingActionCreateTabEvent;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class DetachedDockView
extends DockView {
    private static final long serialVersionUID = 1L;
    private static final String uiClassID = "DetachedDockViewUI";

    public DetachedDockView(Dockable dockable) {
        super(dockable);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    protected void scanDrop(DockEvent event, boolean drop) {
        DockGroup dragGroup;
        if (this.getParent() instanceof TabbedDockableContainer) {
            if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).delegateDrag();
            }
            return;
        }
        if (event.getDragSource().getDockable() == this.dockable) {
            if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).rejectDrag();
            }
            return;
        }
        if (event.getDragSource().getDockableContainer() instanceof TabbedDockableContainer) {
            if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).rejectDrag();
            }
            return;
        }
        Rectangle bounds = this.getBounds();
        DockGroup thisGroup = this.dockable.getDockKey().getDockGroup();
        if (!DockGroup.areGroupsCompatible(thisGroup, dragGroup = event.getDragSource().getDockable().getDockKey().getDockGroup())) {
            if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).rejectDrag();
            }
            return;
        }
        Dockable d = event.getDragSource().getDockable();
        DockableState.Location dockableLocation = d.getDockKey().getLocation();
        DockableState.Location viewLocation = this.dockable.getDockKey().getLocation();
        if (drop) {
            event.setDockingAction(new DockingActionCreateTabEvent(event.getDesktop(), d, dockableLocation, viewLocation, this.dockable, 0));
            ((DockDropEvent)event).acceptDrop(false);
            this.desktop.createTab(this.dockable, event.getDragSource().getDockable(), 0, true);
        } else {
            Rectangle2D.Float r2d = new Rectangle2D.Float(bounds.x, bounds.y, bounds.width, bounds.height);
            event.setDockingAction(new DockingActionCreateTabEvent(event.getDesktop(), d, dockableLocation, viewLocation, this.dockable, 0));
            if (r2d.equals(this.lastDropShape)) {
                ((DockDragEvent)event).acceptDrag(this.lastDropGeneralPath);
            } else {
                GeneralPath path = this.buildPathForTab(bounds);
                this.lastDropShape = r2d;
                this.lastDropGeneralPath = path;
                ((DockDragEvent)event).acceptDrag(this.lastDropGeneralPath);
            }
        }
    }

    @Override
    public String toString() {
        return "DetachedDockView of " + this.dockable.getDockKey();
    }
}

