package nom.tam.fits.compression.provider.param.rice;

import nom.tam.fits.Header;

/*
 * #%L
 * nom.tam FITS library
 * %%
 * Copyright (C) 1996 - 2024 nom-tam-fits
 * %%
 * This is free and unencumbered software released into the public domain.
 *
 * Anyone is free to copy, modify, publish, use, compile, sell, or
 * distribute this software, either in source code form or as a compiled
 * binary, for any purpose, commercial or non-commercial, and by any
 * means.
 *
 * In jurisdictions that recognize copyright laws, the author or authors
 * of this software dedicate any and all copyright interest in the
 * software to the public domain. We make this dedication for the benefit
 * of the public at large and to the detriment of our heirs and
 * successors. We intend this dedication to be an overt act of
 * relinquishment in perpetuity of all present and future rights to this
 * software under copyright law.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * #L%
 */

import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.compression.algorithm.rice.RiceCompressOption;
import nom.tam.fits.compression.provider.param.base.CompressHeaderParameter;
import nom.tam.fits.header.Compression;

/**
 * (<i>for internal use</i>) The BYTEPIX value for the Rice compression as recorded in the FITS header.
 */
public final class RiceBytePixParameter extends CompressHeaderParameter<RiceCompressOption> {

    /**
     * @deprecated (<i>for internal use</i>) the visibility of this constructor may be reduced to the package level in
     *                 future releases.
     */
    @SuppressWarnings("javadoc")
    public RiceBytePixParameter(RiceCompressOption riceCompressOption) {
        super(Compression.BYTEPIX, riceCompressOption);
    }

    @Override
    public void getValueFromHeader(Header header) throws HeaderCardException {
        HeaderCard value = findZVal(header);
        if (value != null) {
            getOption().setBytePix(value.getValue(Integer.class, getOption().getBytePix()));
        } else {
            getOption().setBytePix(RiceCompressOption.DEFAULT_RICE_BYTEPIX);
        }
    }

    @Override
    public void setValueInHeader(Header header) throws HeaderCardException {
        int zvalIndex = nextFreeZVal(header);
        header.addValue(Compression.ZNAMEn.n(zvalIndex), getName());
        header.addValue(Compression.ZVALn.n(zvalIndex), getOption().getBytePix());
    }
}
