//start of LzssSearchMethod.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * LzssSearchMethod.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces

//import exceptions


/**
 * LzssOutputStream Ŏgp
 * Œv񋟂C^[tFCXB<br> 
 * 
 * <br>
 * RXgN^̌`
 * <pre>
 * LzssSearchMethod( int    DictionarySize,
 *                   int    MaxMatch,
 *                   int    Threshold,
 *                   byte[] TextBuffer )
 * 
 * <strong>p[^:</strong>
 *   DictionarySize - LZSS̎TCY
 *   MaxMatch       - LZSS̍őv
 *   Threshold      - LZSS̈k/񈳏k臒l
 *   TextBuffer     - LZSSk{f[^̓obt@
 * </pre>
 * ̂悤Ȍ`ɑ邱ƁB<br>
 * ܂Aǉ̈Ƃ肽ꍇ
 * <pre>
 * LzssSearchMethod( int    DictionarySize,
 *                   int    MaxMatch,
 *                   int    Threshold,
 *                   byte[] TextBuffer,
 *                   Object ExtraArgument1,
 *                   Object ExtraArgument2 )
 * </pre>
 * ̂悤Ȍ`pB<br>
 * ȂARXgN^̈`FbN͒ǉ̈ꍇɂčs΂悢B
 * <br>
 * 
 * <pre>
 * -- revision history --
 * $Log: LzssSearchMethod.java,v $
 * Revision 1.1  2002/12/04 00:00:00  dangan
 * [maintenance]
 *     \[X
 *
 * Revision 1.0  2002/07/24 00:00:00  dangan
 * add to version control
 * [change]
 *     slide() ň炸 
 *     XCh DictionarySize Ƃ悤ɕύXB
 *     putLength  putRequires ɕύX
 * [maintenance]
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1 $
 */
public interface LzssSearchMethod{

    //------------------------------------------------------------------
    //  original method
    //------------------------------------------------------------------
    //  public abstract void put( int position )
    //  public abstract int searchAndPut( int position )
    //  public abstract int search( int position, int lastPutPos )
    //  public abstract void slide()
    //  public abstract int putRequires()
    //------------------------------------------------------------------
    /**
     * position n܂f[^p^ 
     * LzssSearchMethod ̎@\ɓo^B<br>
     * LzssOutputStream  `ɁAdA
     * put ܂ searchAndPut ĂяoB<br>
     * 
     * @param position TextBuffer̃f[^p^̊Jnʒu
     */
    public abstract void put( int position );

    /**
     * @\ɓo^ꂽf[^p^
     * position n܂f[^p^
     * Œ̈v̂A
     *  position n܂f[^p^ 
     * LzssSearchMethod ̎@\ɓo^B<br>
     * LzssOutputStream  `ɁAdA
     * put ܂ searchAndPut ĂяoB<br>
     * 
     * @param position TextBuffer̃f[^p^̊Jnʒu
     * 
     * @return vꍇ
     *         LzssOutputStream.createSearchReturn 
     *         ɂĐꂽvʒuƈv̏lA
     *         vȂꍇ
     *         LzssOutputStream.NOMATCHB
     * 
     * @see LzssOutputStream#createSearchReturn(int,int)
     * @see LzssOutputStream#NOMATCH
     */
    public abstract int searchAndPut( int position );

    /**
     * @\ɓo^ꂽf[^p^
     * position n܂f[^p^
     * Œ̈v̂B<br>
     * ̃\bh LzssOutputStream  
     * flush() 邽߂ɒ񋟂B<br>
     * TextBuffer.length &lt position + MaxMatch ƂȂ悤 
     * position ɂΉ邱ƁB
     * 
     * @param position   TextBuffer̃f[^p^̊Jnʒu
     * @param lastPutPos Ōɓo^f[^p^̊Jnʒu
     * 
     * @return vꍇ
     *         LzssOutputStream.createSearchReturn 
     *         ɂĐꂽvʒuƈv̏lA
     *         vȂꍇ
     *         LzssOutputStream.NOMATCHB
     * 
     * @see LzssOutputStream#createSearchReturn(int,int)
     * @see LzssOutputStream#NOMATCH
     */
    public abstract int search( int position, int lastPutPos );

    /**
     * LzssOutputStream  slide() TextBuffer̃f[^
     * DictionarySize ړۂɌ@\̃f[^
     * Ɩړ鏈sB
     */
    public abstract void slide();

    /**
     * put() ܂ searchAndPut() gp
     * f[^p^@\ɓo^鎞
     * KvƂf[^ʂ𓾂B<br>
     * 
     * @return put() ܂ searchAndPut() 
     *         @\ɓo^f[^
     */
    public abstract int putRequires();

}
//end of LzssSearchMethod.java
