#-*- coding: utf-8 -*-

# Copyright 2008-2010 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

#Allowed keys
#   mode -     variable mode: 'w' - you can change value from command line,
#              'r' you cann't change value from command line
#   type     - depricated
#   value    - value 
#   official - show or not variable for display values

class Data:
    # computer hostname
    os_net_hostname = {'mode':"w"}

    # allowed networks
    os_net_allow ={}

    # ip for all network interfaces (comma delimeter)
    os_net_ip ={}

    # network interfaces
    os_net_interfaces={'official':True}

    # computer domain
    os_net_domain = {'mode':"w"}

    # short system name (CLD)
    os_linux_shortname={}

    # aliases and path to ini files
    cl_env_data = {'official':True,
                   'value':[('default', '/etc/calculate/calculate2.env'),
                            ('local', '/var/calculate/calculate2.env'),
                            ('remote', '/var/calculate/remote/calculate2.env')]}

    # path aliases to ini files (from cl_env_data)
    cl_env_location = {'official':True}

    # path to ini files (from cl_env_data)
    cl_env_path = {}

    # path to information file on server
    cl_env_server_path = {'official':True,
                          'value':'/var/calculate/remote/server.env'}

    # paths to template files
    cl_template_path = {'value':["/usr/share/calculate/templates",
                                 "/var/calculate/templates",
                                 "/var/calculate/remote/templates"]}
     # paths to clt-template files
    cl_template_clt_path = {}
    # locale (at example: ru_RU.UTF-8)
    os_locale_locale = {}
    # full language (at example: ru_RU)
    os_locale_lang = {}
    # short language (at example ru)
    os_locale_language = {}

    # keyboard layout for X server
    os_locale_xkb = {}

    # keyboard layout name for X server
    os_locale_xkbname = {}

    # computer architecture (i686,x86_64)
    os_arch_machine = {}

    # pass for templates join 1,2,3,4,5 and etc
    cl_pass_step = {}

    # template file performed at now
    cl_pass_file = {'mode':"w"}

    # root partition of filesystem
    os_root_dev = {}

    # root type (ram, hdd, usb-hdd, livecd)
    os_root_type = {}

    # full system name
    os_linux_name = {}

    # postfix to system name (KDE GNOME and etc)
    os_linux_subname = {}

    # system (desktop or server)
    os_linux_system = {}

    # motherboard model
    hr_board_model = {}

    # motherboard vendor
    hr_board_vendor = {}

    # processors count
    hr_cpu_num = {}

    # virtual machine name (virtualbox, vmware, qemu)
    hr_virtual = {}

    # system version
    os_linux_ver = {}
 
    # user login
    ur_login = {}

    # user group name
    ur_group = {'official':True}

    # user fullname
    ur_fullname = {'official':True}

    # user home directory
    ur_home_path = {'official':True}

    # path to directory relative which perform joining templates to system files
    # (sandbox)
    cl_root_path = {'mode':"w", 'value':"/"}

    # path to directory which contain other system
    cl_chroot_path = {'mode':"r", 'value':"/"}

    # program action
    # install, uninstall, merge, domain, undomain, system, desktop
    cl_action = {}

    # program state
    # specifies addition to cl_pass_action for needing
    cl_pass_state = {}

    # User Jabber ID
    ur_jid = {'official':True}

    # user email
    ur_mail = {'official':True}

    # kernel uid get by uuid root device
    cl_kernel_uid = {}
    # variable for calculate-client and calculate-desktop packages
    # ip or domain name of CDS
    cl_remote_host = {'mode':'r', 'official':True}

    # this variable work with template function belong(package_name)
    # if the variable is defined then will use only template, which 
    # has package_name in belong equal value of this variable or
    # hasn't belong function
    # (package_name == value of cl_belong_pkg)
    cl_belong_pkg = {'mode':'r', 'official':True}

    # vertical resolution for X server
    os_x11_height = {'mode':"w"}

    # horizontal resolution for X server
    os_x11_width = {'mode':"w"}

    # the nearest standard size of image to current screen resolution
    os_x11_standart = {}

    # if computer is noteboot, the this variable containt its vendor
    hr_laptop = {}

    # video verdor name
    hr_video = {}

    # Video driver used by xorg
    os_x11_video_drv = {}

    # on/off composite mode
    os_x11_composite = {}

    # current system is scratch
    os_scratch = {}

    # programs have templates setup
    cl_merges = {}

    # (on or off) autoupdate config from install program
    cl_autoupdate_set = {'official':True, 'value': "off"}

    # The path to the module api, and additional parameters caluclate packages
    cl_api = {'official':True, 'value':{}}
