#-*- coding: utf-8 -*-

# Copyright 2012-2013 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import threading
import os
import hashlib, datetime

MAX = 10000

###################### sign client certificate ######################
def serv_post_client_request (request, data_path, ip, mac, client_type, \
                                client_certbase, cert_path):

    if not os.path.exists (cert_path + '/root.crt') or \
                    not os.path.exists (cert_path + '/root.key'):
        return '-1'

    if not os.path.exists(client_certbase):
        if not os.path.exists(data_path + '/client_certs/'):
            os.makedirs(data_path + '/client_certs/')
        fp = open(client_certbase, 'w')
        fp.close()

    # get ip
    curThread = threading.currentThread()
    try:
        ip = curThread.REMOTE_ADDR
    except:
        #print "EXCEPT ip = curThread.REMOTE_ADDR!!!"
        ip = 'localhost'

    # Finding Id for the current certificate
    ID_FILE = data_path + '/client_certs/id.int'

    if os.path.exists(ID_FILE):
        temp = open(ID_FILE, 'r').read()
        i = int(temp)
    else:
        count = 0
        with open(client_certbase) as fd:
            t = fd.read()
            # See each line
            for line in t.splitlines():
                count += 1

        count += 1
        fi = open(ID_FILE, 'w')
        fi.write(str(count))
        fi.close()
        i = count

    REQ_FILE = data_path + '/client_certs/' + str(i) + '.csr'

    # Record of request of the client in file REQ_FILE
    f = open(REQ_FILE, 'w')
    f.write(request)
    f.close()

    md5 = hashlib.md5()
    md5.update(request)
    md5sum = md5.hexdigest()
    date = datetime.datetime.now()

    # record
    fc = open(client_certbase,"a")
    fc.write("%d %s %s %s %s %s\n" %(i, md5sum, date, ip, mac, client_type))
    fc.close()

    # record next Id in id.int file
    i += 1
    fi = open(ID_FILE, 'w')
    temp = str(i)
    fi.write(temp)
    fi.close()
    return str(i-1)

def serv_get_client_cert (req_id, request, data_path, client_certbase, \
                          cert_path):
    REQ_FILE = data_path + '/client_certs/' + req_id + '.csr'
    if not os.path.exists(REQ_FILE):
        return '1'

    CERT_FILE = data_path + '/client_certs/' + req_id + '.crt'
    if not os.path.exists(CERT_FILE):
        return '2'

#    fp = open(REQ_FILE, 'r')
#    req = fp.read()
#    fp.close()

    # read client certificate in buffer
    fp = open(CERT_FILE, 'r')
    cert = fp.read()
    fp.close()

    md5 = hashlib.md5()
    md5.update(cert)
    md5sum = md5.hexdigest()
    date = datetime.datetime.now()

    ft = open(client_certbase + '_temp', 'w')
    # open file with server certificate certbase
    with open(client_certbase) as fd:
        t = fd.read()
        # See each line
        for line in t.splitlines():
            # and each word in line
            words = line.split(' ')
            if not words:
                continue
            if words[0] == req_id:
                try:
                    curThread = threading.currentThread()
                    ip = curThread.REMOTE_ADDR
                except:
                    ip = 'localhost'
                if not request == words[1]:
                    fd.close()
                    ft.close()
                    os.unlink(client_certbase + '_temp')
                    return '3'
                mac = words[5]
                client_type = words[6]
                line = ("%s %s %s %s %s %s" %(req_id, md5sum, date, ip, mac,\
                                                                client_type))
            ft.write(line + '\n')

    # copy all from temp file
    ft = open(client_certbase + '_temp', 'rb')
    fd = open(client_certbase, 'wb')
    ft.seek(0)
    fd.write(ft.read())
    ft.close()
    fd.close()
    # delete temp file
    os.unlink(client_certbase + '_temp')
    os.unlink(REQ_FILE)

    cert_file = os.path.join(cert_path, 'root.crt')
    if not os.path.exists(cert_file):
        open(cert_file, 'w')
    ca_root = open(cert_file, 'r').read()
    return [cert, ca_root]

###################### sign server certificate ######################
def serv_post_server_request (request, data_path,\
                        ip, mac, serv_certbase, cert_path):

    if not os.path.exists (cert_path + '/root.crt') or \
                    not os.path.exists (cert_path + '/root.key'):
        return '-1'

    if not os.path.exists(serv_certbase):
        if not os.path.exists(data_path + '/server_certs/'):
            os.makedirs(data_path + '/server_certs/')
        fp = open(serv_certbase, 'w')
        fp.close()

    # get ip
    curThread = threading.currentThread()
    try:
        ip = curThread.REMOTE_ADDR
    except:
        #print "EXCEPT ip = curThread.REMOTE_ADDR!!!!!!"
        ip = 'not_defined'

    # Finding Id for the current certificate
    ID_FILE = data_path + '/server_certs/id.int'

    if os.path.exists(ID_FILE):
        fi = open(ID_FILE, 'r')
        temp = fi.read()
        fi.close()
        i = int(temp)
    else:
        count = 0
        with open(serv_certbase) as fd:
            t = fd.read()
            # See each line
            for line in t.splitlines():
                count += 1

        count += 1
        fi = open(ID_FILE, 'w')
        fi.write(str(count))
        fi.close()
        i = count

    REQ_FILE = data_path + '/server_certs/' + str(i) + '.csr'

    # Record of request of the client in file REQ_FILE
    f = open(REQ_FILE, 'w')
    f.write(request)
    f.close()

    md5 = hashlib.md5()
    md5.update(request)
    md5sum = md5.hexdigest()
    date = datetime.datetime.now()

    # record
    fc = open(serv_certbase,"a")
    fc.write("%d %s %s %s %s\n" %(i, md5sum, date, ip, mac))
    fc.close()


    # record next Id in id.int file

    i += 1
    fi = open(ID_FILE, 'w')
    temp = str(i)
    fi.write(temp)
    fi.close()
    return str(i-1)

def serv_get_server_request (req_id, request, data_path, serv_certbase, \
                                                                cert_path):
    REQ_FILE = data_path + '/server_certs/' + req_id + '.csr'
    if not os.path.exists(REQ_FILE):
        return '1'

    CERT_FILE = data_path + '/server_certs/' + req_id + '.crt'
    if not os.path.exists(CERT_FILE):
        return '2'

#    fp = open(REQ_FILE, 'r')
#    req = fp.read()
#    fp.close()

    # read client certificate in buffer
    fp = open(CERT_FILE, 'r')
    cert = fp.read()
    fp.close()

    md5 = hashlib.md5()
    md5.update(cert)
    md5sum = md5.hexdigest()
    date = datetime.datetime.now()

    ft = open(serv_certbase + '_temp', 'w')
    # open file with server certificate certbase
    with open(serv_certbase) as fd:
        t = fd.read()
        # See each line
        for line in t.splitlines():
            # and each word in line
            words = line.split(' ')
            if words[0] == req_id:
                curThread = threading.currentThread()
                ip = curThread.REMOTE_ADDR
                if not request == words[1]:
                    fd.close()
                    ft.close()
                    os.unlink(serv_certbase + '_temp')
                    return '3'
                mac = words[5]
                line = ("%s %s %s %s %s" %(req_id, md5sum, date, ip, mac))
            ft.write(line + '\n')

    # copy all from temp file
    ft = open(serv_certbase + '_temp', 'rb')
    fd = open(serv_certbase, 'wb')
    ft.seek(0)
    fd.write(ft.read())
    ft.close()
    fd.close()
    # delete temp file
    os.unlink(serv_certbase + '_temp')
    os.unlink(REQ_FILE)

    if not os.path.exists(cert_path + '/ca_root.crt'):
        open(cert_path + '/ca_root.crt', 'w')
    ca_root = open(cert_path + '/ca_root.crt', 'r').read()
    return [cert, ca_root]
