/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2015-2020, NVIDIA CORPORATION.  All rights reserved.
 */

#ifndef TEGRA210_EMC_H
#define TEGRA210_EMC_H

#include <linux/clk.h>
#include <linux/clk/tegra.h>
#include <linux/io.h>
#include <linux/platform_device.h>

#define DVFS_FGCG_HIGH_SPEED_THRESHOLD				1000
#define IOBRICK_DCC_THRESHOLD					2400
#define DVFS_FGCG_MID_SPEED_THRESHOLD				600

#define EMC_STATUS_UPDATE_TIMEOUT				1000

/* register definitions */
#define EMC_INTSTATUS						0x0
#define EMC_INTSTATUS_CLKCHANGE_COMPLETE			BIT(4)
#define EMC_DBG							0x8
#define EMC_DBG_WRITE_MUX_ACTIVE				BIT(1)
#define EMC_DBG_WRITE_ACTIVE_ONLY				BIT(30)
#define EMC_CFG							0xc
#define EMC_CFG_DRAM_CLKSTOP_PD					BIT(31)
#define EMC_CFG_DRAM_CLKSTOP_SR					BIT(30)
#define EMC_CFG_DRAM_ACPD					BIT(29)
#define EMC_CFG_DYN_SELF_REF					BIT(28)
#define EMC_PIN							0x24
#define EMC_PIN_PIN_CKE						BIT(0)
#define EMC_PIN_PIN_CKEB					BIT(1)
#define EMC_PIN_PIN_CKE_PER_DEV					BIT(2)
#define EMC_TIMING_CONTROL					0x28
#define EMC_RC							0x2c
#define EMC_RFC							0x30
#define EMC_RAS							0x34
#define EMC_RP							0x38
#define EMC_R2W							0x3c
#define EMC_W2R							0x40
#define EMC_R2P							0x44
#define EMC_W2P							0x48
#define EMC_RD_RCD						0x4c
#define EMC_WR_RCD						0x50
#define EMC_RRD							0x54
#define EMC_REXT						0x58
#define EMC_WDV							0x5c
#define EMC_QUSE						0x60
#define EMC_QRST						0x64
#define EMC_QSAFE						0x68
#define EMC_RDV							0x6c
#define EMC_REFRESH						0x70
#define EMC_BURST_REFRESH_NUM					0x74
#define EMC_PDEX2WR						0x78
#define EMC_PDEX2RD						0x7c
#define EMC_PCHG2PDEN						0x80
#define EMC_ACT2PDEN						0x84
#define EMC_AR2PDEN						0x88
#define EMC_RW2PDEN						0x8c
#define EMC_TXSR						0x90
#define EMC_TCKE						0x94
#define EMC_TFAW						0x98
#define EMC_TRPAB						0x9c
#define EMC_TCLKSTABLE						0xa0
#define EMC_TCLKSTOP						0xa4
#define EMC_TREFBW						0xa8
#define EMC_TPPD						0xac
#define EMC_ODT_WRITE						0xb0
#define EMC_PDEX2MRR						0xb4
#define EMC_WEXT						0xb8
#define EMC_RFC_SLR						0xc0
#define EMC_MRS_WAIT_CNT2					0xc4
#define EMC_MRS_WAIT_CNT2_MRS_EXT2_WAIT_CNT_SHIFT		16
#define EMC_MRS_WAIT_CNT2_MRS_EXT1_WAIT_CNT_SHIFT		0
#define EMC_MRS_WAIT_CNT					0xc8
#define EMC_MRS_WAIT_CNT_SHORT_WAIT_SHIFT			0
#define EMC_MRS_WAIT_CNT_SHORT_WAIT_MASK			\
	(0x3FF << EMC_MRS_WAIT_CNT_SHORT_WAIT_SHIFT)

#define EMC_MRS							0xcc
#define EMC_EMRS						0xd0
#define EMC_EMRS_USE_EMRS_LONG_CNT				BIT(26)
#define EMC_REF							0xd4
#define  EMC_REF_REF_CMD					BIT(0)
#define EMC_SELF_REF						0xe0
#define EMC_MRW							0xe8
#define EMC_MRW_MRW_OP_SHIFT					0
#define EMC_MRW_MRW_OP_MASK					\
	(0xff << EMC_MRW_MRW_OP_SHIFT)
#define EMC_MRW_MRW_MA_SHIFT					16
#define EMC_MRW_USE_MRW_EXT_CNT					27
#define EMC_MRW_MRW_DEV_SELECTN_SHIFT				30

#define EMC_MRR							0xec
#define EMC_MRR_DEV_SEL_SHIFT					30
#define EMC_MRR_DEV_SEL_MASK					0x3
#define EMC_MRR_MA_SHIFT					16
#define EMC_MRR_MA_MASK						0xff
#define EMC_MRR_DATA_SHIFT					0
#define EMC_MRR_DATA_MASK					0xffff

#define EMC_FBIO_SPARE						0x100
#define EMC_FBIO_CFG5						0x104
#define EMC_FBIO_CFG5_DRAM_TYPE_SHIFT				0
#define EMC_FBIO_CFG5_DRAM_TYPE_MASK				\
	(0x3 << EMC_FBIO_CFG5_DRAM_TYPE_SHIFT)
#define EMC_FBIO_CFG5_CMD_TX_DIS				BIT(8)

#define EMC_PDEX2CKE						0x118
#define EMC_CKE2PDEN						0x11c
#define EMC_MPC							0x128
#define EMC_EMRS2						0x12c
#define EMC_EMRS2_USE_EMRS2_LONG_CNT				BIT(26)
#define EMC_MRW2						0x134
#define EMC_MRW3						0x138
#define EMC_MRW4						0x13c
#define EMC_R2R							0x144
#define EMC_EINPUT						0x14c
#define EMC_EINPUT_DURATION					0x150
#define EMC_PUTERM_EXTRA					0x154
#define EMC_TCKESR						0x158
#define EMC_TPD							0x15c
#define EMC_AUTO_CAL_CONFIG					0x2a4
#define EMC_AUTO_CAL_CONFIG_AUTO_CAL_COMPUTE_START		BIT(0)
#define EMC_AUTO_CAL_CONFIG_AUTO_CAL_MEASURE_STALL		BIT(9)
#define EMC_AUTO_CAL_CONFIG_AUTO_CAL_UPDATE_STALL		BIT(10)
#define EMC_AUTO_CAL_CONFIG_AUTO_CAL_ENABLE			BIT(29)
#define EMC_AUTO_CAL_CONFIG_AUTO_CAL_START			BIT(31)
#define EMC_EMC_STATUS						0x2b4
#define EMC_EMC_STATUS_MRR_DIVLD				BIT(20)
#define EMC_EMC_STATUS_TIMING_UPDATE_STALLED			BIT(23)
#define EMC_EMC_STATUS_DRAM_IN_POWERDOWN_SHIFT			4
#define EMC_EMC_STATUS_DRAM_IN_POWERDOWN_MASK			\
	(0x3 << EMC_EMC_STATUS_DRAM_IN_POWERDOWN_SHIFT)
#define EMC_EMC_STATUS_DRAM_IN_SELF_REFRESH_SHIFT		8
#define EMC_EMC_STATUS_DRAM_IN_SELF_REFRESH_MASK		\
	(0x3 << EMC_EMC_STATUS_DRAM_IN_SELF_REFRESH_SHIFT)

#define EMC_CFG_2						0x2b8
#define EMC_CFG_DIG_DLL						0x2bc
#define EMC_CFG_DIG_DLL_CFG_DLL_EN				BIT(0)
#define EMC_CFG_DIG_DLL_CFG_DLL_STALL_ALL_UNTIL_LOCK		BIT(1)
#define EMC_CFG_DIG_DLL_CFG_DLL_STALL_ALL_TRAFFIC		BIT(3)
#define EMC_CFG_DIG_DLL_CFG_DLL_STALL_RW_UNTIL_LOCK		BIT(4)
#define EMC_CFG_DIG_DLL_CFG_DLL_MODE_SHIFT			6
#define EMC_CFG_DIG_DLL_CFG_DLL_MODE_MASK			\
	(0x3 << EMC_CFG_DIG_DLL_CFG_DLL_MODE_SHIFT)
#define EMC_CFG_DIG_DLL_CFG_DLL_LOCK_LIMIT_SHIFT		8
#define EMC_CFG_DIG_DLL_CFG_DLL_LOCK_LIMIT_MASK			\
	(0x7 << EMC_CFG_DIG_DLL_CFG_DLL_LOCK_LIMIT_SHIFT)

#define EMC_CFG_DIG_DLL_PERIOD					0x2c0
#define EMC_DIG_DLL_STATUS					0x2c4
#define EMC_DIG_DLL_STATUS_DLL_LOCK				BIT(15)
#define EMC_DIG_DLL_STATUS_DLL_PRIV_UPDATED			BIT(17)
#define EMC_DIG_DLL_STATUS_DLL_OUT_SHIFT			0
#define EMC_DIG_DLL_STATUS_DLL_OUT_MASK				\
	(0x7ff << EMC_DIG_DLL_STATUS_DLL_OUT_SHIFT)

#define EMC_CFG_DIG_DLL_1					0x2c8
#define EMC_RDV_MASK						0x2cc
#define EMC_WDV_MASK						0x2d0
#define EMC_RDV_EARLY_MASK					0x2d4
#define EMC_RDV_EARLY						0x2d8
#define EMC_AUTO_CAL_CONFIG8					0x2dc
#define EMC_ZCAL_INTERVAL					0x2e0
#define EMC_ZCAL_WAIT_CNT					0x2e4
#define EMC_ZCAL_WAIT_CNT_ZCAL_WAIT_CNT_MASK			0x7ff
#define EMC_ZCAL_WAIT_CNT_ZCAL_WAIT_CNT_SHIFT			0

#define EMC_ZQ_CAL						0x2ec
#define EMC_ZQ_CAL_DEV_SEL_SHIFT				30
#define EMC_ZQ_CAL_LONG						BIT(4)
#define EMC_ZQ_CAL_ZQ_LATCH_CMD					BIT(1)
#define EMC_ZQ_CAL_ZQ_CAL_CMD					BIT(0)
#define EMC_FDPD_CTRL_DQ					0x310
#define EMC_FDPD_CTRL_CMD					0x314
#define EMC_PMACRO_CMD_BRICK_CTRL_FDPD				0x318
#define EMC_PMACRO_DATA_BRICK_CTRL_FDPD				0x31c
#define EMC_PMACRO_BRICK_CTRL_RFU1				0x330
#define EMC_PMACRO_BRICK_CTRL_RFU2				0x334
#define EMC_TR_TIMING_0						0x3b4
#define EMC_TR_CTRL_1						0x3bc
#define EMC_TR_RDV						0x3c4
#define EMC_STALL_THEN_EXE_AFTER_CLKCHANGE			0x3cc
#define EMC_SEL_DPD_CTRL					0x3d8
#define EMC_SEL_DPD_CTRL_DATA_SEL_DPD_EN			BIT(8)
#define EMC_SEL_DPD_CTRL_ODT_SEL_DPD_EN				BIT(5)
#define EMC_SEL_DPD_CTRL_RESET_SEL_DPD_EN			BIT(4)
#define EMC_SEL_DPD_CTRL_CA_SEL_DPD_EN				BIT(3)
#define EMC_SEL_DPD_CTRL_CLK_SEL_DPD_EN				BIT(2)
#define EMC_PRE_REFRESH_REQ_CNT					0x3dc
#define EMC_DYN_SELF_REF_CONTROL				0x3e0
#define EMC_TXSRDLL						0x3e4
#define EMC_CCFIFO_ADDR						0x3e8
#define  EMC_CCFIFO_ADDR_STALL_BY_1 (1 << 31)
#define  EMC_CCFIFO_ADDR_STALL(x) (((x) & 0x7fff) << 16)
#define  EMC_CCFIFO_ADDR_OFFSET(x) ((x) & 0xffff)
#define EMC_CCFIFO_DATA						0x3ec
#define EMC_TR_QPOP						0x3f4
#define EMC_TR_RDV_MASK						0x3f8
#define EMC_TR_QSAFE						0x3fc
#define EMC_TR_QRST						0x400
#define EMC_ISSUE_QRST						0x428
#define EMC_AUTO_CAL_CONFIG2					0x458
#define EMC_AUTO_CAL_CONFIG3					0x45c
#define EMC_TR_DVFS						0x460
#define EMC_AUTO_CAL_CHANNEL					0x464
#define EMC_IBDLY						0x468
#define EMC_OBDLY						0x46c
#define EMC_TXDSRVTTGEN						0x480
#define EMC_WE_DURATION						0x48c
#define EMC_WS_DURATION						0x490
#define EMC_WEV							0x494
#define EMC_WSV							0x498
#define EMC_CFG_3						0x49c
#define EMC_MRW6						0x4a4
#define EMC_MRW7						0x4a8
#define EMC_MRW8						0x4ac
#define EMC_MRW9						0x4b0
#define EMC_MRW10						0x4b4
#define EMC_MRW11						0x4b8
#define EMC_MRW12						0x4bc
#define EMC_MRW13						0x4c0
#define EMC_MRW14						0x4c4
#define EMC_MRW15						0x4d0
#define EMC_CFG_SYNC						0x4d4
#define EMC_FDPD_CTRL_CMD_NO_RAMP				0x4d8
#define EMC_FDPD_CTRL_CMD_NO_RAMP_CMD_DPD_NO_RAMP_ENABLE	BIT(0)
#define EMC_WDV_CHK						0x4e0
#define EMC_CFG_PIPE_2						0x554
#define EMC_CFG_PIPE_CLK					0x558
#define EMC_CFG_PIPE_CLK_CLK_ALWAYS_ON				BIT(0)
#define EMC_CFG_PIPE_1						0x55c
#define EMC_CFG_PIPE						0x560
#define EMC_QPOP						0x564
#define EMC_QUSE_WIDTH						0x568
#define EMC_PUTERM_WIDTH					0x56c
#define EMC_AUTO_CAL_CONFIG7					0x574
#define EMC_REFCTRL2						0x580
#define EMC_FBIO_CFG7						0x584
#define EMC_FBIO_CFG7_CH0_ENABLE				BIT(1)
#define EMC_FBIO_CFG7_CH1_ENABLE				BIT(2)
#define EMC_DATA_BRLSHFT_0					0x588
#define EMC_DATA_BRLSHFT_0_RANK0_BYTE7_DATA_BRLSHFT_SHIFT	21
#define EMC_DATA_BRLSHFT_0_RANK0_BYTE7_DATA_BRLSHFT_MASK	\
	(0x7 << EMC_DATA_BRLSHFT_0_RANK0_BYTE7_DATA_BRLSHFT_SHIFT)
#define EMC_DATA_BRLSHFT_0_RANK0_BYTE6_DATA_BRLSHFT_SHIFT	18
#define EMC_DATA_BRLSHFT_0_RANK0_BYTE6_DATA_BRLSHFT_MASK	\
	(0x7 << EMC_DATA_BRLSHFT_0_RANK0_BYTE6_DATA_BRLSHFT_SHIFT)
#define EMC_DATA_BRLSHFT_0_RANK0_BYTE5_DATA_BRLSHFT_SHIFT	15
#define EMC_DATA_BRLSHFT_0_RANK0_BYTE5_DATA_BRLSHFT_MASK	\
	(0x7 << EMC_DATA_BRLSHFT_0_RANK0_BYTE5_DATA_BRLSHFT_SHIFT)
#define EMC_DATA_BRLSHFT_0_RANK0_BYTE4_DATA_BRLSHFT_SHIFT	12
#define EMC_DATA_BRLSHFT_0_RANK0_BYTE4_DATA_BRLSHFT_MASK	\
	(0x7 << EMC_DATA_BRLSHFT_0_RANK0_BYTE4_DATA_BRLSHFT_SHIFT)
#define EMC_DATA_BRLSHFT_0_RANK0_BYTE3_DATA_BRLSHFT_SHIFT	9
#define EMC_DATA_BRLSHFT_0_RANK0_BYTE3_DATA_BRLSHFT_MASK	\
	(0x7 << EMC_DATA_BRLSHFT_0_RANK0_BYTE3_DATA_BRLSHFT_SHIFT)
#define EMC_DATA_BRLSHFT_0_RANK0_BYTE2_DATA_BRLSHFT_SHIFT	6
#define EMC_DATA_BRLSHFT_0_RANK0_BYTE2_DATA_BRLSHFT_MASK	\
	(0x7 << EMC_DATA_BRLSHFT_0_RANK0_BYTE2_DATA_BRLSHFT_SHIFT)
#define EMC_DATA_BRLSHFT_0_RANK0_BYTE1_DATA_BRLSHFT_SHIFT	3
#define EMC_DATA_BRLSHFT_0_RANK0_BYTE1_DATA_BRLSHFT_MASK	\
	(0x7 << EMC_DATA_BRLSHFT_0_RANK0_BYTE1_DATA_BRLSHFT_SHIFT)
#define EMC_DATA_BRLSHFT_0_RANK0_BYTE0_DATA_BRLSHFT_SHIFT	0
#define EMC_DATA_BRLSHFT_0_RANK0_BYTE0_DATA_BRLSHFT_MASK	\
	(0x7 << EMC_DATA_BRLSHFT_0_RANK0_BYTE0_DATA_BRLSHFT_SHIFT)

#define EMC_DATA_BRLSHFT_1					0x58c
#define EMC_DATA_BRLSHFT_1_RANK1_BYTE7_DATA_BRLSHFT_SHIFT	21
#define EMC_DATA_BRLSHFT_1_RANK1_BYTE7_DATA_BRLSHFT_MASK	\
	(0x7 << EMC_DATA_BRLSHFT_1_RANK1_BYTE7_DATA_BRLSHFT_SHIFT)
#define EMC_DATA_BRLSHFT_1_RANK1_BYTE6_DATA_BRLSHFT_SHIFT	18
#define EMC_DATA_BRLSHFT_1_RANK1_BYTE6_DATA_BRLSHFT_MASK	\
	(0x7 << EMC_DATA_BRLSHFT_1_RANK1_BYTE6_DATA_BRLSHFT_SHIFT)
#define EMC_DATA_BRLSHFT_1_RANK1_BYTE5_DATA_BRLSHFT_SHIFT	15
#define EMC_DATA_BRLSHFT_1_RANK1_BYTE5_DATA_BRLSHFT_MASK	\
	(0x7 << EMC_DATA_BRLSHFT_1_RANK1_BYTE5_DATA_BRLSHFT_SHIFT)
#define EMC_DATA_BRLSHFT_1_RANK1_BYTE4_DATA_BRLSHFT_SHIFT	12
#define EMC_DATA_BRLSHFT_1_RANK1_BYTE4_DATA_BRLSHFT_MASK	\
	(0x7 << EMC_DATA_BRLSHFT_1_RANK1_BYTE4_DATA_BRLSHFT_SHIFT)
#define EMC_DATA_BRLSHFT_1_RANK1_BYTE3_DATA_BRLSHFT_SHIFT	9
#define EMC_DATA_BRLSHFT_1_RANK1_BYTE3_DATA_BRLSHFT_MASK	\
	(0x7 << EMC_DATA_BRLSHFT_1_RANK1_BYTE3_DATA_BRLSHFT_SHIFT)
#define EMC_DATA_BRLSHFT_1_RANK1_BYTE2_DATA_BRLSHFT_SHIFT	6
#define EMC_DATA_BRLSHFT_1_RANK1_BYTE2_DATA_BRLSHFT_MASK	\
	(0x7 << EMC_DATA_BRLSHFT_1_RANK1_BYTE2_DATA_BRLSHFT_SHIFT)
#define EMC_DATA_BRLSHFT_1_RANK1_BYTE1_DATA_BRLSHFT_SHIFT	3
#define EMC_DATA_BRLSHFT_1_RANK1_BYTE1_DATA_BRLSHFT_MASK	\
	(0x7 << EMC_DATA_BRLSHFT_1_RANK1_BYTE1_DATA_BRLSHFT_SHIFT)
#define EMC_DATA_BRLSHFT_1_RANK1_BYTE0_DATA_BRLSHFT_SHIFT	0
#define EMC_DATA_BRLSHFT_1_RANK1_BYTE0_DATA_BRLSHFT_MASK	\
	(0x7 << EMC_DATA_BRLSHFT_1_RANK1_BYTE0_DATA_BRLSHFT_SHIFT)

#define EMC_RFCPB						0x590
#define EMC_DQS_BRLSHFT_0					0x594
#define EMC_DQS_BRLSHFT_1					0x598
#define EMC_CMD_BRLSHFT_0					0x59c
#define EMC_CMD_BRLSHFT_1					0x5a0
#define EMC_CMD_BRLSHFT_2					0x5a4
#define EMC_CMD_BRLSHFT_3					0x5a8
#define EMC_QUSE_BRLSHFT_0					0x5ac
#define EMC_AUTO_CAL_CONFIG4					0x5b0
#define EMC_AUTO_CAL_CONFIG5					0x5b4
#define EMC_QUSE_BRLSHFT_1					0x5b8
#define EMC_QUSE_BRLSHFT_2					0x5bc
#define EMC_CCDMW						0x5c0
#define EMC_QUSE_BRLSHFT_3					0x5c4
#define EMC_AUTO_CAL_CONFIG6					0x5cc
#define EMC_DLL_CFG_0						0x5e4
#define EMC_DLL_CFG_1						0x5e8
#define EMC_DLL_CFG_1_DDLLCAL_CTRL_START_TRIM_SHIFT		10
#define EMC_DLL_CFG_1_DDLLCAL_CTRL_START_TRIM_MASK		\
	(0x7ff << EMC_DLL_CFG_1_DDLLCAL_CTRL_START_TRIM_SHIFT)

#define EMC_CONFIG_SAMPLE_DELAY					0x5f0
#define EMC_CFG_UPDATE						0x5f4
#define EMC_CFG_UPDATE_UPDATE_DLL_IN_UPDATE_SHIFT		9
#define EMC_CFG_UPDATE_UPDATE_DLL_IN_UPDATE_MASK		\
	(0x3 << EMC_CFG_UPDATE_UPDATE_DLL_IN_UPDATE_SHIFT)

#define EMC_PMACRO_QUSE_DDLL_RANK0_0				0x600
#define EMC_PMACRO_QUSE_DDLL_RANK0_1				0x604
#define EMC_PMACRO_QUSE_DDLL_RANK0_2				0x608
#define EMC_PMACRO_QUSE_DDLL_RANK0_3				0x60c
#define EMC_PMACRO_QUSE_DDLL_RANK0_4				0x610
#define EMC_PMACRO_QUSE_DDLL_RANK0_5				0x614
#define EMC_PMACRO_QUSE_DDLL_RANK1_0				0x620
#define EMC_PMACRO_QUSE_DDLL_RANK1_1				0x624
#define EMC_PMACRO_QUSE_DDLL_RANK1_2				0x628
#define EMC_PMACRO_QUSE_DDLL_RANK1_3				0x62c
#define EMC_PMACRO_QUSE_DDLL_RANK1_4				0x630
#define EMC_PMACRO_QUSE_DDLL_RANK1_5				0x634
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_0			0x640
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_0_OB_DDLL_LONG_DQ_RANK0_BYTE1_SHIFT \
	16
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_0_OB_DDLL_LONG_DQ_RANK0_BYTE1_MASK  \
	(0x3ff <<							     \
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_0_OB_DDLL_LONG_DQ_RANK0_BYTE1_SHIFT)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_0_OB_DDLL_LONG_DQ_RANK0_BYTE0_SHIFT \
	0
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_0_OB_DDLL_LONG_DQ_RANK0_BYTE0_MASK \
	(0x3ff <<							    \
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_0_OB_DDLL_LONG_DQ_RANK0_BYTE0_SHIFT)

#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_1			0x644
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_1_OB_DDLL_LONG_DQ_RANK0_BYTE3_SHIFT \
	16
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_1_OB_DDLL_LONG_DQ_RANK0_BYTE3_MASK  \
	(0x3ff <<							     \
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_1_OB_DDLL_LONG_DQ_RANK0_BYTE3_SHIFT)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_1_OB_DDLL_LONG_DQ_RANK0_BYTE2_SHIFT \
	0
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_1_OB_DDLL_LONG_DQ_RANK0_BYTE2_MASK  \
	(0x3ff <<							     \
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_1_OB_DDLL_LONG_DQ_RANK0_BYTE2_SHIFT)

#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_2			0x648
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_2_OB_DDLL_LONG_DQ_RANK0_BYTE5_SHIFT  \
	16
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_2_OB_DDLL_LONG_DQ_RANK0_BYTE5_MASK  \
	(0x3ff <<							     \
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_2_OB_DDLL_LONG_DQ_RANK0_BYTE5_SHIFT)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_2_OB_DDLL_LONG_DQ_RANK0_BYTE4_SHIFT \
	0
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_2_OB_DDLL_LONG_DQ_RANK0_BYTE4_MASK  \
	(0x3ff <<							     \
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_2_OB_DDLL_LONG_DQ_RANK0_BYTE4_SHIFT)

#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_3			0x64c
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_3_OB_DDLL_LONG_DQ_RANK0_BYTE7_SHIFT \
	16
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_3_OB_DDLL_LONG_DQ_RANK0_BYTE7_MASK  \
	(0x3ff <<							     \
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_3_OB_DDLL_LONG_DQ_RANK0_BYTE7_SHIFT)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_3_OB_DDLL_LONG_DQ_RANK0_BYTE6_SHIFT \
	0
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_3_OB_DDLL_LONG_DQ_RANK0_BYTE6_MASK  \
	(0x3ff <<							     \
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_3_OB_DDLL_LONG_DQ_RANK0_BYTE6_SHIFT)

#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_4			0x650
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_5			0x654
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_0			0x660
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_0_OB_DDLL_LONG_DQ_RANK1_BYTE1_SHIFT \
	16
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_0_OB_DDLL_LONG_DQ_RANK1_BYTE1_MASK  \
	(0x3ff <<							     \
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_0_OB_DDLL_LONG_DQ_RANK1_BYTE1_SHIFT)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_0_OB_DDLL_LONG_DQ_RANK1_BYTE0_SHIFT \
	0
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_0_OB_DDLL_LONG_DQ_RANK1_BYTE0_MASK  \
	(0x3ff <<							     \
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_0_OB_DDLL_LONG_DQ_RANK1_BYTE0_SHIFT)

#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_1			0x664
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_1_OB_DDLL_LONG_DQ_RANK1_BYTE3_SHIFT \
	16
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_1_OB_DDLL_LONG_DQ_RANK1_BYTE3_MASK  \
	(0x3ff <<							     \
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_1_OB_DDLL_LONG_DQ_RANK1_BYTE3_SHIFT)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_1_OB_DDLL_LONG_DQ_RANK1_BYTE2_SHIFT \
	0
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_1_OB_DDLL_LONG_DQ_RANK1_BYTE2_MASK  \
	(0x3ff <<							     \
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_1_OB_DDLL_LONG_DQ_RANK1_BYTE2_SHIFT)

#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_2			0x668
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_2_OB_DDLL_LONG_DQ_RANK1_BYTE5_SHIFT \
	16
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_2_OB_DDLL_LONG_DQ_RANK1_BYTE5_MASK  \
	(0x3ff <<							     \
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_2_OB_DDLL_LONG_DQ_RANK1_BYTE5_SHIFT)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_2_OB_DDLL_LONG_DQ_RANK1_BYTE4_SHIFT \
	0
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_2_OB_DDLL_LONG_DQ_RANK1_BYTE4_MASK  \
	(0x3ff <<							     \
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_2_OB_DDLL_LONG_DQ_RANK1_BYTE4_SHIFT)

#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_3			0x66c
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_3_OB_DDLL_LONG_DQ_RANK1_BYTE7_SHIFT \
	16
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_3_OB_DDLL_LONG_DQ_RANK1_BYTE7_MASK  \
	(0x3ff <<							     \
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_3_OB_DDLL_LONG_DQ_RANK1_BYTE7_SHIFT)
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_3_OB_DDLL_LONG_DQ_RANK1_BYTE6_SHIFT \
	0
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_3_OB_DDLL_LONG_DQ_RANK1_BYTE6_MASK  \
	(0x3ff <<							     \
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_3_OB_DDLL_LONG_DQ_RANK1_BYTE6_SHIFT)

#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_4			0x670
#define EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_5			0x674
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK0_0			0x680
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK0_1			0x684
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK0_2			0x688
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK0_3			0x68c
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK0_4			0x690
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK0_5			0x694
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK1_0			0x6a0
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK1_1			0x6a4
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK1_2			0x6a8
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK1_3			0x6ac
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK1_4			0x6b0
#define EMC_PMACRO_OB_DDLL_LONG_DQS_RANK1_5			0x6b4
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK0_0			0x6c0
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK0_1			0x6c4
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK0_2			0x6c8
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK0_3			0x6cc
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK1_0			0x6e0
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK1_1			0x6e4
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK1_2			0x6e8
#define EMC_PMACRO_IB_DDLL_LONG_DQS_RANK1_3			0x6ec
#define EMC_PMACRO_TX_PWRD_0					0x720
#define EMC_PMACRO_TX_PWRD_1					0x724
#define EMC_PMACRO_TX_PWRD_2					0x728
#define EMC_PMACRO_TX_PWRD_3					0x72c
#define EMC_PMACRO_TX_PWRD_4					0x730
#define EMC_PMACRO_TX_PWRD_5					0x734
#define EMC_PMACRO_TX_SEL_CLK_SRC_0				0x740
#define EMC_PMACRO_TX_SEL_CLK_SRC_1				0x744
#define EMC_PMACRO_TX_SEL_CLK_SRC_3				0x74c
#define EMC_PMACRO_TX_SEL_CLK_SRC_2				0x748
#define EMC_PMACRO_TX_SEL_CLK_SRC_4				0x750
#define EMC_PMACRO_TX_SEL_CLK_SRC_5				0x754
#define EMC_PMACRO_DDLL_BYPASS					0x760
#define EMC_PMACRO_DDLL_PWRD_0					0x770
#define EMC_PMACRO_DDLL_PWRD_1					0x774
#define EMC_PMACRO_DDLL_PWRD_2					0x778
#define EMC_PMACRO_CMD_CTRL_0					0x780
#define EMC_PMACRO_CMD_CTRL_1					0x784
#define EMC_PMACRO_CMD_CTRL_2					0x788
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE0_0		0x800
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE0_1		0x804
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE0_2		0x808
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE0_3		0x80c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE1_0		0x810
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE1_1		0x814
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE1_2		0x818
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE1_3		0x81c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE2_0		0x820
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE2_1		0x824
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE2_2		0x828
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE2_3		0x82c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE3_0		0x830
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE3_1		0x834
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE3_2		0x838
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE3_3		0x83c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE4_0		0x840
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE4_1		0x844
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE4_2		0x848
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE4_3		0x84c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE5_0		0x850
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE5_1		0x854
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE5_2		0x858
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE5_3		0x85c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE6_0		0x860
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE6_1		0x864
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE6_2		0x868
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE6_3		0x86c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE7_0		0x870
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE7_1		0x874
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE7_2		0x878
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_BYTE7_3		0x87c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD0_0		0x880
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD0_1		0x884
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD0_2		0x888
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD0_3		0x88c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD1_0		0x890
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD1_1		0x894
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD1_2		0x898
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD1_3		0x89c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD2_0		0x8a0
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD2_1		0x8a4
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD2_2		0x8a8
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD2_3		0x8ac
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD3_0		0x8b0
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD3_1		0x8b4
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD3_2		0x8b8
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK0_CMD3_3		0x8bc
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE0_0		0x900
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE0_1		0x904
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE0_2		0x908
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE0_3		0x90c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE1_0		0x910
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE1_1		0x914
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE1_2		0x918
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE1_3		0x91c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE2_0		0x920
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE2_1		0x924
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE2_2		0x928
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE2_3		0x92c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE3_0		0x930
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE3_1		0x934
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE3_2		0x938
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE3_3		0x93c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE4_0		0x940
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE4_1		0x944
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE4_2		0x948
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE4_3		0x94c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE5_0		0x950
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE5_1		0x954
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE5_2		0x958
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE5_3		0x95c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE6_0		0x960
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE6_1		0x964
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE6_2		0x968
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE6_3		0x96c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE7_0		0x970
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE7_1		0x974
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE7_2		0x978
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_BYTE7_3		0x97c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD0_0		0x980
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD0_1		0x984
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD0_2		0x988
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD0_3		0x98c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD1_0		0x990
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD1_1		0x994
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD1_2		0x998
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD1_3		0x99c
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD2_0		0x9a0
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD2_1		0x9a4
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD2_2		0x9a8
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD2_3		0x9ac
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD3_0		0x9b0
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD3_1		0x9b4
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD3_2		0x9b8
#define EMC_PMACRO_OB_DDLL_SHORT_DQ_RANK1_CMD3_3		0x9bc
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE0_0		0xa00
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE0_1		0xa04
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE0_2		0xa08
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE1_0		0xa10
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE1_1		0xa14
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE1_2		0xa18
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE2_0		0xa20
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE2_1		0xa24
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE2_2		0xa28
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE3_0		0xa30
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE3_1		0xa34
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE3_2		0xa38
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE4_0		0xa40
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE4_1		0xa44
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE4_2		0xa48
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE5_0		0xa50
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE5_1		0xa54
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE5_2		0xa58
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE6_0		0xa60
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE6_1		0xa64
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE6_2		0xa68
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE7_0		0xa70
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE7_1		0xa74
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK0_BYTE7_2		0xa78
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE0_0		0xb00
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE0_1		0xb04
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE0_2		0xb08
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE1_0		0xb10
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE1_1		0xb14
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE1_2		0xb18
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE2_0		0xb20
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE2_1		0xb24
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE2_2		0xb28
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE3_0		0xb30
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE3_1		0xb34
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE3_2		0xb38
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE4_0		0xb40
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE4_1		0xb44
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE4_2		0xb48
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE5_0		0xb50
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE5_1		0xb54
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE5_2		0xb58
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE6_0		0xb60
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE6_1		0xb64
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE6_2		0xb68
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE7_0		0xb70
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE7_1		0xb74
#define EMC_PMACRO_IB_DDLL_SHORT_DQ_RANK1_BYTE7_2		0xb78
#define EMC_PMACRO_IB_VREF_DQ_0					0xbe0
#define EMC_PMACRO_IB_VREF_DQ_1					0xbe4
#define EMC_PMACRO_IB_VREF_DQS_0				0xbf0
#define EMC_PMACRO_IB_VREF_DQS_1				0xbf4
#define EMC_PMACRO_DDLL_LONG_CMD_0				0xc00
#define EMC_PMACRO_DDLL_LONG_CMD_1				0xc04
#define EMC_PMACRO_DDLL_LONG_CMD_2				0xc08
#define EMC_PMACRO_DDLL_LONG_CMD_3				0xc0c
#define EMC_PMACRO_DDLL_LONG_CMD_4				0xc10
#define EMC_PMACRO_DDLL_LONG_CMD_5				0xc14
#define EMC_PMACRO_DDLL_SHORT_CMD_0				0xc20
#define EMC_PMACRO_DDLL_SHORT_CMD_1				0xc24
#define EMC_PMACRO_DDLL_SHORT_CMD_2				0xc28
#define EMC_PMACRO_CFG_PM_GLOBAL_0				0xc30
#define EMC_PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_BYTE0		BIT(16)
#define EMC_PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_BYTE1		BIT(17)
#define EMC_PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_BYTE2		BIT(18)
#define EMC_PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_BYTE3		BIT(19)
#define EMC_PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_BYTE4		BIT(20)
#define EMC_PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_BYTE5		BIT(21)
#define EMC_PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_BYTE6		BIT(22)
#define EMC_PMACRO_CFG_PM_GLOBAL_0_DISABLE_CFG_BYTE7		BIT(23)
#define EMC_PMACRO_VTTGEN_CTRL_0				0xc34
#define EMC_PMACRO_VTTGEN_CTRL_1				0xc38
#define EMC_PMACRO_BG_BIAS_CTRL_0				0xc3c
#define EMC_PMACRO_BG_BIAS_CTRL_0_BG_E_PWRD			BIT(0)
#define EMC_PMACRO_BG_BIAS_CTRL_0_BGLP_E_PWRD			BIT(2)
#define EMC_PMACRO_PAD_CFG_CTRL					0xc40
#define EMC_PMACRO_ZCTRL					0xc44
#define EMC_PMACRO_CMD_PAD_RX_CTRL				0xc50
#define EMC_PMACRO_DATA_PAD_RX_CTRL				0xc54
#define EMC_PMACRO_CMD_RX_TERM_MODE				0xc58
#define EMC_PMACRO_DATA_RX_TERM_MODE				0xc5c
#define EMC_PMACRO_CMD_PAD_TX_CTRL				0xc60
#define EMC_PMACRO_CMD_PAD_TX_CTRL_CMD_DQ_TX_E_DCC		BIT(1)
#define EMC_PMACRO_CMD_PAD_TX_CTRL_CMD_DQSP_TX_E_DCC		BIT(9)
#define EMC_PMACRO_CMD_PAD_TX_CTRL_CMD_DQSN_TX_E_DCC		BIT(16)
#define EMC_PMACRO_CMD_PAD_TX_CTRL_CMD_CMD_TX_E_DCC		BIT(24)
#define EMC_PMACRO_CMD_PAD_TX_CTRL_CMD_DQ_TX_DRVFORCEON		BIT(26)

#define EMC_PMACRO_DATA_PAD_TX_CTRL				0xc64
#define EMC_PMACRO_DATA_PAD_TX_CTRL_DATA_DQ_E_IVREF		BIT(0)
#define EMC_PMACRO_DATA_PAD_TX_CTRL_DATA_DQ_TX_E_DCC		BIT(1)
#define EMC_PMACRO_DATA_PAD_TX_CTRL_DATA_DQS_E_IVREF		BIT(8)
#define EMC_PMACRO_DATA_PAD_TX_CTRL_DATA_DQSP_TX_E_DCC		BIT(9)
#define EMC_PMACRO_DATA_PAD_TX_CTRL_DATA_DQSN_TX_E_DCC		BIT(16)
#define EMC_PMACRO_DATA_PAD_TX_CTRL_DATA_CMD_TX_E_DCC		BIT(24)

#define EMC_PMACRO_COMMON_PAD_TX_CTRL				0xc68
#define EMC_PMACRO_AUTOCAL_CFG_COMMON				0xc78
#define EMC_PMACRO_AUTOCAL_CFG_COMMON_E_CAL_BYPASS_DVFS		BIT(16)
#define EMC_PMACRO_VTTGEN_CTRL_2				0xcf0
#define EMC_PMACRO_IB_RXRT					0xcf4
#define EMC_PMACRO_TRAINING_CTRL_0				0xcf8
#define EMC_PMACRO_TRAINING_CTRL_0_CH0_TRAINING_E_WRPTR		BIT(3)
#define EMC_PMACRO_TRAINING_CTRL_1				0xcfc
#define EMC_PMACRO_TRAINING_CTRL_1_CH1_TRAINING_E_WRPTR		BIT(3)
#define EMC_TRAINING_CTRL					0xe04
#define EMC_TRAINING_QUSE_CORS_CTRL				0xe0c
#define EMC_TRAINING_QUSE_FINE_CTRL				0xe10
#define EMC_TRAINING_QUSE_CTRL_MISC				0xe14
#define EMC_TRAINING_WRITE_FINE_CTRL				0xe18
#define EMC_TRAINING_WRITE_CTRL_MISC				0xe1c
#define EMC_TRAINING_WRITE_VREF_CTRL				0xe20
#define EMC_TRAINING_READ_FINE_CTRL				0xe24
#define EMC_TRAINING_READ_CTRL_MISC				0xe28
#define EMC_TRAINING_READ_VREF_CTRL				0xe2c
#define EMC_TRAINING_CA_FINE_CTRL				0xe30
#define EMC_TRAINING_CA_CTRL_MISC				0xe34
#define EMC_TRAINING_CA_CTRL_MISC1				0xe38
#define EMC_TRAINING_CA_VREF_CTRL				0xe3c
#define EMC_TRAINING_SETTLE					0xe44
#define EMC_TRAINING_MPC					0xe5c
#define EMC_TRAINING_VREF_SETTLE				0xe6c
#define EMC_TRAINING_QUSE_VREF_CTRL				0xed0
#define EMC_TRAINING_OPT_DQS_IB_VREF_RANK0			0xed4
#define EMC_TRAINING_OPT_DQS_IB_VREF_RANK1			0xed8

#define EMC_COPY_TABLE_PARAM_PERIODIC_FIELDS			BIT(0)
#define EMC_COPY_TABLE_PARAM_TRIM_REGS				BIT(1)

enum burst_regs_list {
	EMC_RP_INDEX = 6,
	EMC_R2P_INDEX = 9,
	EMC_W2P_INDEX,
	EMC_MRW6_INDEX = 31,
	EMC_REFRESH_INDEX = 41,
	EMC_PRE_REFRESH_REQ_CNT_INDEX = 43,
	EMC_TRPAB_INDEX = 59,
	EMC_MRW7_INDEX = 62,
	EMC_FBIO_CFG5_INDEX = 65,
	EMC_FBIO_CFG7_INDEX,
	EMC_CFG_DIG_DLL_INDEX,
	EMC_ZCAL_INTERVAL_INDEX = 139,
	EMC_ZCAL_WAIT_CNT_INDEX,
	EMC_MRS_WAIT_CNT_INDEX = 141,
	EMC_DLL_CFG_0_INDEX = 144,
	EMC_PMACRO_AUTOCAL_CFG_COMMON_INDEX = 146,
	EMC_CFG_INDEX = 148,
	EMC_DYN_SELF_REF_CONTROL_INDEX = 150,
	EMC_PMACRO_CMD_PAD_TX_CTRL_INDEX = 161,
	EMC_PMACRO_DATA_PAD_TX_CTRL_INDEX,
	EMC_PMACRO_COMMON_PAD_TX_CTRL_INDEX,
	EMC_PMACRO_BRICK_CTRL_RFU1_INDEX = 167,
	EMC_PMACRO_BG_BIAS_CTRL_0_INDEX = 171,
	EMC_MRW14_INDEX = 199,
	EMC_MRW15_INDEX = 220,
};

enum trim_regs_list {
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_0_INDEX = 60,
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_1_INDEX,
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_2_INDEX,
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_3_INDEX,
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_4_INDEX,
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK0_5_INDEX,
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_0_INDEX,
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_1_INDEX,
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_2_INDEX,
	EMC_PMACRO_OB_DDLL_LONG_DQ_RANK1_3_INDEX,
};

enum burst_mc_regs_list {
	MC_EMEM_ARB_MISC0_INDEX = 20,
};

enum {
	T_RP,
	T_FC_LPDDR4,
	T_RFC,
	T_PDEX,
	RL,
};

enum {
	AUTO_PD = 0,
	MAN_SR  = 2,
};

enum {
	ASSEMBLY = 0,
	ACTIVE,
};

enum {
	C0D0U0,
	C0D0U1,
	C0D1U0,
	C0D1U1,
	C1D0U0,
	C1D0U1,
	C1D1U0,
	C1D1U1,
	DRAM_CLKTREE_NUM,
};

#define VREF_REGS_PER_CHANNEL_SIZE 4
#define DRAM_TIMINGS_NUM 5
#define BURST_REGS_PER_CHANNEL_SIZE 8
#define TRIM_REGS_PER_CHANNEL_SIZE 10
#define PTFV_ARRAY_SIZE 12
#define SAVE_RESTORE_MOD_REGS_SIZE 12
#define TRAINING_MOD_REGS_SIZE 20
#define BURST_UP_DOWN_REGS_SIZE 24
#define BURST_MC_REGS_SIZE 33
#define TRIM_REGS_SIZE 138
#define BURST_REGS_SIZE 221

struct tegra210_emc_per_channel_regs {
	u16 bank;
	u16 offset;
};

struct tegra210_emc_table_register_offsets {
	u16 burst[BURST_REGS_SIZE];
	u16 trim[TRIM_REGS_SIZE];
	u16 burst_mc[BURST_MC_REGS_SIZE];
	u16 la_scale[BURST_UP_DOWN_REGS_SIZE];
	struct tegra210_emc_per_channel_regs burst_per_channel[BURST_REGS_PER_CHANNEL_SIZE];
	struct tegra210_emc_per_channel_regs trim_per_channel[TRIM_REGS_PER_CHANNEL_SIZE];
	struct tegra210_emc_per_channel_regs vref_per_channel[VREF_REGS_PER_CHANNEL_SIZE];
};

struct tegra210_emc_timing {
	u32 revision;
	const char dvfs_ver[60];
	u32 rate;
	u32 min_volt;
	u32 gpu_min_volt;
	const char clock_src[32];
	u32 clk_src_emc;
	u32 needs_training;
	u32 training_pattern;
	u32 trained;

	u32 periodic_training;
	u32 trained_dram_clktree[DRAM_CLKTREE_NUM];
	u32 current_dram_clktree[DRAM_CLKTREE_NUM];
	u32 run_clocks;
	u32 tree_margin;

	u32 num_burst;
	u32 num_burst_per_ch;
	u32 num_trim;
	u32 num_trim_per_ch;
	u32 num_mc_regs;
	u32 num_up_down;
	u32 vref_num;
	u32 training_mod_num;
	u32 dram_timing_num;

	u32 ptfv_list[PTFV_ARRAY_SIZE];

	u32 burst_regs[BURST_REGS_SIZE];
	u32 burst_reg_per_ch[BURST_REGS_PER_CHANNEL_SIZE];
	u32 shadow_regs_ca_train[BURST_REGS_SIZE];
	u32 shadow_regs_quse_train[BURST_REGS_SIZE];
	u32 shadow_regs_rdwr_train[BURST_REGS_SIZE];

	u32 trim_regs[TRIM_REGS_SIZE];
	u32 trim_perch_regs[TRIM_REGS_PER_CHANNEL_SIZE];

	u32 vref_perch_regs[VREF_REGS_PER_CHANNEL_SIZE];

	u32 dram_timings[DRAM_TIMINGS_NUM];
	u32 training_mod_regs[TRAINING_MOD_REGS_SIZE];
	u32 save_restore_mod_regs[SAVE_RESTORE_MOD_REGS_SIZE];
	u32 burst_mc_regs[BURST_MC_REGS_SIZE];
	u32 la_scale_regs[BURST_UP_DOWN_REGS_SIZE];

	u32 min_mrs_wait;
	u32 emc_mrw;
	u32 emc_mrw2;
	u32 emc_mrw3;
	u32 emc_mrw4;
	u32 emc_mrw9;
	u32 emc_mrs;
	u32 emc_emrs;
	u32 emc_emrs2;
	u32 emc_auto_cal_config;
	u32 emc_auto_cal_config2;
	u32 emc_auto_cal_config3;
	u32 emc_auto_cal_config4;
	u32 emc_auto_cal_config5;
	u32 emc_auto_cal_config6;
	u32 emc_auto_cal_config7;
	u32 emc_auto_cal_config8;
	u32 emc_cfg_2;
	u32 emc_sel_dpd_ctrl;
	u32 emc_fdpd_ctrl_cmd_no_ramp;
	u32 dll_clk_src;
	u32 clk_out_enb_x_0_clk_enb_emc_dll;
	u32 latency;
};

enum tegra210_emc_refresh {
	TEGRA210_EMC_REFRESH_NOMINAL = 0,
	TEGRA210_EMC_REFRESH_2X,
	TEGRA210_EMC_REFRESH_4X,
	TEGRA210_EMC_REFRESH_THROTTLE, /* 4x Refresh + derating. */
};

#define DRAM_TYPE_DDR3		0
#define DRAM_TYPE_LPDDR4	1
#define DRAM_TYPE_LPDDR2	2
#define DRAM_TYPE_DDR2		3

struct tegra210_emc {
	struct tegra_mc *mc;
	struct device *dev;
	struct clk *clk;

	/* nominal EMC frequency table */
	struct tegra210_emc_timing *nominal;
	/* derated EMC frequency table */
	struct tegra210_emc_timing *derated;

	/* currently selected table (nominal or derated) */
	struct tegra210_emc_timing *timings;
	unsigned int num_timings;

	const struct tegra210_emc_table_register_offsets *offsets;

	const struct tegra210_emc_sequence *sequence;
	spinlock_t lock;

	void __iomem *regs, *channel[2];
	unsigned int num_channels;
	unsigned int num_devices;
	unsigned int dram_type;

	struct tegra210_emc_timing *last;
	struct tegra210_emc_timing *next;

	unsigned int training_interval;
	struct timer_list training;

	enum tegra210_emc_refresh refresh;
	unsigned int refresh_poll_interval;
	struct timer_list refresh_timer;
	unsigned int temperature;
	atomic_t refresh_poll;

	ktime_t clkchange_time;
	int clkchange_delay;

	unsigned long resume_rate;

	struct {
		struct dentry *root;
		unsigned long min_rate;
		unsigned long max_rate;
		unsigned int temperature;
	} debugfs;

	struct tegra210_clk_emc_provider provider;
};

struct tegra210_emc_sequence {
	u8 revision;
	void (*set_clock)(struct tegra210_emc *emc, u32 clksrc);
	u32 (*periodic_compensation)(struct tegra210_emc *emc);
};

static inline void emc_writel(struct tegra210_emc *emc, u32 value,
			      unsigned int offset)
{
	writel_relaxed(value, emc->regs + offset);
}

static inline u32 emc_readl(struct tegra210_emc *emc, unsigned int offset)
{
	return readl_relaxed(emc->regs + offset);
}

static inline void emc_channel_writel(struct tegra210_emc *emc,
				      unsigned int channel,
				      u32 value, unsigned int offset)
{
	writel_relaxed(value, emc->channel[channel] + offset);
}

static inline u32 emc_channel_readl(struct tegra210_emc *emc,
				    unsigned int channel, unsigned int offset)
{
	return readl_relaxed(emc->channel[channel] + offset);
}

static inline void ccfifo_writel(struct tegra210_emc *emc, u32 value,
				 unsigned int offset, u32 delay)
{
	writel_relaxed(value, emc->regs + EMC_CCFIFO_DATA);

	value = EMC_CCFIFO_ADDR_STALL_BY_1 | EMC_CCFIFO_ADDR_STALL(delay) |
		EMC_CCFIFO_ADDR_OFFSET(offset);
	writel_relaxed(value, emc->regs + EMC_CCFIFO_ADDR);
}

static inline u32 div_o3(u32 a, u32 b)
{
	u32 result = a / b;

	if ((b * result) < a)
		return result + 1;

	return result;
}

/* from tegra210-emc-r21021.c */
extern const struct tegra210_emc_sequence tegra210_emc_r21021;

int tegra210_emc_set_refresh(struct tegra210_emc *emc,
			     enum tegra210_emc_refresh refresh);
u32 tegra210_emc_mrr_read(struct tegra210_emc *emc, unsigned int chip,
			  unsigned int address);
void tegra210_emc_do_clock_change(struct tegra210_emc *emc, u32 clksrc);
void tegra210_emc_set_shadow_bypass(struct tegra210_emc *emc, int set);
void tegra210_emc_timing_update(struct tegra210_emc *emc);
u32 tegra210_emc_get_dll_state(struct tegra210_emc_timing *next);
struct tegra210_emc_timing *tegra210_emc_find_timing(struct tegra210_emc *emc,
						     unsigned long rate);
void tegra210_emc_adjust_timing(struct tegra210_emc *emc,
				struct tegra210_emc_timing *timing);
int tegra210_emc_wait_for_update(struct tegra210_emc *emc, unsigned int channel,
				 unsigned int offset, u32 bit_mask, bool state);
unsigned long tegra210_emc_actual_osc_clocks(u32 in);
u32 tegra210_emc_compensate(struct tegra210_emc_timing *next, u32 offset);
void tegra210_emc_dll_disable(struct tegra210_emc *emc);
void tegra210_emc_dll_enable(struct tegra210_emc *emc);
u32 tegra210_emc_dll_prelock(struct tegra210_emc *emc, u32 clksrc);
u32 tegra210_emc_dvfs_power_ramp_down(struct tegra210_emc *emc, u32 clk,
				      bool flip_backward);
u32 tegra210_emc_dvfs_power_ramp_up(struct tegra210_emc *emc, u32 clk,
				    bool flip_backward);
void tegra210_emc_reset_dram_clktree_values(struct tegra210_emc_timing *timing);
void tegra210_emc_start_periodic_compensation(struct tegra210_emc *emc);

#endif
