#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>

VERSION=$2
TAR=../libfreemarker-java_$VERSION.orig.tar.xz
DIR=freemarker-$VERSION

# clean up the upstream tarball
mkdir $DIR
tar -x -C $DIR -f $3
mv $DIR/source $DIR/$DIR
XZ_OPT=--best tar -c -J -f $TAR -X debian/orig-tar.exclude -C $DIR $DIR
rm -rf $DIR $3

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $3 $origDir
  echo "moved $3 to $origDir"
fi
