/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/lda_exc/lda_c_2d_amgb.mpl
  Type of functional: lda_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t4, t7, t9, t11, t12, t13;
  double t14, t18, t20, t21, t22, t24, t26, t27;
  double t30, t32, t33, t36, tzk0;


  t1 = sqrt(rho[0]);
  t2 = 0.1e1 / t1;
  t4 = 0.1e1 / rho[0];
  t7 = 0.1e1 / t1 / rho[0];
  t9 = 0.48697234038507617049e-1 * t2 + 0.18219548589342283974e-1 * t4 + 0.6039470020288820178e-3 * t7;
  t11 = sqrt(M_PI);
  t12 = 0.1e1 / t11;
  t13 = t12 * t2;
  t14 = POW_3_2(t13);
  t18 = 0.56543080063156135078e0 * t2 - 0.2069e-1 * t14 + 0.1082158120059033146e0 * t4 + 0.31373870235266598327e-2 * t7;
  t20 = 0.1e1 + 0.1e1 / t18;
  t21 = log(t20);
  t22 = t9 * t21;
  t24 = exp(-0.75522417653702656571e0 * t2);
  t26 = M_SQRT2;
  t27 = (t24 - 0.1e1) * t26;
  t30 = sqrt(p->zeta_threshold);
  t32 = my_piecewise3(0.1e1 <= p->zeta_threshold, t30 * p->zeta_threshold, 1);
  t33 = t32 - 0.1e1;
  t36 = 0.4e1 / 0.3e1 * t27 * t12 * t1 * t33;
  tzk0 = -0.1925e0 + t22 - t36;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t4, t7, t9, t11, t12, t13;
  double t14, t18, t20, t21, t22, t24, t26, t27;
  double t30, t32, t33, t36, tzk0;

  double t38, t39, t42, t44, t45, t46, t47, t48;
  double t50, t51, t56, t57, t58, t59, t61, t62;
  double t65, tvrho0;


  t1 = sqrt(rho[0]);
  t2 = 0.1e1 / t1;
  t4 = 0.1e1 / rho[0];
  t7 = 0.1e1 / t1 / rho[0];
  t9 = 0.48697234038507617049e-1 * t2 + 0.18219548589342283974e-1 * t4 + 0.6039470020288820178e-3 * t7;
  t11 = sqrt(M_PI);
  t12 = 0.1e1 / t11;
  t13 = t12 * t2;
  t14 = POW_3_2(t13);
  t18 = 0.56543080063156135078e0 * t2 - 0.2069e-1 * t14 + 0.1082158120059033146e0 * t4 + 0.31373870235266598327e-2 * t7;
  t20 = 0.1e1 + 0.1e1 / t18;
  t21 = log(t20);
  t22 = t9 * t21;
  t24 = exp(-0.75522417653702656571e0 * t2);
  t26 = M_SQRT2;
  t27 = (t24 - 0.1e1) * t26;
  t30 = sqrt(p->zeta_threshold);
  t32 = my_piecewise3(0.1e1 <= p->zeta_threshold, t30 * p->zeta_threshold, 1);
  t33 = t32 - 0.1e1;
  t36 = 0.4e1 / 0.3e1 * t27 * t12 * t1 * t33;
  tzk0 = -0.1925e0 + t22 - t36;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t38 = rho[0] * rho[0];
  t39 = 0.1e1 / t38;
  t42 = 0.1e1 / t1 / t38;
  t44 = -0.24348617019253808524e-1 * t7 - 0.18219548589342283974e-1 * t39 - 0.9059205030433230267e-3 * t42;
  t45 = t44 * t21;
  t46 = t18 * t18;
  t47 = 0.1e1 / t46;
  t48 = t9 * t47;
  t50 = sqrt(t13);
  t51 = t50 * t12;
  t56 = -0.28271540031578067539e0 * t7 + 0.155175e-1 * t51 * t7 - 0.1082158120059033146e0 * t39 - 0.4706080535289989749e-2 * t42;
  t57 = 0.1e1 / t20;
  t58 = t56 * t57;
  t59 = t48 * t58;
  t61 = t26 * t33;
  t62 = t4 * t24 * t61;
  t65 = t27 * t13 * t33;
  tvrho0 = -0.1925e0 + t22 - t36 + rho[0] * (t45 - t59 - 0.28405974243041479528e0 * t62 - 0.2e1 / 0.3e1 * t65);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t4, t7, t9, t11, t12, t13;
  double t14, t18, t20, t21, t22, t24, t26, t27;
  double t30, t32, t33, t36, tzk0;

  double t38, t39, t42, t44, t45, t46, t47, t48;
  double t50, t51, t56, t57, t58, t59, t61, t62;
  double t65, tvrho0;

  double t74, t75, t78, t80, t81, t82, t83, t85;
  double t86, t87, t88, t89, t90, t93, t95, t102;
  double t103, t104, t105, t106, t107, t108, t109, t110;
  double t111, t113, t116, t120, tv2rho20;


  t1 = sqrt(rho[0]);
  t2 = 0.1e1 / t1;
  t4 = 0.1e1 / rho[0];
  t7 = 0.1e1 / t1 / rho[0];
  t9 = 0.48697234038507617049e-1 * t2 + 0.18219548589342283974e-1 * t4 + 0.6039470020288820178e-3 * t7;
  t11 = sqrt(M_PI);
  t12 = 0.1e1 / t11;
  t13 = t12 * t2;
  t14 = POW_3_2(t13);
  t18 = 0.56543080063156135078e0 * t2 - 0.2069e-1 * t14 + 0.1082158120059033146e0 * t4 + 0.31373870235266598327e-2 * t7;
  t20 = 0.1e1 + 0.1e1 / t18;
  t21 = log(t20);
  t22 = t9 * t21;
  t24 = exp(-0.75522417653702656571e0 * t2);
  t26 = M_SQRT2;
  t27 = (t24 - 0.1e1) * t26;
  t30 = sqrt(p->zeta_threshold);
  t32 = my_piecewise3(0.1e1 <= p->zeta_threshold, t30 * p->zeta_threshold, 1);
  t33 = t32 - 0.1e1;
  t36 = 0.4e1 / 0.3e1 * t27 * t12 * t1 * t33;
  tzk0 = -0.1925e0 + t22 - t36;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t38 = rho[0] * rho[0];
  t39 = 0.1e1 / t38;
  t42 = 0.1e1 / t1 / t38;
  t44 = -0.24348617019253808524e-1 * t7 - 0.18219548589342283974e-1 * t39 - 0.9059205030433230267e-3 * t42;
  t45 = t44 * t21;
  t46 = t18 * t18;
  t47 = 0.1e1 / t46;
  t48 = t9 * t47;
  t50 = sqrt(t13);
  t51 = t50 * t12;
  t56 = -0.28271540031578067539e0 * t7 + 0.155175e-1 * t51 * t7 - 0.1082158120059033146e0 * t39 - 0.4706080535289989749e-2 * t42;
  t57 = 0.1e1 / t20;
  t58 = t56 * t57;
  t59 = t48 * t58;
  t61 = t26 * t33;
  t62 = t4 * t24 * t61;
  t65 = t27 * t13 * t33;
  tvrho0 = -0.1925e0 + t22 - t36 + rho[0] * (t45 - t59 - 0.28405974243041479528e0 * t62 - 0.2e1 / 0.3e1 * t65);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t74 = t38 * rho[0];
  t75 = 0.1e1 / t74;
  t78 = 0.1e1 / t1 / t74;
  t80 = 0.36522925528880712786e-1 * t42 + 0.36439097178684567948e-1 * t75 + 0.22648012576083075668e-2 * t78;
  t81 = t80 * t21;
  t82 = t44 * t47;
  t83 = t82 * t58;
  t85 = t46 * t18;
  t86 = 0.1e1 / t85;
  t87 = t9 * t86;
  t88 = t56 * t56;
  t89 = t88 * t57;
  t90 = t87 * t89;
  t93 = 0.1e1/sqrt(t13);
  t95 = t93 / M_PI;
  t102 = 0.42407310047367101308e0 * t42 - 0.3879375e-2 * t95 * t75 - 0.2327625e-1 * t51 * t42 + 0.2164316240118066292e0 * t75 + 0.11765201338224974372e-1 * t78;
  t103 = t102 * t57;
  t104 = t48 * t103;
  t105 = t46 * t46;
  t106 = 0.1e1 / t105;
  t107 = t9 * t106;
  t108 = t20 * t20;
  t109 = 0.1e1 / t108;
  t110 = t88 * t109;
  t111 = t107 * t110;
  t113 = t39 * t24 * t61;
  t116 = t42 * t24 * t61;
  t120 = t27 * t12 * t7 * t33;
  tv2rho20 = 0.2e1 * t45 - 0.2e1 * t59 - 0.56811948486082959056e0 * t62 - 0.4e1 / 0.3e1 * t65 + rho[0] * (t81 - 0.2e1 * t83 + 0.2e1 * t90 - t104 - t111 + 0.14202987121520739764e0 * t113 - 0.10726439253216493952e0 * t116 + t120 / 0.3e1);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t4, t7, t9, t11, t12, t13;
  double t14, t18, t20, t21, t22, t24, t26, t27;
  double t30, t32, t33, t36, tzk0;

  double t38, t39, t42, t44, t45, t46, t47, t48;
  double t50, t51, t56, t57, t58, t59, t61, t62;
  double t65, tvrho0;

  double t74, t75, t78, t80, t81, t82, t83, t85;
  double t86, t87, t88, t89, t90, t93, t95, t102;
  double t103, t104, t105, t106, t107, t108, t109, t110;
  double t111, t113, t116, t120, tv2rho20;

  double t132, t133, t136, t138, t139, t140, t141, t143;
  double t144, t146, t148, t149, t151, t152, t153, t155;
  double t156, t159, t160, t161, t162, t165, t168, t177;
  double t178, t179, t181, t182, t185, t186, t188, t189;
  double t190, t193, t196, t199, t203, t205, tv3rho30;


  t1 = sqrt(rho[0]);
  t2 = 0.1e1 / t1;
  t4 = 0.1e1 / rho[0];
  t7 = 0.1e1 / t1 / rho[0];
  t9 = 0.48697234038507617049e-1 * t2 + 0.18219548589342283974e-1 * t4 + 0.6039470020288820178e-3 * t7;
  t11 = sqrt(M_PI);
  t12 = 0.1e1 / t11;
  t13 = t12 * t2;
  t14 = POW_3_2(t13);
  t18 = 0.56543080063156135078e0 * t2 - 0.2069e-1 * t14 + 0.1082158120059033146e0 * t4 + 0.31373870235266598327e-2 * t7;
  t20 = 0.1e1 + 0.1e1 / t18;
  t21 = log(t20);
  t22 = t9 * t21;
  t24 = exp(-0.75522417653702656571e0 * t2);
  t26 = M_SQRT2;
  t27 = (t24 - 0.1e1) * t26;
  t30 = sqrt(p->zeta_threshold);
  t32 = my_piecewise3(0.1e1 <= p->zeta_threshold, t30 * p->zeta_threshold, 1);
  t33 = t32 - 0.1e1;
  t36 = 0.4e1 / 0.3e1 * t27 * t12 * t1 * t33;
  tzk0 = -0.1925e0 + t22 - t36;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t38 = rho[0] * rho[0];
  t39 = 0.1e1 / t38;
  t42 = 0.1e1 / t1 / t38;
  t44 = -0.24348617019253808524e-1 * t7 - 0.18219548589342283974e-1 * t39 - 0.9059205030433230267e-3 * t42;
  t45 = t44 * t21;
  t46 = t18 * t18;
  t47 = 0.1e1 / t46;
  t48 = t9 * t47;
  t50 = sqrt(t13);
  t51 = t50 * t12;
  t56 = -0.28271540031578067539e0 * t7 + 0.155175e-1 * t51 * t7 - 0.1082158120059033146e0 * t39 - 0.4706080535289989749e-2 * t42;
  t57 = 0.1e1 / t20;
  t58 = t56 * t57;
  t59 = t48 * t58;
  t61 = t26 * t33;
  t62 = t4 * t24 * t61;
  t65 = t27 * t13 * t33;
  tvrho0 = -0.1925e0 + t22 - t36 + rho[0] * (t45 - t59 - 0.28405974243041479528e0 * t62 - 0.2e1 / 0.3e1 * t65);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t74 = t38 * rho[0];
  t75 = 0.1e1 / t74;
  t78 = 0.1e1 / t1 / t74;
  t80 = 0.36522925528880712786e-1 * t42 + 0.36439097178684567948e-1 * t75 + 0.22648012576083075668e-2 * t78;
  t81 = t80 * t21;
  t82 = t44 * t47;
  t83 = t82 * t58;
  t85 = t46 * t18;
  t86 = 0.1e1 / t85;
  t87 = t9 * t86;
  t88 = t56 * t56;
  t89 = t88 * t57;
  t90 = t87 * t89;
  t93 = 0.1e1/sqrt(t13);
  t95 = t93 / M_PI;
  t102 = 0.42407310047367101308e0 * t42 - 0.3879375e-2 * t95 * t75 - 0.2327625e-1 * t51 * t42 + 0.2164316240118066292e0 * t75 + 0.11765201338224974372e-1 * t78;
  t103 = t102 * t57;
  t104 = t48 * t103;
  t105 = t46 * t46;
  t106 = 0.1e1 / t105;
  t107 = t9 * t106;
  t108 = t20 * t20;
  t109 = 0.1e1 / t108;
  t110 = t88 * t109;
  t111 = t107 * t110;
  t113 = t39 * t24 * t61;
  t116 = t42 * t24 * t61;
  t120 = t27 * t12 * t7 * t33;
  tv2rho20 = 0.2e1 * t45 - 0.2e1 * t59 - 0.56811948486082959056e0 * t62 - 0.4e1 / 0.3e1 * t65 + rho[0] * (t81 - 0.2e1 * t83 + 0.2e1 * t90 - t104 - t111 + 0.14202987121520739764e0 * t113 - 0.10726439253216493952e0 * t116 + t120 / 0.3e1);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t132 = t38 * t38;
  t133 = 0.1e1 / t132;
  t136 = 0.1e1 / t1 / t132;
  t138 = -0.91307313822201781965e-1 * t78 - 0.10931729153605370384e0 * t133 - 0.79268044016290764838e-2 * t136;
  t139 = t138 * t21;
  t140 = t80 * t47;
  t141 = t140 * t58;
  t143 = t44 * t86;
  t144 = t143 * t89;
  t146 = t82 * t103;
  t148 = t44 * t106;
  t149 = t148 * t110;
  t151 = t88 * t56;
  t152 = t151 * t57;
  t153 = t107 * t152;
  t155 = t58 * t102;
  t156 = t87 * t155;
  t159 = 0.1e1 / t105 / t18;
  t160 = t9 * t159;
  t161 = t151 * t109;
  t162 = t160 * t161;
  t165 = 0.1e1/POW_3_2(t13);
  t168 = t165 / t11 / M_PI;
  t177 = -0.10601827511841775327e1 * t78 - 0.96984375e-3 * t168 * t136 + 0.174571875e-1 * t95 * t133 + 0.58190625e-1 * t51 * t78 - 0.6492948720354198876e0 * t133 - 0.41178204683787410302e-1 * t136;
  t178 = t177 * t57;
  t179 = t48 * t178;
  t181 = t102 * t109 * t56;
  t182 = t107 * t181;
  t185 = 0.1e1 / t105 / t46;
  t186 = t9 * t185;
  t188 = 0.1e1 / t108 / t20;
  t189 = t151 * t188;
  t190 = t186 * t189;
  t193 = t75 * t24 * t61;
  t196 = t78 * t24 * t61;
  t199 = t133 * t24 * t61;
  t203 = t27 * t12 * t42 * t33;
  t205 = t139 - 0.3e1 * t141 + 0.6e1 * t144 - 0.3e1 * t146 - 0.3e1 * t149 - 0.6e1 * t153 + 0.6e1 * t156 + 0.6e1 * t162 - t179 - 0.3e1 * t182 - 0.2e1 * t190 - 0.21304480682281109646e0 * t193 + 0.32179317759649481856e0 * t196 - 0.40504331260924324145e-1 * t199 - t203 / 0.2e1;
  tv3rho30 = 0.3e1 * t81 - 0.6e1 * t83 + 0.6e1 * t90 - 0.3e1 * t104 - 0.3e1 * t111 + 0.42608961364562219292e0 * t113 - 0.32179317759649481856e0 * t116 + t120 + rho[0] * t205;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t4, t7, t9, t11, t12, t13;
  double t14, t18, t20, t21, t22, t24, t26, t27;
  double t30, t32, t33, t36, tzk0;

  double t38, t39, t42, t44, t45, t46, t47, t48;
  double t50, t51, t56, t57, t58, t59, t61, t62;
  double t65, tvrho0;

  double t74, t75, t78, t80, t81, t82, t83, t85;
  double t86, t87, t88, t89, t90, t93, t95, t102;
  double t103, t104, t105, t106, t107, t108, t109, t110;
  double t111, t113, t116, t120, tv2rho20;

  double t132, t133, t136, t138, t139, t140, t141, t143;
  double t144, t146, t148, t149, t151, t152, t153, t155;
  double t156, t159, t160, t161, t162, t165, t168, t177;
  double t178, t179, t181, t182, t185, t186, t188, t189;
  double t190, t193, t196, t199, t203, t205, tv3rho30;

  double t253, t257, t264, t291, t292, t299, t301, t304;
  double t314, t317, t336, tv4rho40;


  t1 = sqrt(rho[0]);
  t2 = 0.1e1 / t1;
  t4 = 0.1e1 / rho[0];
  t7 = 0.1e1 / t1 / rho[0];
  t9 = 0.48697234038507617049e-1 * t2 + 0.18219548589342283974e-1 * t4 + 0.6039470020288820178e-3 * t7;
  t11 = sqrt(M_PI);
  t12 = 0.1e1 / t11;
  t13 = t12 * t2;
  t14 = POW_3_2(t13);
  t18 = 0.56543080063156135078e0 * t2 - 0.2069e-1 * t14 + 0.1082158120059033146e0 * t4 + 0.31373870235266598327e-2 * t7;
  t20 = 0.1e1 + 0.1e1 / t18;
  t21 = log(t20);
  t22 = t9 * t21;
  t24 = exp(-0.75522417653702656571e0 * t2);
  t26 = M_SQRT2;
  t27 = (t24 - 0.1e1) * t26;
  t30 = sqrt(p->zeta_threshold);
  t32 = my_piecewise3(0.1e1 <= p->zeta_threshold, t30 * p->zeta_threshold, 1);
  t33 = t32 - 0.1e1;
  t36 = 0.4e1 / 0.3e1 * t27 * t12 * t1 * t33;
  tzk0 = -0.1925e0 + t22 - t36;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t38 = rho[0] * rho[0];
  t39 = 0.1e1 / t38;
  t42 = 0.1e1 / t1 / t38;
  t44 = -0.24348617019253808524e-1 * t7 - 0.18219548589342283974e-1 * t39 - 0.9059205030433230267e-3 * t42;
  t45 = t44 * t21;
  t46 = t18 * t18;
  t47 = 0.1e1 / t46;
  t48 = t9 * t47;
  t50 = sqrt(t13);
  t51 = t50 * t12;
  t56 = -0.28271540031578067539e0 * t7 + 0.155175e-1 * t51 * t7 - 0.1082158120059033146e0 * t39 - 0.4706080535289989749e-2 * t42;
  t57 = 0.1e1 / t20;
  t58 = t56 * t57;
  t59 = t48 * t58;
  t61 = t26 * t33;
  t62 = t4 * t24 * t61;
  t65 = t27 * t13 * t33;
  tvrho0 = -0.1925e0 + t22 - t36 + rho[0] * (t45 - t59 - 0.28405974243041479528e0 * t62 - 0.2e1 / 0.3e1 * t65);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t74 = t38 * rho[0];
  t75 = 0.1e1 / t74;
  t78 = 0.1e1 / t1 / t74;
  t80 = 0.36522925528880712786e-1 * t42 + 0.36439097178684567948e-1 * t75 + 0.22648012576083075668e-2 * t78;
  t81 = t80 * t21;
  t82 = t44 * t47;
  t83 = t82 * t58;
  t85 = t46 * t18;
  t86 = 0.1e1 / t85;
  t87 = t9 * t86;
  t88 = t56 * t56;
  t89 = t88 * t57;
  t90 = t87 * t89;
  t93 = 0.1e1/sqrt(t13);
  t95 = t93 / M_PI;
  t102 = 0.42407310047367101308e0 * t42 - 0.3879375e-2 * t95 * t75 - 0.2327625e-1 * t51 * t42 + 0.2164316240118066292e0 * t75 + 0.11765201338224974372e-1 * t78;
  t103 = t102 * t57;
  t104 = t48 * t103;
  t105 = t46 * t46;
  t106 = 0.1e1 / t105;
  t107 = t9 * t106;
  t108 = t20 * t20;
  t109 = 0.1e1 / t108;
  t110 = t88 * t109;
  t111 = t107 * t110;
  t113 = t39 * t24 * t61;
  t116 = t42 * t24 * t61;
  t120 = t27 * t12 * t7 * t33;
  tv2rho20 = 0.2e1 * t45 - 0.2e1 * t59 - 0.56811948486082959056e0 * t62 - 0.4e1 / 0.3e1 * t65 + rho[0] * (t81 - 0.2e1 * t83 + 0.2e1 * t90 - t104 - t111 + 0.14202987121520739764e0 * t113 - 0.10726439253216493952e0 * t116 + t120 / 0.3e1);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t132 = t38 * t38;
  t133 = 0.1e1 / t132;
  t136 = 0.1e1 / t1 / t132;
  t138 = -0.91307313822201781965e-1 * t78 - 0.10931729153605370384e0 * t133 - 0.79268044016290764838e-2 * t136;
  t139 = t138 * t21;
  t140 = t80 * t47;
  t141 = t140 * t58;
  t143 = t44 * t86;
  t144 = t143 * t89;
  t146 = t82 * t103;
  t148 = t44 * t106;
  t149 = t148 * t110;
  t151 = t88 * t56;
  t152 = t151 * t57;
  t153 = t107 * t152;
  t155 = t58 * t102;
  t156 = t87 * t155;
  t159 = 0.1e1 / t105 / t18;
  t160 = t9 * t159;
  t161 = t151 * t109;
  t162 = t160 * t161;
  t165 = 0.1e1/POW_3_2(t13);
  t168 = t165 / t11 / M_PI;
  t177 = -0.10601827511841775327e1 * t78 - 0.96984375e-3 * t168 * t136 + 0.174571875e-1 * t95 * t133 + 0.58190625e-1 * t51 * t78 - 0.6492948720354198876e0 * t133 - 0.41178204683787410302e-1 * t136;
  t178 = t177 * t57;
  t179 = t48 * t178;
  t181 = t102 * t109 * t56;
  t182 = t107 * t181;
  t185 = 0.1e1 / t105 / t46;
  t186 = t9 * t185;
  t188 = 0.1e1 / t108 / t20;
  t189 = t151 * t188;
  t190 = t186 * t189;
  t193 = t75 * t24 * t61;
  t196 = t78 * t24 * t61;
  t199 = t133 * t24 * t61;
  t203 = t27 * t12 * t42 * t33;
  t205 = t139 - 0.3e1 * t141 + 0.6e1 * t144 - 0.3e1 * t146 - 0.3e1 * t149 - 0.6e1 * t153 + 0.6e1 * t156 + 0.6e1 * t162 - t179 - 0.3e1 * t182 - 0.2e1 * t190 - 0.21304480682281109646e0 * t193 + 0.32179317759649481856e0 * t196 - 0.40504331260924324145e-1 * t199 - t203 / 0.2e1;
  tv3rho30 = 0.3e1 * t81 - 0.6e1 * t83 + 0.6e1 * t90 - 0.3e1 * t104 - 0.3e1 * t111 + 0.42608961364562219292e0 * t113 - 0.32179317759649481856e0 * t116 + t120 + rho[0] * t205;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t253 = t88 * t88;
  t257 = t102 * t102;
  t264 = 0.5e1 / 0.4e1 * t27 * t12 * t78 * t33 + 0.24e2 * t143 * t155 - 0.12e2 * t148 * t181 - 0.36e2 * t107 * t89 * t102 + 0.8e1 * t87 * t58 * t177 + 0.36e2 * t160 * t110 * t102 - 0.4e1 * t107 * t177 * t109 * t56 - 0.12e2 * t186 * t102 * t188 * t88 + 0.53261201705702774115e0 * t199 + 0.12e2 * t80 * t86 * t89 - 0.24e2 * t148 * t152 + 0.24e2 * t160 * t253 * t57 + 0.6e1 * t87 * t257 * t57 - 0.3e1 * t107 * t257 * t109;
  t291 = pow(t13, -0.25e1);
  t292 = M_PI * M_PI;
  t299 = t132 * rho[0];
  t301 = 0.1e1 / t1 / t299;
  t304 = 0.1e1 / t299;
  t314 = t105 * t105;
  t317 = t108 * t108;
  t336 = -0.4e1 * t138 * t47 * t58 - 0.6e1 * t140 * t103 - 0.6e1 * t80 * t106 * t110 + 0.24e2 * t44 * t159 * t161 - 0.4e1 * t82 * t178 - 0.8e1 * t44 * t185 * t189 - 0.36e2 * t186 * t253 * t109 + 0.24e2 * t9 / t105 / t85 * t253 * t188 - t48 * (0.37106396291446213644e1 * t136 - 0.7273828125e-3 * t291 / t292 / t132 / t38 + 0.872859375e-2 * t168 * t301 - 0.8437640625e-1 * t95 * t304 - 0.2036671875e0 * t51 * t136 + 0.25971794881416795504e1 * t304 + 0.18530192107704334636e0 * t301) * t57 - 0.6e1 * t9 / t314 * t253 / t317 - 0.12067244159868555696e1 * t136 * t24 * t61 + 0.28353031882647026902e0 * t304 * t24 * t61 - 0.15294925111357257807e-1 * t301 * t24 * t61 + (0.31957559837770623688e0 * t136 + 0.43726916614421481536e0 * t304 + 0.35670619807330844177e-1 * t301) * t21;
  tv4rho40 = 0.24e2 * t144 - 0.24e2 * t153 + 0.24e2 * t156 - 0.12e2 * t182 - 0.85217922729124438584e0 * t193 - 0.12e2 * t141 - 0.12e2 * t146 - 0.12e2 * t149 + 0.24e2 * t162 - 0.4e1 * t179 - 0.8e1 * t190 + 0.12871727103859792742e1 * t196 - 0.16201732504369729658e0 * t199 + 0.4e1 * t139 - 0.2e1 * t203 + rho[0] * (t264 + t336);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t5, t8, t10, t12, t13;
  double t14, t15, t19, t21, t22, t23, t27, t31;
  double t33, t34, t36, t37, t38, t39, t40, t41;
  double t42, t46, t49, t51, t52, t54, t55, t56;
  double t57, t58, t59, t61, t63, t64, t65, t66;
  double t67, t68, t69, t70, t71, t72, t73, t75;
  double t76, t77, t78, t79, t85, t88, tzk0;


  t1 = rho[0] + rho[1];
  t2 = sqrt(t1);
  t3 = 0.1e1 / t2;
  t5 = 0.1e1 / t1;
  t8 = 0.1e1 / t2 / t1;
  t10 = 0.48697234038507617049e-1 * t3 + 0.18219548589342283974e-1 * t5 + 0.6039470020288820178e-3 * t8;
  t12 = sqrt(M_PI);
  t13 = 0.1e1 / t12;
  t14 = t13 * t3;
  t15 = POW_3_2(t14);
  t19 = 0.56543080063156135078e0 * t3 - 0.2069e-1 * t15 + 0.1082158120059033146e0 * t5 + 0.31373870235266598327e-2 * t8;
  t21 = 0.1e1 + 0.1e1 / t19;
  t22 = log(t21);
  t23 = t10 * t22;
  t27 = -0.19148594465610848379e-1 * t3 - 0.24406887987971425426e-2 * t5 - 0.16433379454670369131e-4 * t8;
  t31 = 0.2331795548802876734e0 * t3 + 0.21277965468761999883e-1 * t5 + 0.14005999654541740146e-3 * t8;
  t33 = 0.1e1 + 0.1e1 / t31;
  t34 = log(t33);
  t36 = 0.117331e0 + t27 * t34;
  t37 = rho[0] - rho[1];
  t38 = t37 * t37;
  t39 = t36 * t38;
  t40 = t1 * t1;
  t41 = 0.1e1 / t40;
  t42 = t39 * t41;
  t46 = -0.20927484222536923952e-1 * t3 + 0.52081226957619462095e-2 * t5 - 0.48916627893863681951e-2 * t8;
  t49 = 0.80357578803665282726e0 * t3 + 0.20887760215665910274e0 * t8;
  t51 = 0.1e1 + 0.1e1 / t49;
  t52 = log(t51);
  t54 = 0.234188e-1 + t46 * t52;
  t55 = t38 * t38;
  t56 = t54 * t55;
  t57 = t40 * t40;
  t58 = 0.1e1 / t57;
  t59 = t56 * t58;
  t61 = exp(-0.75522417653702656571e0 * t3);
  t63 = M_SQRT2;
  t64 = (t61 - 0.1e1) * t63;
  t65 = t13 * t2;
  t66 = t37 * t5;
  t67 = 0.1e1 + t66;
  t68 = t67 <= p->zeta_threshold;
  t69 = sqrt(p->zeta_threshold);
  t70 = t69 * p->zeta_threshold;
  t71 = sqrt(t67);
  t72 = t71 * t67;
  t73 = my_piecewise3(t68, t70, t72);
  t75 = 0.1e1 - t66;
  t76 = t75 <= p->zeta_threshold;
  t77 = sqrt(t75);
  t78 = t77 * t75;
  t79 = my_piecewise3(t76, t70, t78);
  t85 = t73 / 0.2e1 + t79 / 0.2e1 - 0.1e1 - 0.3e1 / 0.8e1 * t38 * t41 - 0.3e1 / 0.128e3 * t55 * t58;
  t88 = 0.4e1 / 0.3e1 * t64 * t65 * t85;
  tzk0 = -0.1925e0 + t23 + t42 + t59 - t88;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t5, t8, t10, t12, t13;
  double t14, t15, t19, t21, t22, t23, t27, t31;
  double t33, t34, t36, t37, t38, t39, t40, t41;
  double t42, t46, t49, t51, t52, t54, t55, t56;
  double t57, t58, t59, t61, t63, t64, t65, t66;
  double t67, t68, t69, t70, t71, t72, t73, t75;
  double t76, t77, t78, t79, t85, t88, tzk0;

  double t92, t94, t95, t96, t97, t98, t100, t101;
  double t106, t107, t108, t109, t113, t115, t116, t117;
  double t121, t122, t123, t125, t126, t127, t128, t129;
  double t130, t131, t132, t133, t134, t138, t140, t141;
  double t142, t145, t146, t147, t149, t150, t151, t152;
  double t153, t154, t155, t156, t157, t158, t159, t160;
  double t161, t162, t163, t165, t166, t167, t168, t171;
  double t173, t176, t178, t180, t182, t184, t185, t187;
  double t188, t189, tvrho0, t191, t194, t196, t199, t201;
  double t203, t204, t205, tvrho1;


  t1 = rho[0] + rho[1];
  t2 = sqrt(t1);
  t3 = 0.1e1 / t2;
  t5 = 0.1e1 / t1;
  t8 = 0.1e1 / t2 / t1;
  t10 = 0.48697234038507617049e-1 * t3 + 0.18219548589342283974e-1 * t5 + 0.6039470020288820178e-3 * t8;
  t12 = sqrt(M_PI);
  t13 = 0.1e1 / t12;
  t14 = t13 * t3;
  t15 = POW_3_2(t14);
  t19 = 0.56543080063156135078e0 * t3 - 0.2069e-1 * t15 + 0.1082158120059033146e0 * t5 + 0.31373870235266598327e-2 * t8;
  t21 = 0.1e1 + 0.1e1 / t19;
  t22 = log(t21);
  t23 = t10 * t22;
  t27 = -0.19148594465610848379e-1 * t3 - 0.24406887987971425426e-2 * t5 - 0.16433379454670369131e-4 * t8;
  t31 = 0.2331795548802876734e0 * t3 + 0.21277965468761999883e-1 * t5 + 0.14005999654541740146e-3 * t8;
  t33 = 0.1e1 + 0.1e1 / t31;
  t34 = log(t33);
  t36 = 0.117331e0 + t27 * t34;
  t37 = rho[0] - rho[1];
  t38 = t37 * t37;
  t39 = t36 * t38;
  t40 = t1 * t1;
  t41 = 0.1e1 / t40;
  t42 = t39 * t41;
  t46 = -0.20927484222536923952e-1 * t3 + 0.52081226957619462095e-2 * t5 - 0.48916627893863681951e-2 * t8;
  t49 = 0.80357578803665282726e0 * t3 + 0.20887760215665910274e0 * t8;
  t51 = 0.1e1 + 0.1e1 / t49;
  t52 = log(t51);
  t54 = 0.234188e-1 + t46 * t52;
  t55 = t38 * t38;
  t56 = t54 * t55;
  t57 = t40 * t40;
  t58 = 0.1e1 / t57;
  t59 = t56 * t58;
  t61 = exp(-0.75522417653702656571e0 * t3);
  t63 = M_SQRT2;
  t64 = (t61 - 0.1e1) * t63;
  t65 = t13 * t2;
  t66 = t37 * t5;
  t67 = 0.1e1 + t66;
  t68 = t67 <= p->zeta_threshold;
  t69 = sqrt(p->zeta_threshold);
  t70 = t69 * p->zeta_threshold;
  t71 = sqrt(t67);
  t72 = t71 * t67;
  t73 = my_piecewise3(t68, t70, t72);
  t75 = 0.1e1 - t66;
  t76 = t75 <= p->zeta_threshold;
  t77 = sqrt(t75);
  t78 = t77 * t75;
  t79 = my_piecewise3(t76, t70, t78);
  t85 = t73 / 0.2e1 + t79 / 0.2e1 - 0.1e1 - 0.3e1 / 0.8e1 * t38 * t41 - 0.3e1 / 0.128e3 * t55 * t58;
  t88 = 0.4e1 / 0.3e1 * t64 * t65 * t85;
  tzk0 = -0.1925e0 + t23 + t42 + t59 - t88;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t92 = 0.1e1 / t2 / t40;
  t94 = -0.24348617019253808524e-1 * t8 - 0.18219548589342283974e-1 * t41 - 0.9059205030433230267e-3 * t92;
  t95 = t94 * t22;
  t96 = t19 * t19;
  t97 = 0.1e1 / t96;
  t98 = t10 * t97;
  t100 = sqrt(t14);
  t101 = t100 * t13;
  t106 = -0.28271540031578067539e0 * t8 + 0.155175e-1 * t101 * t8 - 0.1082158120059033146e0 * t41 - 0.4706080535289989749e-2 * t92;
  t107 = 0.1e1 / t21;
  t108 = t106 * t107;
  t109 = t98 * t108;
  t113 = 0.95742972328054241895e-2 * t8 + 0.24406887987971425426e-2 * t41 + 0.24650069182005553696e-4 * t92;
  t115 = t31 * t31;
  t116 = 0.1e1 / t115;
  t117 = t27 * t116;
  t121 = -0.1165897774401438367e0 * t8 - 0.21277965468761999883e-1 * t41 - 0.21008999481812610219e-3 * t92;
  t122 = 0.1e1 / t33;
  t123 = t121 * t122;
  t125 = t113 * t34 - t117 * t123;
  t126 = t125 * t38;
  t127 = t126 * t41;
  t128 = t36 * t37;
  t129 = t128 * t41;
  t130 = 0.2e1 * t129;
  t131 = t40 * t1;
  t132 = 0.1e1 / t131;
  t133 = t39 * t132;
  t134 = 0.2e1 * t133;
  t138 = 0.10463742111268461976e-1 * t8 - 0.52081226957619462095e-2 * t41 + 0.73374941840795522926e-2 * t92;
  t140 = t49 * t49;
  t141 = 0.1e1 / t140;
  t142 = t46 * t141;
  t145 = -0.40178789401832641363e0 * t8 - 0.31331640323498865411e0 * t92;
  t146 = 0.1e1 / t51;
  t147 = t145 * t146;
  t149 = t138 * t52 - t142 * t147;
  t150 = t149 * t55;
  t151 = t150 * t58;
  t152 = t38 * t37;
  t153 = t54 * t152;
  t154 = t153 * t58;
  t155 = 0.4e1 * t154;
  t156 = t57 * t1;
  t157 = 0.1e1 / t156;
  t158 = t56 * t157;
  t159 = 0.4e1 * t158;
  t160 = t5 * t61;
  t161 = t63 * t85;
  t162 = t160 * t161;
  t163 = 0.28405974243041479528e0 * t162;
  t165 = t64 * t14 * t85;
  t166 = 0.2e1 / 0.3e1 * t165;
  t167 = t37 * t41;
  t168 = t5 - t167;
  t171 = my_piecewise3(t68, 0, 0.3e1 / 0.2e1 * t71 * t168);
  t173 = -t168;
  t176 = my_piecewise3(t76, 0, 0.3e1 / 0.2e1 * t77 * t173);
  t178 = 0.3e1 / 0.4e1 * t167;
  t180 = 0.3e1 / 0.4e1 * t38 * t132;
  t182 = 0.3e1 / 0.32e2 * t152 * t58;
  t184 = 0.3e1 / 0.32e2 * t55 * t157;
  t185 = t171 / 0.2e1 + t176 / 0.2e1 - t178 + t180 - t182 + t184;
  t187 = t64 * t65 * t185;
  t188 = 0.4e1 / 0.3e1 * t187;
  t189 = t95 - t109 + t127 + t130 - t134 + t151 + t155 - t159 - t163 - t166 - t188;
  tvrho0 = -0.1925e0 + t23 + t42 + t59 - t88 + t1 * t189;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t191 = -t5 - t167;
  t194 = my_piecewise3(t68, 0, 0.3e1 / 0.2e1 * t71 * t191);
  t196 = -t191;
  t199 = my_piecewise3(t76, 0, 0.3e1 / 0.2e1 * t77 * t196);
  t201 = t194 / 0.2e1 + t199 / 0.2e1 + t178 + t180 + t182 + t184;
  t203 = t64 * t65 * t201;
  t204 = 0.4e1 / 0.3e1 * t203;
  t205 = t95 - t109 + t127 - t130 - t134 + t151 - t155 - t159 - t163 - t166 - t204;
  tvrho1 = -0.1925e0 + t23 + t42 + t59 - t88 + t1 * t205;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t5, t8, t10, t12, t13;
  double t14, t15, t19, t21, t22, t23, t27, t31;
  double t33, t34, t36, t37, t38, t39, t40, t41;
  double t42, t46, t49, t51, t52, t54, t55, t56;
  double t57, t58, t59, t61, t63, t64, t65, t66;
  double t67, t68, t69, t70, t71, t72, t73, t75;
  double t76, t77, t78, t79, t85, t88, tzk0;

  double t92, t94, t95, t96, t97, t98, t100, t101;
  double t106, t107, t108, t109, t113, t115, t116, t117;
  double t121, t122, t123, t125, t126, t127, t128, t129;
  double t130, t131, t132, t133, t134, t138, t140, t141;
  double t142, t145, t146, t147, t149, t150, t151, t152;
  double t153, t154, t155, t156, t157, t158, t159, t160;
  double t161, t162, t163, t165, t166, t167, t168, t171;
  double t173, t176, t178, t180, t182, t184, t185, t187;
  double t188, t189, tvrho0, t191, t194, t196, t199, t201;
  double t203, t204, t205, tvrho1;

  double t207, t208, t209, t210, t211, t212, t213, t214;
  double t215, t216, t218, t219, t220, t221, t222, t223;
  double t224, t225, t226, t227, t229, t230, t231, t232;
  double t235, t237, t241, t243, t244, t247, t251, t253;
  double t254, t255, t256, t258, t260, t262, t263, t265;
  double t266, t267, t268, t269, t271, t273, t280, t282;
  double t283, t284, t285, t286, t287, t288, t289, t290;
  double t291, t292, t293, t294, t295, t296, t297, t298;
  double t299, t300, t301, t302, t303, t304, t305, t306;
  double t307, t308, t309, t310, t311, t312, t313, t314;
  double t315, t316, t317, t318, t319, t323, t325, t328;
  double t329, t330, t331, t332, t338, t339, t341, t342;
  double t343, t344, t345, t346, t348, t349, t350, t351;
  double t352, t356, t358, t361, t362, t363, t364, t365;
  double t370, t371, t373, t374, t375, t376, t377, t378;
  double t380, t381, t382, t386, t387, t388, t390, t391;
  double t392, tv2rho20, t396, t399, t403, t405, t408, t412;
  double t415, t417, t421, t422, t425, t427, tv2rho21, t431;
  double t435, t439, t441, t444, t448, t450, t452, t453;
  double t454, t455, t456, t457, tv2rho22;


  t1 = rho[0] + rho[1];
  t2 = sqrt(t1);
  t3 = 0.1e1 / t2;
  t5 = 0.1e1 / t1;
  t8 = 0.1e1 / t2 / t1;
  t10 = 0.48697234038507617049e-1 * t3 + 0.18219548589342283974e-1 * t5 + 0.6039470020288820178e-3 * t8;
  t12 = sqrt(M_PI);
  t13 = 0.1e1 / t12;
  t14 = t13 * t3;
  t15 = POW_3_2(t14);
  t19 = 0.56543080063156135078e0 * t3 - 0.2069e-1 * t15 + 0.1082158120059033146e0 * t5 + 0.31373870235266598327e-2 * t8;
  t21 = 0.1e1 + 0.1e1 / t19;
  t22 = log(t21);
  t23 = t10 * t22;
  t27 = -0.19148594465610848379e-1 * t3 - 0.24406887987971425426e-2 * t5 - 0.16433379454670369131e-4 * t8;
  t31 = 0.2331795548802876734e0 * t3 + 0.21277965468761999883e-1 * t5 + 0.14005999654541740146e-3 * t8;
  t33 = 0.1e1 + 0.1e1 / t31;
  t34 = log(t33);
  t36 = 0.117331e0 + t27 * t34;
  t37 = rho[0] - rho[1];
  t38 = t37 * t37;
  t39 = t36 * t38;
  t40 = t1 * t1;
  t41 = 0.1e1 / t40;
  t42 = t39 * t41;
  t46 = -0.20927484222536923952e-1 * t3 + 0.52081226957619462095e-2 * t5 - 0.48916627893863681951e-2 * t8;
  t49 = 0.80357578803665282726e0 * t3 + 0.20887760215665910274e0 * t8;
  t51 = 0.1e1 + 0.1e1 / t49;
  t52 = log(t51);
  t54 = 0.234188e-1 + t46 * t52;
  t55 = t38 * t38;
  t56 = t54 * t55;
  t57 = t40 * t40;
  t58 = 0.1e1 / t57;
  t59 = t56 * t58;
  t61 = exp(-0.75522417653702656571e0 * t3);
  t63 = M_SQRT2;
  t64 = (t61 - 0.1e1) * t63;
  t65 = t13 * t2;
  t66 = t37 * t5;
  t67 = 0.1e1 + t66;
  t68 = t67 <= p->zeta_threshold;
  t69 = sqrt(p->zeta_threshold);
  t70 = t69 * p->zeta_threshold;
  t71 = sqrt(t67);
  t72 = t71 * t67;
  t73 = my_piecewise3(t68, t70, t72);
  t75 = 0.1e1 - t66;
  t76 = t75 <= p->zeta_threshold;
  t77 = sqrt(t75);
  t78 = t77 * t75;
  t79 = my_piecewise3(t76, t70, t78);
  t85 = t73 / 0.2e1 + t79 / 0.2e1 - 0.1e1 - 0.3e1 / 0.8e1 * t38 * t41 - 0.3e1 / 0.128e3 * t55 * t58;
  t88 = 0.4e1 / 0.3e1 * t64 * t65 * t85;
  tzk0 = -0.1925e0 + t23 + t42 + t59 - t88;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t92 = 0.1e1 / t2 / t40;
  t94 = -0.24348617019253808524e-1 * t8 - 0.18219548589342283974e-1 * t41 - 0.9059205030433230267e-3 * t92;
  t95 = t94 * t22;
  t96 = t19 * t19;
  t97 = 0.1e1 / t96;
  t98 = t10 * t97;
  t100 = sqrt(t14);
  t101 = t100 * t13;
  t106 = -0.28271540031578067539e0 * t8 + 0.155175e-1 * t101 * t8 - 0.1082158120059033146e0 * t41 - 0.4706080535289989749e-2 * t92;
  t107 = 0.1e1 / t21;
  t108 = t106 * t107;
  t109 = t98 * t108;
  t113 = 0.95742972328054241895e-2 * t8 + 0.24406887987971425426e-2 * t41 + 0.24650069182005553696e-4 * t92;
  t115 = t31 * t31;
  t116 = 0.1e1 / t115;
  t117 = t27 * t116;
  t121 = -0.1165897774401438367e0 * t8 - 0.21277965468761999883e-1 * t41 - 0.21008999481812610219e-3 * t92;
  t122 = 0.1e1 / t33;
  t123 = t121 * t122;
  t125 = t113 * t34 - t117 * t123;
  t126 = t125 * t38;
  t127 = t126 * t41;
  t128 = t36 * t37;
  t129 = t128 * t41;
  t130 = 0.2e1 * t129;
  t131 = t40 * t1;
  t132 = 0.1e1 / t131;
  t133 = t39 * t132;
  t134 = 0.2e1 * t133;
  t138 = 0.10463742111268461976e-1 * t8 - 0.52081226957619462095e-2 * t41 + 0.73374941840795522926e-2 * t92;
  t140 = t49 * t49;
  t141 = 0.1e1 / t140;
  t142 = t46 * t141;
  t145 = -0.40178789401832641363e0 * t8 - 0.31331640323498865411e0 * t92;
  t146 = 0.1e1 / t51;
  t147 = t145 * t146;
  t149 = t138 * t52 - t142 * t147;
  t150 = t149 * t55;
  t151 = t150 * t58;
  t152 = t38 * t37;
  t153 = t54 * t152;
  t154 = t153 * t58;
  t155 = 0.4e1 * t154;
  t156 = t57 * t1;
  t157 = 0.1e1 / t156;
  t158 = t56 * t157;
  t159 = 0.4e1 * t158;
  t160 = t5 * t61;
  t161 = t63 * t85;
  t162 = t160 * t161;
  t163 = 0.28405974243041479528e0 * t162;
  t165 = t64 * t14 * t85;
  t166 = 0.2e1 / 0.3e1 * t165;
  t167 = t37 * t41;
  t168 = t5 - t167;
  t171 = my_piecewise3(t68, 0, 0.3e1 / 0.2e1 * t71 * t168);
  t173 = -t168;
  t176 = my_piecewise3(t76, 0, 0.3e1 / 0.2e1 * t77 * t173);
  t178 = 0.3e1 / 0.4e1 * t167;
  t180 = 0.3e1 / 0.4e1 * t38 * t132;
  t182 = 0.3e1 / 0.32e2 * t152 * t58;
  t184 = 0.3e1 / 0.32e2 * t55 * t157;
  t185 = t171 / 0.2e1 + t176 / 0.2e1 - t178 + t180 - t182 + t184;
  t187 = t64 * t65 * t185;
  t188 = 0.4e1 / 0.3e1 * t187;
  t189 = t95 - t109 + t127 + t130 - t134 + t151 + t155 - t159 - t163 - t166 - t188;
  tvrho0 = -0.1925e0 + t23 + t42 + t59 - t88 + t1 * t189;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t191 = -t5 - t167;
  t194 = my_piecewise3(t68, 0, 0.3e1 / 0.2e1 * t71 * t191);
  t196 = -t191;
  t199 = my_piecewise3(t76, 0, 0.3e1 / 0.2e1 * t77 * t196);
  t201 = t194 / 0.2e1 + t199 / 0.2e1 + t178 + t180 + t182 + t184;
  t203 = t64 * t65 * t201;
  t204 = 0.4e1 / 0.3e1 * t203;
  t205 = t95 - t109 + t127 - t130 - t134 + t151 - t155 - t159 - t163 - t166 - t204;
  tvrho1 = -0.1925e0 + t23 + t42 + t59 - t88 + t1 * t205;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t207 = 0.2e1 * t95;
  t208 = 0.2e1 * t109;
  t209 = 0.2e1 * t127;
  t210 = 0.4e1 * t129;
  t211 = 0.4e1 * t133;
  t212 = 0.2e1 * t151;
  t213 = 0.8e1 * t154;
  t214 = 0.8e1 * t158;
  t215 = 0.56811948486082959056e0 * t162;
  t216 = 0.4e1 / 0.3e1 * t165;
  t218 = t96 * t19;
  t219 = 0.1e1 / t218;
  t220 = t10 * t219;
  t221 = t106 * t106;
  t222 = t221 * t107;
  t223 = t220 * t222;
  t224 = 0.2e1 * t223;
  t225 = t41 * t61;
  t226 = t225 * t161;
  t227 = 0.14202987121520739764e0 * t226;
  t229 = t64 * t14 * t185;
  t230 = 0.4e1 / 0.3e1 * t229;
  t231 = 0.1e1 / t71;
  t232 = t168 * t168;
  t235 = t37 * t132;
  t237 = -0.2e1 * t41 + 0.2e1 * t235;
  t241 = my_piecewise3(t68, 0, 0.3e1 / 0.4e1 * t231 * t232 + 0.3e1 / 0.2e1 * t71 * t237);
  t243 = 0.1e1 / t77;
  t244 = t173 * t173;
  t247 = -t237;
  t251 = my_piecewise3(t76, 0, 0.3e1 / 0.4e1 * t243 * t244 + 0.3e1 / 0.2e1 * t77 * t247);
  t253 = 0.3e1 / 0.4e1 * t41;
  t254 = 0.3e1 * t235;
  t255 = t38 * t58;
  t256 = 0.81e2 / 0.32e2 * t255;
  t258 = 0.3e1 / 0.4e1 * t152 * t157;
  t260 = 0.1e1 / t57 / t40;
  t262 = 0.15e2 / 0.32e2 * t55 * t260;
  t263 = t241 / 0.2e1 + t251 / 0.2e1 - t253 + t254 - t256 + t258 - t262;
  t265 = t64 * t65 * t263;
  t266 = 0.4e1 / 0.3e1 * t265;
  t267 = t94 * t97;
  t268 = t267 * t108;
  t269 = 0.2e1 * t268;
  t271 = 0.1e1/sqrt(t14);
  t273 = t271 / M_PI;
  t280 = 0.1e1 / t2 / t131;
  t282 = 0.42407310047367101308e0 * t92 - 0.3879375e-2 * t273 * t132 - 0.2327625e-1 * t101 * t92 + 0.2164316240118066292e0 * t132 + 0.11765201338224974372e-1 * t280;
  t283 = t282 * t107;
  t284 = t98 * t283;
  t285 = t96 * t96;
  t286 = 0.1e1 / t285;
  t287 = t10 * t286;
  t288 = t21 * t21;
  t289 = 0.1e1 / t288;
  t290 = t221 * t289;
  t291 = t287 * t290;
  t292 = t125 * t37;
  t293 = t292 * t41;
  t294 = 0.4e1 * t293;
  t295 = t126 * t132;
  t296 = 0.4e1 * t295;
  t297 = t128 * t132;
  t298 = 0.8e1 * t297;
  t299 = t39 * t58;
  t300 = 0.6e1 * t299;
  t301 = t224 + t227 - t230 - t266 - t269 - t284 - t291 + t294 - t296 - t298 + t300;
  t302 = t149 * t152;
  t303 = t302 * t58;
  t304 = 0.8e1 * t303;
  t305 = t150 * t157;
  t306 = 0.8e1 * t305;
  t307 = t54 * t38;
  t308 = t307 * t58;
  t309 = 0.12e2 * t308;
  t310 = t153 * t157;
  t311 = 0.32e2 * t310;
  t312 = t56 * t260;
  t313 = 0.2e2 * t312;
  t314 = t63 * t185;
  t315 = t160 * t314;
  t316 = 0.56811948486082959056e0 * t315;
  t317 = t92 * t61;
  t318 = t317 * t161;
  t319 = 0.10726439253216493952e0 * t318;
  t323 = -0.14361445849208136284e-1 * t92 - 0.48813775975942850852e-2 * t132 - 0.6162517295501388424e-4 * t280;
  t325 = t113 * t116;
  t328 = t115 * t31;
  t329 = 0.1e1 / t328;
  t330 = t27 * t329;
  t331 = t121 * t121;
  t332 = t331 * t122;
  t338 = 0.17488466616021575505e0 * t92 + 0.42555930937523999766e-1 * t132 + 0.52522498704531525548e-3 * t280;
  t339 = t338 * t122;
  t341 = t115 * t115;
  t342 = 0.1e1 / t341;
  t343 = t27 * t342;
  t344 = t33 * t33;
  t345 = 0.1e1 / t344;
  t346 = t331 * t345;
  t348 = -t117 * t339 - 0.2e1 * t325 * t123 + t323 * t34 + 0.2e1 * t330 * t332 - t343 * t346;
  t349 = t348 * t38;
  t350 = t349 * t41;
  t351 = t36 * t41;
  t352 = 0.2e1 * t351;
  t356 = -0.15695613166902692964e-1 * t92 + 0.10416245391523892419e-1 * t132 - 0.18343735460198880732e-1 * t280;
  t358 = t138 * t141;
  t361 = t140 * t49;
  t362 = 0.1e1 / t361;
  t363 = t46 * t362;
  t364 = t145 * t145;
  t365 = t364 * t146;
  t370 = 0.60268184102748962044e0 * t92 + 0.78329100808747163528e0 * t280;
  t371 = t370 * t146;
  t373 = t140 * t140;
  t374 = 0.1e1 / t373;
  t375 = t46 * t374;
  t376 = t51 * t51;
  t377 = 0.1e1 / t376;
  t378 = t364 * t377;
  t380 = -t142 * t371 - 0.2e1 * t358 * t147 + t356 * t52 + 0.2e1 * t363 * t365 - t375 * t378;
  t381 = t380 * t55;
  t382 = t381 * t58;
  t386 = 0.36522925528880712786e-1 * t92 + 0.36439097178684567948e-1 * t132 + 0.22648012576083075668e-2 * t280;
  t387 = t386 * t22;
  t388 = t13 * t8;
  t390 = t64 * t388 * t85;
  t391 = t390 / 0.3e1;
  t392 = t304 - t306 + t309 - t311 + t313 - t316 - t319 + t350 + t352 + t382 + t387 + t391;
  tv2rho20 = t207 - t208 + t209 + t210 - t211 + t212 + t213 - t214 - t215 - t216 - 0.8e1 / 0.3e1 * t187 + t1 * (t301 + t392);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t396 = t231 * t191;
  t399 = t71 * t37;
  t403 = my_piecewise3(t68, 0, 0.3e1 / 0.4e1 * t396 * t168 + 0.3e1 * t399 * t132);
  t405 = t243 * t196;
  t408 = t77 * t37;
  t412 = my_piecewise3(t76, 0, 0.3e1 / 0.4e1 * t405 * t173 - 0.3e1 * t408 * t132);
  t415 = t403 / 0.2e1 + t412 / 0.2e1 + t253 - 0.63e2 / 0.32e2 * t255 - t262;
  t417 = t64 * t65 * t415;
  t421 = t63 * t201;
  t422 = t160 * t421;
  t425 = t64 * t14 * t201;
  t427 = -t309 + t313 - 0.28405974243041479528e0 * t315 - t319 - 0.28405974243041479528e0 * t422 + t350 - t352 + t382 + t387 + t391 - 0.2e1 / 0.3e1 * t425;
  tv2rho21 = t207 - t208 + t209 - t211 + t212 - t214 - t215 - t216 - t188 - t204 + t1 * (t224 + t227 - 0.2e1 / 0.3e1 * t229 - 0.4e1 / 0.3e1 * t417 - t269 - t284 - t291 - t296 + t300 - t306 + t427);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t431 = t191 * t191;
  t435 = 0.2e1 * t41 + 0.2e1 * t235;
  t439 = my_piecewise3(t68, 0, 0.3e1 / 0.4e1 * t231 * t431 + 0.3e1 / 0.2e1 * t71 * t435);
  t441 = t196 * t196;
  t444 = -t435;
  t448 = my_piecewise3(t76, 0, 0.3e1 / 0.4e1 * t243 * t441 + 0.3e1 / 0.2e1 * t77 * t444);
  t450 = t439 / 0.2e1 + t448 / 0.2e1 - t253 - t254 - t256 - t258 - t262;
  t452 = t64 * t65 * t450;
  t453 = 0.4e1 / 0.3e1 * t452;
  t454 = t224 + t227 - t453 - t269 - t284 - t291 - t294 - t296 + t298 + t300 - t304;
  t455 = 0.56811948486082959056e0 * t422;
  t456 = 0.4e1 / 0.3e1 * t425;
  t457 = -t306 + t309 + t311 + t313 - t319 - t455 + t350 + t352 + t382 + t387 + t391 - t456;
  tv2rho22 = t207 - t208 + t209 - t210 - t211 + t212 - t213 - t214 - t215 - t216 - 0.8e1 / 0.3e1 * t203 + t1 * (t454 + t457);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t5, t8, t10, t12, t13;
  double t14, t15, t19, t21, t22, t23, t27, t31;
  double t33, t34, t36, t37, t38, t39, t40, t41;
  double t42, t46, t49, t51, t52, t54, t55, t56;
  double t57, t58, t59, t61, t63, t64, t65, t66;
  double t67, t68, t69, t70, t71, t72, t73, t75;
  double t76, t77, t78, t79, t85, t88, tzk0;

  double t92, t94, t95, t96, t97, t98, t100, t101;
  double t106, t107, t108, t109, t113, t115, t116, t117;
  double t121, t122, t123, t125, t126, t127, t128, t129;
  double t130, t131, t132, t133, t134, t138, t140, t141;
  double t142, t145, t146, t147, t149, t150, t151, t152;
  double t153, t154, t155, t156, t157, t158, t159, t160;
  double t161, t162, t163, t165, t166, t167, t168, t171;
  double t173, t176, t178, t180, t182, t184, t185, t187;
  double t188, t189, tvrho0, t191, t194, t196, t199, t201;
  double t203, t204, t205, tvrho1;

  double t207, t208, t209, t210, t211, t212, t213, t214;
  double t215, t216, t218, t219, t220, t221, t222, t223;
  double t224, t225, t226, t227, t229, t230, t231, t232;
  double t235, t237, t241, t243, t244, t247, t251, t253;
  double t254, t255, t256, t258, t260, t262, t263, t265;
  double t266, t267, t268, t269, t271, t273, t280, t282;
  double t283, t284, t285, t286, t287, t288, t289, t290;
  double t291, t292, t293, t294, t295, t296, t297, t298;
  double t299, t300, t301, t302, t303, t304, t305, t306;
  double t307, t308, t309, t310, t311, t312, t313, t314;
  double t315, t316, t317, t318, t319, t323, t325, t328;
  double t329, t330, t331, t332, t338, t339, t341, t342;
  double t343, t344, t345, t346, t348, t349, t350, t351;
  double t352, t356, t358, t361, t362, t363, t364, t365;
  double t370, t371, t373, t374, t375, t376, t377, t378;
  double t380, t381, t382, t386, t387, t388, t390, t391;
  double t392, tv2rho20, t396, t399, t403, t405, t408, t412;
  double t415, t417, t421, t422, t425, t427, tv2rho21, t431;
  double t435, t439, t441, t444, t448, t450, t452, t453;
  double t454, t455, t456, t457, tv2rho22;

  double t460, t461, t464, t465, t466, t467, t468, t469;
  double t470, t471, t472, t473, t474, t475, t476, t478;
  double t479, t480, t481, t482, t486, t488, t489, t490;
  double t491, t492, t493, t494, t495, t498, t501, t503;
  double t507, t509, t510, t513, t516, t520, t522, t523;
  double t524, t525, t526, t527, t529, t531, t532, t534;
  double t535, t537, t538, t539, t541, t542, t544, t545;
  double t546, t547, t548, t550, t555, t557, t560, t565;
  double t568, t569, t572, t576, t577, t578, t583, t584;
  double t587, t591, t592, t594, t595, t598, t599, t600;
  double t601, t602, t603, t604, t605, t606, t607, t608;
  double t609, t610, t614, t616, t619, t624, t627, t628;
  double t631, t635, t636, t637, t643, t644, t647, t651;
  double t652, t654, t655, t658, t659, t660, t661, t662;
  double t663, t664, t665, t666, t667, t668, t669, t670;
  double t671, t672, t673, t674, t675, t676, t677, t678;
  double t679, t680, t681, t682, t683, t684, t685, t687;
  double t688, t689, t690, t691, t692, t693, t694, t695;
  double t696, t697, t698, t699, t701, t702, t703, t704;
  double t705, t706, t707, t708, t710, t713, t722, t723;
  double t724, t726, t727, t729, t730, t731, t732, t733;
  double t734, t735, t736, t737, t738, t739, t740, t741;
  double t742, t743, t744, t745, t746, t747, t750, tv3rho30;
  double t751, t752, t753, t756, t767, t769, t772, t783;
  double t785, t786, t787, t788, t789, t791, t794, t795;
  double t797, t801, t802, t803, t804, t805, t806, t807;
  double t809, t810, t811, t812, t814, t816, t817, t818;
  double t820, t823, t827, t829, t831, tv3rho31, t832, t837;
  double t842, t846, t848, t853, t856, t860, t862, t864;
  double t867, t871, t872, t874, t875, t879, t882, t886;
  double t889, tv3rho32, t891, t894, t900, t904, t906, t911;
  double t915, t917, t919, t920, t922, t924, t925, t926;
  double t929, tv3rho33;


  t1 = rho[0] + rho[1];
  t2 = sqrt(t1);
  t3 = 0.1e1 / t2;
  t5 = 0.1e1 / t1;
  t8 = 0.1e1 / t2 / t1;
  t10 = 0.48697234038507617049e-1 * t3 + 0.18219548589342283974e-1 * t5 + 0.6039470020288820178e-3 * t8;
  t12 = sqrt(M_PI);
  t13 = 0.1e1 / t12;
  t14 = t13 * t3;
  t15 = POW_3_2(t14);
  t19 = 0.56543080063156135078e0 * t3 - 0.2069e-1 * t15 + 0.1082158120059033146e0 * t5 + 0.31373870235266598327e-2 * t8;
  t21 = 0.1e1 + 0.1e1 / t19;
  t22 = log(t21);
  t23 = t10 * t22;
  t27 = -0.19148594465610848379e-1 * t3 - 0.24406887987971425426e-2 * t5 - 0.16433379454670369131e-4 * t8;
  t31 = 0.2331795548802876734e0 * t3 + 0.21277965468761999883e-1 * t5 + 0.14005999654541740146e-3 * t8;
  t33 = 0.1e1 + 0.1e1 / t31;
  t34 = log(t33);
  t36 = 0.117331e0 + t27 * t34;
  t37 = rho[0] - rho[1];
  t38 = t37 * t37;
  t39 = t36 * t38;
  t40 = t1 * t1;
  t41 = 0.1e1 / t40;
  t42 = t39 * t41;
  t46 = -0.20927484222536923952e-1 * t3 + 0.52081226957619462095e-2 * t5 - 0.48916627893863681951e-2 * t8;
  t49 = 0.80357578803665282726e0 * t3 + 0.20887760215665910274e0 * t8;
  t51 = 0.1e1 + 0.1e1 / t49;
  t52 = log(t51);
  t54 = 0.234188e-1 + t46 * t52;
  t55 = t38 * t38;
  t56 = t54 * t55;
  t57 = t40 * t40;
  t58 = 0.1e1 / t57;
  t59 = t56 * t58;
  t61 = exp(-0.75522417653702656571e0 * t3);
  t63 = M_SQRT2;
  t64 = (t61 - 0.1e1) * t63;
  t65 = t13 * t2;
  t66 = t37 * t5;
  t67 = 0.1e1 + t66;
  t68 = t67 <= p->zeta_threshold;
  t69 = sqrt(p->zeta_threshold);
  t70 = t69 * p->zeta_threshold;
  t71 = sqrt(t67);
  t72 = t71 * t67;
  t73 = my_piecewise3(t68, t70, t72);
  t75 = 0.1e1 - t66;
  t76 = t75 <= p->zeta_threshold;
  t77 = sqrt(t75);
  t78 = t77 * t75;
  t79 = my_piecewise3(t76, t70, t78);
  t85 = t73 / 0.2e1 + t79 / 0.2e1 - 0.1e1 - 0.3e1 / 0.8e1 * t38 * t41 - 0.3e1 / 0.128e3 * t55 * t58;
  t88 = 0.4e1 / 0.3e1 * t64 * t65 * t85;
  tzk0 = -0.1925e0 + t23 + t42 + t59 - t88;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t92 = 0.1e1 / t2 / t40;
  t94 = -0.24348617019253808524e-1 * t8 - 0.18219548589342283974e-1 * t41 - 0.9059205030433230267e-3 * t92;
  t95 = t94 * t22;
  t96 = t19 * t19;
  t97 = 0.1e1 / t96;
  t98 = t10 * t97;
  t100 = sqrt(t14);
  t101 = t100 * t13;
  t106 = -0.28271540031578067539e0 * t8 + 0.155175e-1 * t101 * t8 - 0.1082158120059033146e0 * t41 - 0.4706080535289989749e-2 * t92;
  t107 = 0.1e1 / t21;
  t108 = t106 * t107;
  t109 = t98 * t108;
  t113 = 0.95742972328054241895e-2 * t8 + 0.24406887987971425426e-2 * t41 + 0.24650069182005553696e-4 * t92;
  t115 = t31 * t31;
  t116 = 0.1e1 / t115;
  t117 = t27 * t116;
  t121 = -0.1165897774401438367e0 * t8 - 0.21277965468761999883e-1 * t41 - 0.21008999481812610219e-3 * t92;
  t122 = 0.1e1 / t33;
  t123 = t121 * t122;
  t125 = t113 * t34 - t117 * t123;
  t126 = t125 * t38;
  t127 = t126 * t41;
  t128 = t36 * t37;
  t129 = t128 * t41;
  t130 = 0.2e1 * t129;
  t131 = t40 * t1;
  t132 = 0.1e1 / t131;
  t133 = t39 * t132;
  t134 = 0.2e1 * t133;
  t138 = 0.10463742111268461976e-1 * t8 - 0.52081226957619462095e-2 * t41 + 0.73374941840795522926e-2 * t92;
  t140 = t49 * t49;
  t141 = 0.1e1 / t140;
  t142 = t46 * t141;
  t145 = -0.40178789401832641363e0 * t8 - 0.31331640323498865411e0 * t92;
  t146 = 0.1e1 / t51;
  t147 = t145 * t146;
  t149 = t138 * t52 - t142 * t147;
  t150 = t149 * t55;
  t151 = t150 * t58;
  t152 = t38 * t37;
  t153 = t54 * t152;
  t154 = t153 * t58;
  t155 = 0.4e1 * t154;
  t156 = t57 * t1;
  t157 = 0.1e1 / t156;
  t158 = t56 * t157;
  t159 = 0.4e1 * t158;
  t160 = t5 * t61;
  t161 = t63 * t85;
  t162 = t160 * t161;
  t163 = 0.28405974243041479528e0 * t162;
  t165 = t64 * t14 * t85;
  t166 = 0.2e1 / 0.3e1 * t165;
  t167 = t37 * t41;
  t168 = t5 - t167;
  t171 = my_piecewise3(t68, 0, 0.3e1 / 0.2e1 * t71 * t168);
  t173 = -t168;
  t176 = my_piecewise3(t76, 0, 0.3e1 / 0.2e1 * t77 * t173);
  t178 = 0.3e1 / 0.4e1 * t167;
  t180 = 0.3e1 / 0.4e1 * t38 * t132;
  t182 = 0.3e1 / 0.32e2 * t152 * t58;
  t184 = 0.3e1 / 0.32e2 * t55 * t157;
  t185 = t171 / 0.2e1 + t176 / 0.2e1 - t178 + t180 - t182 + t184;
  t187 = t64 * t65 * t185;
  t188 = 0.4e1 / 0.3e1 * t187;
  t189 = t95 - t109 + t127 + t130 - t134 + t151 + t155 - t159 - t163 - t166 - t188;
  tvrho0 = -0.1925e0 + t23 + t42 + t59 - t88 + t1 * t189;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t191 = -t5 - t167;
  t194 = my_piecewise3(t68, 0, 0.3e1 / 0.2e1 * t71 * t191);
  t196 = -t191;
  t199 = my_piecewise3(t76, 0, 0.3e1 / 0.2e1 * t77 * t196);
  t201 = t194 / 0.2e1 + t199 / 0.2e1 + t178 + t180 + t182 + t184;
  t203 = t64 * t65 * t201;
  t204 = 0.4e1 / 0.3e1 * t203;
  t205 = t95 - t109 + t127 - t130 - t134 + t151 - t155 - t159 - t163 - t166 - t204;
  tvrho1 = -0.1925e0 + t23 + t42 + t59 - t88 + t1 * t205;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t207 = 0.2e1 * t95;
  t208 = 0.2e1 * t109;
  t209 = 0.2e1 * t127;
  t210 = 0.4e1 * t129;
  t211 = 0.4e1 * t133;
  t212 = 0.2e1 * t151;
  t213 = 0.8e1 * t154;
  t214 = 0.8e1 * t158;
  t215 = 0.56811948486082959056e0 * t162;
  t216 = 0.4e1 / 0.3e1 * t165;
  t218 = t96 * t19;
  t219 = 0.1e1 / t218;
  t220 = t10 * t219;
  t221 = t106 * t106;
  t222 = t221 * t107;
  t223 = t220 * t222;
  t224 = 0.2e1 * t223;
  t225 = t41 * t61;
  t226 = t225 * t161;
  t227 = 0.14202987121520739764e0 * t226;
  t229 = t64 * t14 * t185;
  t230 = 0.4e1 / 0.3e1 * t229;
  t231 = 0.1e1 / t71;
  t232 = t168 * t168;
  t235 = t37 * t132;
  t237 = -0.2e1 * t41 + 0.2e1 * t235;
  t241 = my_piecewise3(t68, 0, 0.3e1 / 0.4e1 * t231 * t232 + 0.3e1 / 0.2e1 * t71 * t237);
  t243 = 0.1e1 / t77;
  t244 = t173 * t173;
  t247 = -t237;
  t251 = my_piecewise3(t76, 0, 0.3e1 / 0.4e1 * t243 * t244 + 0.3e1 / 0.2e1 * t77 * t247);
  t253 = 0.3e1 / 0.4e1 * t41;
  t254 = 0.3e1 * t235;
  t255 = t38 * t58;
  t256 = 0.81e2 / 0.32e2 * t255;
  t258 = 0.3e1 / 0.4e1 * t152 * t157;
  t260 = 0.1e1 / t57 / t40;
  t262 = 0.15e2 / 0.32e2 * t55 * t260;
  t263 = t241 / 0.2e1 + t251 / 0.2e1 - t253 + t254 - t256 + t258 - t262;
  t265 = t64 * t65 * t263;
  t266 = 0.4e1 / 0.3e1 * t265;
  t267 = t94 * t97;
  t268 = t267 * t108;
  t269 = 0.2e1 * t268;
  t271 = 0.1e1/sqrt(t14);
  t273 = t271 / M_PI;
  t280 = 0.1e1 / t2 / t131;
  t282 = 0.42407310047367101308e0 * t92 - 0.3879375e-2 * t273 * t132 - 0.2327625e-1 * t101 * t92 + 0.2164316240118066292e0 * t132 + 0.11765201338224974372e-1 * t280;
  t283 = t282 * t107;
  t284 = t98 * t283;
  t285 = t96 * t96;
  t286 = 0.1e1 / t285;
  t287 = t10 * t286;
  t288 = t21 * t21;
  t289 = 0.1e1 / t288;
  t290 = t221 * t289;
  t291 = t287 * t290;
  t292 = t125 * t37;
  t293 = t292 * t41;
  t294 = 0.4e1 * t293;
  t295 = t126 * t132;
  t296 = 0.4e1 * t295;
  t297 = t128 * t132;
  t298 = 0.8e1 * t297;
  t299 = t39 * t58;
  t300 = 0.6e1 * t299;
  t301 = t224 + t227 - t230 - t266 - t269 - t284 - t291 + t294 - t296 - t298 + t300;
  t302 = t149 * t152;
  t303 = t302 * t58;
  t304 = 0.8e1 * t303;
  t305 = t150 * t157;
  t306 = 0.8e1 * t305;
  t307 = t54 * t38;
  t308 = t307 * t58;
  t309 = 0.12e2 * t308;
  t310 = t153 * t157;
  t311 = 0.32e2 * t310;
  t312 = t56 * t260;
  t313 = 0.2e2 * t312;
  t314 = t63 * t185;
  t315 = t160 * t314;
  t316 = 0.56811948486082959056e0 * t315;
  t317 = t92 * t61;
  t318 = t317 * t161;
  t319 = 0.10726439253216493952e0 * t318;
  t323 = -0.14361445849208136284e-1 * t92 - 0.48813775975942850852e-2 * t132 - 0.6162517295501388424e-4 * t280;
  t325 = t113 * t116;
  t328 = t115 * t31;
  t329 = 0.1e1 / t328;
  t330 = t27 * t329;
  t331 = t121 * t121;
  t332 = t331 * t122;
  t338 = 0.17488466616021575505e0 * t92 + 0.42555930937523999766e-1 * t132 + 0.52522498704531525548e-3 * t280;
  t339 = t338 * t122;
  t341 = t115 * t115;
  t342 = 0.1e1 / t341;
  t343 = t27 * t342;
  t344 = t33 * t33;
  t345 = 0.1e1 / t344;
  t346 = t331 * t345;
  t348 = -t117 * t339 - 0.2e1 * t325 * t123 + t323 * t34 + 0.2e1 * t330 * t332 - t343 * t346;
  t349 = t348 * t38;
  t350 = t349 * t41;
  t351 = t36 * t41;
  t352 = 0.2e1 * t351;
  t356 = -0.15695613166902692964e-1 * t92 + 0.10416245391523892419e-1 * t132 - 0.18343735460198880732e-1 * t280;
  t358 = t138 * t141;
  t361 = t140 * t49;
  t362 = 0.1e1 / t361;
  t363 = t46 * t362;
  t364 = t145 * t145;
  t365 = t364 * t146;
  t370 = 0.60268184102748962044e0 * t92 + 0.78329100808747163528e0 * t280;
  t371 = t370 * t146;
  t373 = t140 * t140;
  t374 = 0.1e1 / t373;
  t375 = t46 * t374;
  t376 = t51 * t51;
  t377 = 0.1e1 / t376;
  t378 = t364 * t377;
  t380 = -t142 * t371 - 0.2e1 * t358 * t147 + t356 * t52 + 0.2e1 * t363 * t365 - t375 * t378;
  t381 = t380 * t55;
  t382 = t381 * t58;
  t386 = 0.36522925528880712786e-1 * t92 + 0.36439097178684567948e-1 * t132 + 0.22648012576083075668e-2 * t280;
  t387 = t386 * t22;
  t388 = t13 * t8;
  t390 = t64 * t388 * t85;
  t391 = t390 / 0.3e1;
  t392 = t304 - t306 + t309 - t311 + t313 - t316 - t319 + t350 + t352 + t382 + t387 + t391;
  tv2rho20 = t207 - t208 + t209 + t210 - t211 + t212 + t213 - t214 - t215 - t216 - 0.8e1 / 0.3e1 * t187 + t1 * (t301 + t392);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t396 = t231 * t191;
  t399 = t71 * t37;
  t403 = my_piecewise3(t68, 0, 0.3e1 / 0.4e1 * t396 * t168 + 0.3e1 * t399 * t132);
  t405 = t243 * t196;
  t408 = t77 * t37;
  t412 = my_piecewise3(t76, 0, 0.3e1 / 0.4e1 * t405 * t173 - 0.3e1 * t408 * t132);
  t415 = t403 / 0.2e1 + t412 / 0.2e1 + t253 - 0.63e2 / 0.32e2 * t255 - t262;
  t417 = t64 * t65 * t415;
  t421 = t63 * t201;
  t422 = t160 * t421;
  t425 = t64 * t14 * t201;
  t427 = -t309 + t313 - 0.28405974243041479528e0 * t315 - t319 - 0.28405974243041479528e0 * t422 + t350 - t352 + t382 + t387 + t391 - 0.2e1 / 0.3e1 * t425;
  tv2rho21 = t207 - t208 + t209 - t211 + t212 - t214 - t215 - t216 - t188 - t204 + t1 * (t224 + t227 - 0.2e1 / 0.3e1 * t229 - 0.4e1 / 0.3e1 * t417 - t269 - t284 - t291 - t296 + t300 - t306 + t427);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t431 = t191 * t191;
  t435 = 0.2e1 * t41 + 0.2e1 * t235;
  t439 = my_piecewise3(t68, 0, 0.3e1 / 0.4e1 * t231 * t431 + 0.3e1 / 0.2e1 * t71 * t435);
  t441 = t196 * t196;
  t444 = -t435;
  t448 = my_piecewise3(t76, 0, 0.3e1 / 0.4e1 * t243 * t441 + 0.3e1 / 0.2e1 * t77 * t444);
  t450 = t439 / 0.2e1 + t448 / 0.2e1 - t253 - t254 - t256 - t258 - t262;
  t452 = t64 * t65 * t450;
  t453 = 0.4e1 / 0.3e1 * t452;
  t454 = t224 + t227 - t453 - t269 - t284 - t291 - t294 - t296 + t298 + t300 - t304;
  t455 = 0.56811948486082959056e0 * t422;
  t456 = 0.4e1 / 0.3e1 * t425;
  t457 = -t306 + t309 + t311 + t313 - t319 - t455 + t350 + t352 + t382 + t387 + t391 - t456;
  tv2rho22 = t207 - t208 + t209 - t210 - t211 + t212 - t213 - t214 - t215 - t216 - 0.8e1 / 0.3e1 * t203 + t1 * (t454 + t457);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t460 = 0.6e1 * t223;
  t461 = 0.42608961364562219292e0 * t226;
  t464 = 0.6e1 * t268;
  t465 = 0.3e1 * t284;
  t466 = 0.3e1 * t291;
  t467 = 0.12e2 * t293;
  t468 = 0.12e2 * t295;
  t469 = 0.24e2 * t297;
  t470 = 0.18e2 * t299;
  t471 = 0.24e2 * t303;
  t472 = t460 + t461 - 0.4e1 * t229 - 0.4e1 * t265 - t464 - t465 - t466 + t467 - t468 - t469 + t470 + t471;
  t473 = 0.24e2 * t305;
  t474 = 0.36e2 * t308;
  t475 = 0.96e2 * t310;
  t476 = 0.6e2 * t312;
  t478 = 0.32179317759649481856e0 * t318;
  t479 = 0.3e1 * t350;
  t480 = 0.6e1 * t351;
  t481 = 0.3e1 * t382;
  t482 = 0.3e1 * t387;
  t486 = 0.1e1 / t2 / t57;
  t488 = -0.91307313822201781965e-1 * t280 - 0.10931729153605370384e0 * t58 - 0.79268044016290764838e-2 * t486;
  t489 = t488 * t22;
  t490 = t36 * t132;
  t491 = 0.12e2 * t490;
  t492 = t125 * t41;
  t493 = 0.6e1 * t492;
  t494 = 0.1e1 / t72;
  t495 = t232 * t168;
  t498 = t231 * t168;
  t501 = t37 * t58;
  t503 = 0.6e1 * t132 - 0.6e1 * t501;
  t507 = my_piecewise3(t68, 0, -0.3e1 / 0.8e1 * t494 * t495 + 0.9e1 / 0.4e1 * t498 * t237 + 0.3e1 / 0.2e1 * t71 * t503);
  t509 = 0.1e1 / t78;
  t510 = t244 * t173;
  t513 = t243 * t173;
  t516 = -t503;
  t520 = my_piecewise3(t76, 0, -0.3e1 / 0.8e1 * t509 * t510 + 0.9e1 / 0.4e1 * t513 * t247 + 0.3e1 / 0.2e1 * t77 * t516);
  t522 = 0.9e1 / 0.2e1 * t132;
  t523 = 0.225e3 / 0.16e2 * t501;
  t524 = t38 * t157;
  t525 = 0.99e2 / 0.8e1 * t524;
  t526 = t152 * t260;
  t527 = 0.45e2 / 0.8e1 * t526;
  t529 = 0.1e1 / t57 / t131;
  t531 = 0.45e2 / 0.16e2 * t55 * t529;
  t532 = t507 / 0.2e1 + t520 / 0.2e1 + t522 - t523 + t525 - t527 + t531;
  t534 = t64 * t65 * t532;
  t535 = 0.4e1 / 0.3e1 * t534;
  t537 = t282 * t289 * t106;
  t538 = t287 * t537;
  t539 = 0.3e1 * t538;
  t541 = t64 * t388 * t185;
  t542 = t13 * t92;
  t544 = t64 * t542 * t85;
  t545 = t544 / 0.2e1;
  t546 = t108 * t282;
  t547 = t220 * t546;
  t548 = 0.6e1 * t547;
  t550 = t64 * t14 * t263;
  t555 = 0.3923903291725673241e-1 * t280 - 0.31248736174571677257e-1 * t58 + 0.64203074110696082562e-1 * t486;
  t557 = t356 * t141;
  t560 = t138 * t362;
  t565 = t138 * t374;
  t568 = t364 * t145;
  t569 = t568 * t146;
  t572 = t147 * t370;
  t576 = 0.1e1 / t373 / t49;
  t577 = t46 * t576;
  t578 = t568 * t377;
  t583 = -0.15067046025687240511e1 * t280 - 0.27415185283061507235e1 * t486;
  t584 = t583 * t146;
  t587 = t370 * t377 * t145;
  t591 = 0.1e1 / t373 / t140;
  t592 = t46 * t591;
  t594 = 0.1e1 / t376 / t51;
  t595 = t568 * t594;
  t598 = -t142 * t584 - 0.3e1 * t557 * t147 - 0.3e1 * t358 * t371 + 0.6e1 * t363 * t572 + 0.6e1 * t560 * t365 - 0.6e1 * t375 * t569 - 0.3e1 * t375 * t587 - 0.3e1 * t565 * t378 + t555 * t52 + 0.6e1 * t577 * t578 - 0.2e1 * t592 * t595;
  t599 = t598 * t55;
  t600 = t599 * t58;
  t601 = t348 * t37;
  t602 = t601 * t41;
  t603 = 0.6e1 * t602;
  t604 = t349 * t132;
  t605 = 0.6e1 * t604;
  t606 = t380 * t152;
  t607 = t606 * t58;
  t608 = 0.12e2 * t607;
  t609 = t381 * t157;
  t610 = 0.12e2 * t609;
  t614 = 0.3590361462302034071e-1 * t280 + 0.14644132792782855256e-1 * t58 + 0.21568810534254859484e-3 * t486;
  t616 = t323 * t116;
  t619 = t113 * t329;
  t624 = t113 * t342;
  t627 = t331 * t121;
  t628 = t627 * t122;
  t631 = t123 * t338;
  t635 = 0.1e1 / t341 / t31;
  t636 = t27 * t635;
  t637 = t627 * t345;
  t643 = -0.43721166540053938762e0 * t280 - 0.1276677928125719993e0 * t58 - 0.18382874546586033942e-2 * t486;
  t644 = t643 * t122;
  t647 = t338 * t345 * t121;
  t651 = 0.1e1 / t341 / t115;
  t652 = t27 * t651;
  t654 = 0.1e1 / t344 / t33;
  t655 = t627 * t654;
  t658 = -t117 * t644 - 0.3e1 * t616 * t123 - 0.3e1 * t325 * t339 + 0.6e1 * t330 * t631 + 0.6e1 * t619 * t332 + t614 * t34 - 0.6e1 * t343 * t628 - 0.3e1 * t343 * t647 - 0.3e1 * t624 * t346 + 0.6e1 * t636 * t637 - 0.2e1 * t652 * t655;
  t659 = t658 * t38;
  t660 = t659 * t41;
  t661 = t292 * t132;
  t662 = 0.24e2 * t661;
  t663 = t126 * t58;
  t664 = 0.18e2 * t663;
  t665 = t128 * t58;
  t666 = 0.36e2 * t665;
  t667 = t39 * t157;
  t668 = 0.24e2 * t667;
  t669 = t149 * t38;
  t670 = t669 * t58;
  t671 = 0.36e2 * t670;
  t672 = t489 - t491 + t493 - t535 - t539 + t541 - t545 + t548 - 0.2e1 * t550 + t600 + t603 - t605 + t608 - t610 + t660 - t662 + t664 + t666 - t668 + t671;
  t673 = t302 * t157;
  t674 = 0.96e2 * t673;
  t675 = t150 * t260;
  t676 = 0.6e2 * t675;
  t677 = t54 * t37;
  t678 = t677 * t58;
  t679 = 0.24e2 * t678;
  t680 = t307 * t157;
  t681 = 0.144e3 * t680;
  t682 = t153 * t260;
  t683 = 0.24e3 * t682;
  t684 = t56 * t529;
  t685 = 0.12e3 * t684;
  t687 = 0.1e1 / t285 / t19;
  t688 = t10 * t687;
  t689 = t221 * t106;
  t690 = t689 * t289;
  t691 = t688 * t690;
  t692 = 0.6e1 * t691;
  t693 = t225 * t314;
  t694 = 0.42608961364562219292e0 * t693;
  t695 = t280 * t61;
  t696 = t695 * t161;
  t697 = 0.32179317759649481856e0 * t696;
  t698 = t63 * t263;
  t699 = t160 * t698;
  t701 = t386 * t97;
  t702 = t701 * t108;
  t703 = 0.3e1 * t702;
  t704 = t267 * t283;
  t705 = 0.3e1 * t704;
  t706 = t94 * t286;
  t707 = t706 * t290;
  t708 = 0.3e1 * t707;
  t710 = 0.1e1/POW_3_2(t14);
  t713 = t710 / t12 / M_PI;
  t722 = -0.10601827511841775327e1 * t280 - 0.96984375e-3 * t713 * t486 + 0.174571875e-1 * t273 * t58 + 0.58190625e-1 * t101 * t280 - 0.6492948720354198876e0 * t58 - 0.41178204683787410302e-1 * t486;
  t723 = t722 * t107;
  t724 = t98 * t723;
  t726 = 0.1e1 / t285 / t96;
  t727 = t10 * t726;
  t729 = 0.1e1 / t288 / t21;
  t730 = t689 * t729;
  t731 = t727 * t730;
  t732 = 0.2e1 * t731;
  t733 = t317 * t314;
  t734 = 0.32179317759649481856e0 * t733;
  t735 = t58 * t61;
  t736 = t735 * t161;
  t737 = 0.40504331260924324145e-1 * t736;
  t738 = t689 * t107;
  t739 = t287 * t738;
  t740 = 0.6e1 * t739;
  t741 = t132 * t61;
  t742 = t741 * t161;
  t743 = 0.21304480682281109646e0 * t742;
  t744 = t94 * t219;
  t745 = t744 * t222;
  t746 = 0.6e1 * t745;
  t747 = -t674 + t676 + t679 - t681 + t683 - t685 + t692 + t694 + t697 - 0.85217922729124438584e0 * t699 - t703 - t705 - t708 - t724 - t732 - t734 - t737 - t740 - t743 + t746;
  t750 = -t473 + t474 - t475 + t476 - 0.17043584545824887717e1 * t315 - t478 + t479 + t480 + t481 + t482 + t390 + t1 * (t672 + t747);
  tv3rho30 = t472 + t750;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t751 = 0.4e1 * t490;
  t752 = 0.2e1 * t492;
  t753 = t494 * t191;
  t756 = t231 * t37;
  t767 = my_piecewise3(t68, 0, -0.3e1 / 0.8e1 * t753 * t232 + 0.3e1 * t756 * t132 * t168 + 0.3e1 / 0.4e1 * t396 * t237 + 0.3e1 * t71 * t132 - 0.9e1 * t399 * t58);
  t769 = t509 * t196;
  t772 = t243 * t37;
  t783 = my_piecewise3(t76, 0, -0.3e1 / 0.8e1 * t769 * t244 - 0.3e1 * t772 * t132 * t173 + 0.3e1 / 0.4e1 * t405 * t247 - 0.3e1 * t77 * t132 + 0.9e1 * t408 * t58);
  t785 = 0.3e1 / 0.2e1 * t132;
  t786 = 0.63e2 / 0.16e2 * t501;
  t787 = 0.63e2 / 0.8e1 * t524;
  t788 = 0.15e2 / 0.8e1 * t526;
  t789 = t767 / 0.2e1 + t783 / 0.2e1 - t785 - t786 + t787 - t788 + t531;
  t791 = t64 * t65 * t789;
  t794 = t64 * t14 * t415;
  t795 = 0.4e1 / 0.3e1 * t794;
  t797 = t64 * t388 * t201;
  t801 = t489 + t751 - t752 - 0.4e1 / 0.3e1 * t791 - t795 + t797 / 0.3e1 - t539 + 0.2e1 / 0.3e1 * t541 - t545 + t548 - 0.2e1 / 0.3e1 * t550;
  t802 = 0.2e1 * t602;
  t803 = 0.4e1 * t607;
  t804 = 0.8e1 * t661;
  t805 = 0.12e2 * t665;
  t806 = 0.12e2 * t670;
  t807 = t600 + t802 - t605 + t803 - t610 + t660 - t804 + t664 + t805 - t668 - t806;
  t809 = 0.32e2 * t673;
  t810 = 0.48e2 * t680;
  t811 = 0.8e2 * t682;
  t812 = t225 * t421;
  t814 = t317 * t421;
  t816 = t63 * t415;
  t817 = t160 * t816;
  t818 = 0.56811948486082959056e0 * t817;
  t820 = -t809 + t676 - t679 + t810 + t811 - t685 + 0.14202987121520739764e0 * t812 - 0.10726439253216493952e0 * t814 - t818 + t692 + 0.28405974243041479528e0 * t693;
  t823 = t697 - 0.28405974243041479528e0 * t699 - t703 - t705 - t708 - t724 - t732 - 0.21452878506432987904e0 * t733 - t737 - t740 - t743 + t746;
  t827 = t1 * (t801 + t807 + t820 + t823) + t482 - t352 + t481 + t294 - t468 - t298 + t470 + t304 - t473 - t309 - t311 + t476;
  t829 = 0.8e1 / 0.3e1 * t417;
  t831 = t479 - t455 + t460 + t461 - t464 - t465 - t466 - 0.11362389697216591811e1 * t315 - t478 - t456 + t390 - t829 - 0.8e1 / 0.3e1 * t229 - t266;
  tv3rho31 = t827 + t831;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t832 = t494 * t431;
  t837 = t231 * t435;
  t842 = -0.2e1 * t132 - 0.6e1 * t501;
  t846 = my_piecewise3(t68, 0, -0.3e1 / 0.8e1 * t832 * t168 + 0.3e1 * t396 * t235 + 0.3e1 / 0.4e1 * t837 * t168 + 0.3e1 / 0.2e1 * t71 * t842);
  t848 = t509 * t441;
  t853 = t243 * t444;
  t856 = -t842;
  t860 = my_piecewise3(t76, 0, -0.3e1 / 0.8e1 * t848 * t173 - 0.3e1 * t405 * t235 + 0.3e1 / 0.4e1 * t853 * t173 + 0.3e1 / 0.2e1 * t77 * t856);
  t862 = t846 / 0.2e1 + t860 / 0.2e1 - t785 + t786 + t787 + t788 + t531;
  t864 = t64 * t65 * t862;
  t867 = t64 * t14 * t450;
  t871 = t489 + t751 - t752 - 0.4e1 / 0.3e1 * t864 - 0.2e1 / 0.3e1 * t867 - t795 + 0.2e1 / 0.3e1 * t797 - t539 + t541 / 0.3e1 - t545 + t548;
  t872 = t600 - t802 - t605 - t803 - t610 + t660 + t804 + t664 - t805 - t668 - t806;
  t874 = t63 * t450;
  t875 = t160 * t874;
  t879 = t809 + t676 + t679 + t810 - t811 - t685 - 0.28405974243041479528e0 * t875 + 0.28405974243041479528e0 * t812 - 0.21452878506432987904e0 * t814 - t818 + t692;
  t882 = 0.14202987121520739764e0 * t693 + t697 - t703 - t705 - t708 - t724 - t732 - 0.10726439253216493952e0 * t733 - t737 - t740 - t743 + t746;
  t886 = t1 * (t871 + t872 + t879 + t882) + t482 - t352 + t481 - t294 - t468 + t298 + t470 - t304 - t473 - t309 + t311 + t476;
  t889 = t479 - 0.11362389697216591811e1 * t422 + t460 + t461 - t464 - t465 - t466 - t316 - t478 - 0.8e1 / 0.3e1 * t425 - t453 + t390 - t829 - t230;
  tv3rho32 = t886 + t889;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t891 = t460 + t461 - 0.4e1 * t452 - t464 - t465 - t466 - t467 - t468 + t469 + t470 - t471 - t473;
  t894 = t431 * t191;
  t900 = -0.6e1 * t132 - 0.6e1 * t501;
  t904 = my_piecewise3(t68, 0, -0.3e1 / 0.8e1 * t494 * t894 + 0.9e1 / 0.4e1 * t396 * t435 + 0.3e1 / 0.2e1 * t71 * t900);
  t906 = t441 * t196;
  t911 = -t900;
  t915 = my_piecewise3(t76, 0, -0.3e1 / 0.8e1 * t509 * t906 + 0.9e1 / 0.4e1 * t405 * t444 + 0.3e1 / 0.2e1 * t77 * t911);
  t917 = t904 / 0.2e1 + t915 / 0.2e1 + t522 + t523 + t525 + t527 + t531;
  t919 = t64 * t65 * t917;
  t920 = 0.4e1 / 0.3e1 * t919;
  t922 = t489 - t491 + t493 - t920 - 0.2e1 * t867 + t797 - t539 - t545 + t548 + t600 - t603 - t605 - t608 - t610 + t660 + t662 + t664 - t666 - t668 + t671;
  t924 = 0.42608961364562219292e0 * t812;
  t925 = 0.32179317759649481856e0 * t814;
  t926 = t674 + t676 - t679 - t681 - t683 - t685 - 0.85217922729124438584e0 * t875 + t924 - t925 + t692 + t697 - t703 - t705 - t708 - t724 - t732 - t737 - t740 - t743 + t746;
  t929 = t474 + t475 + t476 - t478 - 0.17043584545824887717e1 * t422 + t479 + t480 + t481 + t482 + t390 - 0.4e1 * t425 + t1 * (t922 + t926);
  tv3rho33 = t891 + t929;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t5, t8, t10, t12, t13;
  double t14, t15, t19, t21, t22, t23, t27, t31;
  double t33, t34, t36, t37, t38, t39, t40, t41;
  double t42, t46, t49, t51, t52, t54, t55, t56;
  double t57, t58, t59, t61, t63, t64, t65, t66;
  double t67, t68, t69, t70, t71, t72, t73, t75;
  double t76, t77, t78, t79, t85, t88, tzk0;

  double t92, t94, t95, t96, t97, t98, t100, t101;
  double t106, t107, t108, t109, t113, t115, t116, t117;
  double t121, t122, t123, t125, t126, t127, t128, t129;
  double t130, t131, t132, t133, t134, t138, t140, t141;
  double t142, t145, t146, t147, t149, t150, t151, t152;
  double t153, t154, t155, t156, t157, t158, t159, t160;
  double t161, t162, t163, t165, t166, t167, t168, t171;
  double t173, t176, t178, t180, t182, t184, t185, t187;
  double t188, t189, tvrho0, t191, t194, t196, t199, t201;
  double t203, t204, t205, tvrho1;

  double t207, t208, t209, t210, t211, t212, t213, t214;
  double t215, t216, t218, t219, t220, t221, t222, t223;
  double t224, t225, t226, t227, t229, t230, t231, t232;
  double t235, t237, t241, t243, t244, t247, t251, t253;
  double t254, t255, t256, t258, t260, t262, t263, t265;
  double t266, t267, t268, t269, t271, t273, t280, t282;
  double t283, t284, t285, t286, t287, t288, t289, t290;
  double t291, t292, t293, t294, t295, t296, t297, t298;
  double t299, t300, t301, t302, t303, t304, t305, t306;
  double t307, t308, t309, t310, t311, t312, t313, t314;
  double t315, t316, t317, t318, t319, t323, t325, t328;
  double t329, t330, t331, t332, t338, t339, t341, t342;
  double t343, t344, t345, t346, t348, t349, t350, t351;
  double t352, t356, t358, t361, t362, t363, t364, t365;
  double t370, t371, t373, t374, t375, t376, t377, t378;
  double t380, t381, t382, t386, t387, t388, t390, t391;
  double t392, tv2rho20, t396, t399, t403, t405, t408, t412;
  double t415, t417, t421, t422, t425, t427, tv2rho21, t431;
  double t435, t439, t441, t444, t448, t450, t452, t453;
  double t454, t455, t456, t457, tv2rho22;

  double t460, t461, t464, t465, t466, t467, t468, t469;
  double t470, t471, t472, t473, t474, t475, t476, t478;
  double t479, t480, t481, t482, t486, t488, t489, t490;
  double t491, t492, t493, t494, t495, t498, t501, t503;
  double t507, t509, t510, t513, t516, t520, t522, t523;
  double t524, t525, t526, t527, t529, t531, t532, t534;
  double t535, t537, t538, t539, t541, t542, t544, t545;
  double t546, t547, t548, t550, t555, t557, t560, t565;
  double t568, t569, t572, t576, t577, t578, t583, t584;
  double t587, t591, t592, t594, t595, t598, t599, t600;
  double t601, t602, t603, t604, t605, t606, t607, t608;
  double t609, t610, t614, t616, t619, t624, t627, t628;
  double t631, t635, t636, t637, t643, t644, t647, t651;
  double t652, t654, t655, t658, t659, t660, t661, t662;
  double t663, t664, t665, t666, t667, t668, t669, t670;
  double t671, t672, t673, t674, t675, t676, t677, t678;
  double t679, t680, t681, t682, t683, t684, t685, t687;
  double t688, t689, t690, t691, t692, t693, t694, t695;
  double t696, t697, t698, t699, t701, t702, t703, t704;
  double t705, t706, t707, t708, t710, t713, t722, t723;
  double t724, t726, t727, t729, t730, t731, t732, t733;
  double t734, t735, t736, t737, t738, t739, t740, t741;
  double t742, t743, t744, t745, t746, t747, t750, tv3rho30;
  double t751, t752, t753, t756, t767, t769, t772, t783;
  double t785, t786, t787, t788, t789, t791, t794, t795;
  double t797, t801, t802, t803, t804, t805, t806, t807;
  double t809, t810, t811, t812, t814, t816, t817, t818;
  double t820, t823, t827, t829, t831, tv3rho31, t832, t837;
  double t842, t846, t848, t853, t856, t860, t862, t864;
  double t867, t871, t872, t874, t875, t879, t882, t886;
  double t889, tv3rho32, t891, t894, t900, t904, t906, t911;
  double t915, t917, t919, t920, t922, t924, t925, t926;
  double t929, tv3rho33;

  double t930, t931, t933, t934, t935, t936, t937, t938;
  double t939, t940, t941, t943, t953, t960, t977, t1009;
  double t1014, t1017, t1027, t1030, t1035, t1036, t1037, t1039;
  double t1040, t1041, t1042, t1043, t1044, t1047, t1050, t1051;
  double t1055, t1056, t1057, t1060, t1066, t1067, t1071, t1073;
  double t1075, t1079, t1081, t1084, t1086, t1089, t1091, t1092;
  double t1107, t1108, t1111, t1115, t1117, t1120, t1121, t1123;
  double t1127, t1128, t1132, t1135, t1137, t1139, t1140, t1142;
  double t1152, t1159, t1176, t1212, t1215, t1225, t1228, t1230;
  double t1231, t1233, t1234, t1235, t1236, t1237, t1238, t1240;
  double t1242, t1243, t1244, t1245, t1247, t1248, t1249, t1250;
  double t1252, t1253, t1254, t1256, t1258, t1263, t1266, t1268;
  double t1271, t1274, t1276, t1279, t1283, t1287, t1288, t1290;
  double t1291, t1297, t1302, t1304, t1308, t1310, t1312, t1313;
  double t1319, t1328, t1330, t1331, t1332, t1333, t1334, t1335;
  double t1337, t1343, t1345, t1346, t1350, t1351, t1352, t1354;
  double t1356, t1357, t1359, t1360, t1361, t1362, t1363, t1364;
  double t1365, t1366, t1367, t1368, t1369, t1370, t1371, t1372;
  double t1373, t1374, t1375, t1376, t1377, t1379, t1382, t1383;
  double t1384, t1385, t1386, t1388, t1389, t1390, t1391, t1392;
  double tv4rho40, t1395, t1397, t1400, t1426, t1428, t1454, t1456;
  double t1458, t1459, t1460, t1461, t1466, t1467, t1468, t1470;
  double t1472, t1473, t1474, t1476, t1478, t1480, t1481, t1482;
  double t1487, t1491, t1492, t1493, t1494, t1495, t1496, t1497;
  double t1498, t1501, t1506, t1510, t1511, t1512, t1513, t1514;
  double t1516, t1517, t1518, t1519, t1521, t1524, tv4rho41, t1537;
  double t1573, t1600, t1609, t1612, t1620, t1622, t1632, t1637;
  double t1641, t1643, t1645, t1649, tv4rho42, t1655, t1660, t1662;
  double t1682, t1686, t1708, t1718, t1723, t1726, t1731, t1733;
  double t1737, tv4rho43, t1739, t1744, t1750, t1754, t1756, t1761;
  double t1770, t1779, t1784, t1786, t1789, t1796, t1801, tv4rho44;


  t1 = rho[0] + rho[1];
  t2 = sqrt(t1);
  t3 = 0.1e1 / t2;
  t5 = 0.1e1 / t1;
  t8 = 0.1e1 / t2 / t1;
  t10 = 0.48697234038507617049e-1 * t3 + 0.18219548589342283974e-1 * t5 + 0.6039470020288820178e-3 * t8;
  t12 = sqrt(M_PI);
  t13 = 0.1e1 / t12;
  t14 = t13 * t3;
  t15 = POW_3_2(t14);
  t19 = 0.56543080063156135078e0 * t3 - 0.2069e-1 * t15 + 0.1082158120059033146e0 * t5 + 0.31373870235266598327e-2 * t8;
  t21 = 0.1e1 + 0.1e1 / t19;
  t22 = log(t21);
  t23 = t10 * t22;
  t27 = -0.19148594465610848379e-1 * t3 - 0.24406887987971425426e-2 * t5 - 0.16433379454670369131e-4 * t8;
  t31 = 0.2331795548802876734e0 * t3 + 0.21277965468761999883e-1 * t5 + 0.14005999654541740146e-3 * t8;
  t33 = 0.1e1 + 0.1e1 / t31;
  t34 = log(t33);
  t36 = 0.117331e0 + t27 * t34;
  t37 = rho[0] - rho[1];
  t38 = t37 * t37;
  t39 = t36 * t38;
  t40 = t1 * t1;
  t41 = 0.1e1 / t40;
  t42 = t39 * t41;
  t46 = -0.20927484222536923952e-1 * t3 + 0.52081226957619462095e-2 * t5 - 0.48916627893863681951e-2 * t8;
  t49 = 0.80357578803665282726e0 * t3 + 0.20887760215665910274e0 * t8;
  t51 = 0.1e1 + 0.1e1 / t49;
  t52 = log(t51);
  t54 = 0.234188e-1 + t46 * t52;
  t55 = t38 * t38;
  t56 = t54 * t55;
  t57 = t40 * t40;
  t58 = 0.1e1 / t57;
  t59 = t56 * t58;
  t61 = exp(-0.75522417653702656571e0 * t3);
  t63 = M_SQRT2;
  t64 = (t61 - 0.1e1) * t63;
  t65 = t13 * t2;
  t66 = t37 * t5;
  t67 = 0.1e1 + t66;
  t68 = t67 <= p->zeta_threshold;
  t69 = sqrt(p->zeta_threshold);
  t70 = t69 * p->zeta_threshold;
  t71 = sqrt(t67);
  t72 = t71 * t67;
  t73 = my_piecewise3(t68, t70, t72);
  t75 = 0.1e1 - t66;
  t76 = t75 <= p->zeta_threshold;
  t77 = sqrt(t75);
  t78 = t77 * t75;
  t79 = my_piecewise3(t76, t70, t78);
  t85 = t73 / 0.2e1 + t79 / 0.2e1 - 0.1e1 - 0.3e1 / 0.8e1 * t38 * t41 - 0.3e1 / 0.128e3 * t55 * t58;
  t88 = 0.4e1 / 0.3e1 * t64 * t65 * t85;
  tzk0 = -0.1925e0 + t23 + t42 + t59 - t88;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t92 = 0.1e1 / t2 / t40;
  t94 = -0.24348617019253808524e-1 * t8 - 0.18219548589342283974e-1 * t41 - 0.9059205030433230267e-3 * t92;
  t95 = t94 * t22;
  t96 = t19 * t19;
  t97 = 0.1e1 / t96;
  t98 = t10 * t97;
  t100 = sqrt(t14);
  t101 = t100 * t13;
  t106 = -0.28271540031578067539e0 * t8 + 0.155175e-1 * t101 * t8 - 0.1082158120059033146e0 * t41 - 0.4706080535289989749e-2 * t92;
  t107 = 0.1e1 / t21;
  t108 = t106 * t107;
  t109 = t98 * t108;
  t113 = 0.95742972328054241895e-2 * t8 + 0.24406887987971425426e-2 * t41 + 0.24650069182005553696e-4 * t92;
  t115 = t31 * t31;
  t116 = 0.1e1 / t115;
  t117 = t27 * t116;
  t121 = -0.1165897774401438367e0 * t8 - 0.21277965468761999883e-1 * t41 - 0.21008999481812610219e-3 * t92;
  t122 = 0.1e1 / t33;
  t123 = t121 * t122;
  t125 = t113 * t34 - t117 * t123;
  t126 = t125 * t38;
  t127 = t126 * t41;
  t128 = t36 * t37;
  t129 = t128 * t41;
  t130 = 0.2e1 * t129;
  t131 = t40 * t1;
  t132 = 0.1e1 / t131;
  t133 = t39 * t132;
  t134 = 0.2e1 * t133;
  t138 = 0.10463742111268461976e-1 * t8 - 0.52081226957619462095e-2 * t41 + 0.73374941840795522926e-2 * t92;
  t140 = t49 * t49;
  t141 = 0.1e1 / t140;
  t142 = t46 * t141;
  t145 = -0.40178789401832641363e0 * t8 - 0.31331640323498865411e0 * t92;
  t146 = 0.1e1 / t51;
  t147 = t145 * t146;
  t149 = t138 * t52 - t142 * t147;
  t150 = t149 * t55;
  t151 = t150 * t58;
  t152 = t38 * t37;
  t153 = t54 * t152;
  t154 = t153 * t58;
  t155 = 0.4e1 * t154;
  t156 = t57 * t1;
  t157 = 0.1e1 / t156;
  t158 = t56 * t157;
  t159 = 0.4e1 * t158;
  t160 = t5 * t61;
  t161 = t63 * t85;
  t162 = t160 * t161;
  t163 = 0.28405974243041479528e0 * t162;
  t165 = t64 * t14 * t85;
  t166 = 0.2e1 / 0.3e1 * t165;
  t167 = t37 * t41;
  t168 = t5 - t167;
  t171 = my_piecewise3(t68, 0, 0.3e1 / 0.2e1 * t71 * t168);
  t173 = -t168;
  t176 = my_piecewise3(t76, 0, 0.3e1 / 0.2e1 * t77 * t173);
  t178 = 0.3e1 / 0.4e1 * t167;
  t180 = 0.3e1 / 0.4e1 * t38 * t132;
  t182 = 0.3e1 / 0.32e2 * t152 * t58;
  t184 = 0.3e1 / 0.32e2 * t55 * t157;
  t185 = t171 / 0.2e1 + t176 / 0.2e1 - t178 + t180 - t182 + t184;
  t187 = t64 * t65 * t185;
  t188 = 0.4e1 / 0.3e1 * t187;
  t189 = t95 - t109 + t127 + t130 - t134 + t151 + t155 - t159 - t163 - t166 - t188;
  tvrho0 = -0.1925e0 + t23 + t42 + t59 - t88 + t1 * t189;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t191 = -t5 - t167;
  t194 = my_piecewise3(t68, 0, 0.3e1 / 0.2e1 * t71 * t191);
  t196 = -t191;
  t199 = my_piecewise3(t76, 0, 0.3e1 / 0.2e1 * t77 * t196);
  t201 = t194 / 0.2e1 + t199 / 0.2e1 + t178 + t180 + t182 + t184;
  t203 = t64 * t65 * t201;
  t204 = 0.4e1 / 0.3e1 * t203;
  t205 = t95 - t109 + t127 - t130 - t134 + t151 - t155 - t159 - t163 - t166 - t204;
  tvrho1 = -0.1925e0 + t23 + t42 + t59 - t88 + t1 * t205;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t207 = 0.2e1 * t95;
  t208 = 0.2e1 * t109;
  t209 = 0.2e1 * t127;
  t210 = 0.4e1 * t129;
  t211 = 0.4e1 * t133;
  t212 = 0.2e1 * t151;
  t213 = 0.8e1 * t154;
  t214 = 0.8e1 * t158;
  t215 = 0.56811948486082959056e0 * t162;
  t216 = 0.4e1 / 0.3e1 * t165;
  t218 = t96 * t19;
  t219 = 0.1e1 / t218;
  t220 = t10 * t219;
  t221 = t106 * t106;
  t222 = t221 * t107;
  t223 = t220 * t222;
  t224 = 0.2e1 * t223;
  t225 = t41 * t61;
  t226 = t225 * t161;
  t227 = 0.14202987121520739764e0 * t226;
  t229 = t64 * t14 * t185;
  t230 = 0.4e1 / 0.3e1 * t229;
  t231 = 0.1e1 / t71;
  t232 = t168 * t168;
  t235 = t37 * t132;
  t237 = -0.2e1 * t41 + 0.2e1 * t235;
  t241 = my_piecewise3(t68, 0, 0.3e1 / 0.4e1 * t231 * t232 + 0.3e1 / 0.2e1 * t71 * t237);
  t243 = 0.1e1 / t77;
  t244 = t173 * t173;
  t247 = -t237;
  t251 = my_piecewise3(t76, 0, 0.3e1 / 0.4e1 * t243 * t244 + 0.3e1 / 0.2e1 * t77 * t247);
  t253 = 0.3e1 / 0.4e1 * t41;
  t254 = 0.3e1 * t235;
  t255 = t38 * t58;
  t256 = 0.81e2 / 0.32e2 * t255;
  t258 = 0.3e1 / 0.4e1 * t152 * t157;
  t260 = 0.1e1 / t57 / t40;
  t262 = 0.15e2 / 0.32e2 * t55 * t260;
  t263 = t241 / 0.2e1 + t251 / 0.2e1 - t253 + t254 - t256 + t258 - t262;
  t265 = t64 * t65 * t263;
  t266 = 0.4e1 / 0.3e1 * t265;
  t267 = t94 * t97;
  t268 = t267 * t108;
  t269 = 0.2e1 * t268;
  t271 = 0.1e1/sqrt(t14);
  t273 = t271 / M_PI;
  t280 = 0.1e1 / t2 / t131;
  t282 = 0.42407310047367101308e0 * t92 - 0.3879375e-2 * t273 * t132 - 0.2327625e-1 * t101 * t92 + 0.2164316240118066292e0 * t132 + 0.11765201338224974372e-1 * t280;
  t283 = t282 * t107;
  t284 = t98 * t283;
  t285 = t96 * t96;
  t286 = 0.1e1 / t285;
  t287 = t10 * t286;
  t288 = t21 * t21;
  t289 = 0.1e1 / t288;
  t290 = t221 * t289;
  t291 = t287 * t290;
  t292 = t125 * t37;
  t293 = t292 * t41;
  t294 = 0.4e1 * t293;
  t295 = t126 * t132;
  t296 = 0.4e1 * t295;
  t297 = t128 * t132;
  t298 = 0.8e1 * t297;
  t299 = t39 * t58;
  t300 = 0.6e1 * t299;
  t301 = t224 + t227 - t230 - t266 - t269 - t284 - t291 + t294 - t296 - t298 + t300;
  t302 = t149 * t152;
  t303 = t302 * t58;
  t304 = 0.8e1 * t303;
  t305 = t150 * t157;
  t306 = 0.8e1 * t305;
  t307 = t54 * t38;
  t308 = t307 * t58;
  t309 = 0.12e2 * t308;
  t310 = t153 * t157;
  t311 = 0.32e2 * t310;
  t312 = t56 * t260;
  t313 = 0.2e2 * t312;
  t314 = t63 * t185;
  t315 = t160 * t314;
  t316 = 0.56811948486082959056e0 * t315;
  t317 = t92 * t61;
  t318 = t317 * t161;
  t319 = 0.10726439253216493952e0 * t318;
  t323 = -0.14361445849208136284e-1 * t92 - 0.48813775975942850852e-2 * t132 - 0.6162517295501388424e-4 * t280;
  t325 = t113 * t116;
  t328 = t115 * t31;
  t329 = 0.1e1 / t328;
  t330 = t27 * t329;
  t331 = t121 * t121;
  t332 = t331 * t122;
  t338 = 0.17488466616021575505e0 * t92 + 0.42555930937523999766e-1 * t132 + 0.52522498704531525548e-3 * t280;
  t339 = t338 * t122;
  t341 = t115 * t115;
  t342 = 0.1e1 / t341;
  t343 = t27 * t342;
  t344 = t33 * t33;
  t345 = 0.1e1 / t344;
  t346 = t331 * t345;
  t348 = -t117 * t339 - 0.2e1 * t325 * t123 + t323 * t34 + 0.2e1 * t330 * t332 - t343 * t346;
  t349 = t348 * t38;
  t350 = t349 * t41;
  t351 = t36 * t41;
  t352 = 0.2e1 * t351;
  t356 = -0.15695613166902692964e-1 * t92 + 0.10416245391523892419e-1 * t132 - 0.18343735460198880732e-1 * t280;
  t358 = t138 * t141;
  t361 = t140 * t49;
  t362 = 0.1e1 / t361;
  t363 = t46 * t362;
  t364 = t145 * t145;
  t365 = t364 * t146;
  t370 = 0.60268184102748962044e0 * t92 + 0.78329100808747163528e0 * t280;
  t371 = t370 * t146;
  t373 = t140 * t140;
  t374 = 0.1e1 / t373;
  t375 = t46 * t374;
  t376 = t51 * t51;
  t377 = 0.1e1 / t376;
  t378 = t364 * t377;
  t380 = -t142 * t371 - 0.2e1 * t358 * t147 + t356 * t52 + 0.2e1 * t363 * t365 - t375 * t378;
  t381 = t380 * t55;
  t382 = t381 * t58;
  t386 = 0.36522925528880712786e-1 * t92 + 0.36439097178684567948e-1 * t132 + 0.22648012576083075668e-2 * t280;
  t387 = t386 * t22;
  t388 = t13 * t8;
  t390 = t64 * t388 * t85;
  t391 = t390 / 0.3e1;
  t392 = t304 - t306 + t309 - t311 + t313 - t316 - t319 + t350 + t352 + t382 + t387 + t391;
  tv2rho20 = t207 - t208 + t209 + t210 - t211 + t212 + t213 - t214 - t215 - t216 - 0.8e1 / 0.3e1 * t187 + t1 * (t301 + t392);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t396 = t231 * t191;
  t399 = t71 * t37;
  t403 = my_piecewise3(t68, 0, 0.3e1 / 0.4e1 * t396 * t168 + 0.3e1 * t399 * t132);
  t405 = t243 * t196;
  t408 = t77 * t37;
  t412 = my_piecewise3(t76, 0, 0.3e1 / 0.4e1 * t405 * t173 - 0.3e1 * t408 * t132);
  t415 = t403 / 0.2e1 + t412 / 0.2e1 + t253 - 0.63e2 / 0.32e2 * t255 - t262;
  t417 = t64 * t65 * t415;
  t421 = t63 * t201;
  t422 = t160 * t421;
  t425 = t64 * t14 * t201;
  t427 = -t309 + t313 - 0.28405974243041479528e0 * t315 - t319 - 0.28405974243041479528e0 * t422 + t350 - t352 + t382 + t387 + t391 - 0.2e1 / 0.3e1 * t425;
  tv2rho21 = t207 - t208 + t209 - t211 + t212 - t214 - t215 - t216 - t188 - t204 + t1 * (t224 + t227 - 0.2e1 / 0.3e1 * t229 - 0.4e1 / 0.3e1 * t417 - t269 - t284 - t291 - t296 + t300 - t306 + t427);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t431 = t191 * t191;
  t435 = 0.2e1 * t41 + 0.2e1 * t235;
  t439 = my_piecewise3(t68, 0, 0.3e1 / 0.4e1 * t231 * t431 + 0.3e1 / 0.2e1 * t71 * t435);
  t441 = t196 * t196;
  t444 = -t435;
  t448 = my_piecewise3(t76, 0, 0.3e1 / 0.4e1 * t243 * t441 + 0.3e1 / 0.2e1 * t77 * t444);
  t450 = t439 / 0.2e1 + t448 / 0.2e1 - t253 - t254 - t256 - t258 - t262;
  t452 = t64 * t65 * t450;
  t453 = 0.4e1 / 0.3e1 * t452;
  t454 = t224 + t227 - t453 - t269 - t284 - t291 - t294 - t296 + t298 + t300 - t304;
  t455 = 0.56811948486082959056e0 * t422;
  t456 = 0.4e1 / 0.3e1 * t425;
  t457 = -t306 + t309 + t311 + t313 - t319 - t455 + t350 + t352 + t382 + t387 + t391 - t456;
  tv2rho22 = t207 - t208 + t209 - t210 - t211 + t212 - t213 - t214 - t215 - t216 - 0.8e1 / 0.3e1 * t203 + t1 * (t454 + t457);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t460 = 0.6e1 * t223;
  t461 = 0.42608961364562219292e0 * t226;
  t464 = 0.6e1 * t268;
  t465 = 0.3e1 * t284;
  t466 = 0.3e1 * t291;
  t467 = 0.12e2 * t293;
  t468 = 0.12e2 * t295;
  t469 = 0.24e2 * t297;
  t470 = 0.18e2 * t299;
  t471 = 0.24e2 * t303;
  t472 = t460 + t461 - 0.4e1 * t229 - 0.4e1 * t265 - t464 - t465 - t466 + t467 - t468 - t469 + t470 + t471;
  t473 = 0.24e2 * t305;
  t474 = 0.36e2 * t308;
  t475 = 0.96e2 * t310;
  t476 = 0.6e2 * t312;
  t478 = 0.32179317759649481856e0 * t318;
  t479 = 0.3e1 * t350;
  t480 = 0.6e1 * t351;
  t481 = 0.3e1 * t382;
  t482 = 0.3e1 * t387;
  t486 = 0.1e1 / t2 / t57;
  t488 = -0.91307313822201781965e-1 * t280 - 0.10931729153605370384e0 * t58 - 0.79268044016290764838e-2 * t486;
  t489 = t488 * t22;
  t490 = t36 * t132;
  t491 = 0.12e2 * t490;
  t492 = t125 * t41;
  t493 = 0.6e1 * t492;
  t494 = 0.1e1 / t72;
  t495 = t232 * t168;
  t498 = t231 * t168;
  t501 = t37 * t58;
  t503 = 0.6e1 * t132 - 0.6e1 * t501;
  t507 = my_piecewise3(t68, 0, -0.3e1 / 0.8e1 * t494 * t495 + 0.9e1 / 0.4e1 * t498 * t237 + 0.3e1 / 0.2e1 * t71 * t503);
  t509 = 0.1e1 / t78;
  t510 = t244 * t173;
  t513 = t243 * t173;
  t516 = -t503;
  t520 = my_piecewise3(t76, 0, -0.3e1 / 0.8e1 * t509 * t510 + 0.9e1 / 0.4e1 * t513 * t247 + 0.3e1 / 0.2e1 * t77 * t516);
  t522 = 0.9e1 / 0.2e1 * t132;
  t523 = 0.225e3 / 0.16e2 * t501;
  t524 = t38 * t157;
  t525 = 0.99e2 / 0.8e1 * t524;
  t526 = t152 * t260;
  t527 = 0.45e2 / 0.8e1 * t526;
  t529 = 0.1e1 / t57 / t131;
  t531 = 0.45e2 / 0.16e2 * t55 * t529;
  t532 = t507 / 0.2e1 + t520 / 0.2e1 + t522 - t523 + t525 - t527 + t531;
  t534 = t64 * t65 * t532;
  t535 = 0.4e1 / 0.3e1 * t534;
  t537 = t282 * t289 * t106;
  t538 = t287 * t537;
  t539 = 0.3e1 * t538;
  t541 = t64 * t388 * t185;
  t542 = t13 * t92;
  t544 = t64 * t542 * t85;
  t545 = t544 / 0.2e1;
  t546 = t108 * t282;
  t547 = t220 * t546;
  t548 = 0.6e1 * t547;
  t550 = t64 * t14 * t263;
  t555 = 0.3923903291725673241e-1 * t280 - 0.31248736174571677257e-1 * t58 + 0.64203074110696082562e-1 * t486;
  t557 = t356 * t141;
  t560 = t138 * t362;
  t565 = t138 * t374;
  t568 = t364 * t145;
  t569 = t568 * t146;
  t572 = t147 * t370;
  t576 = 0.1e1 / t373 / t49;
  t577 = t46 * t576;
  t578 = t568 * t377;
  t583 = -0.15067046025687240511e1 * t280 - 0.27415185283061507235e1 * t486;
  t584 = t583 * t146;
  t587 = t370 * t377 * t145;
  t591 = 0.1e1 / t373 / t140;
  t592 = t46 * t591;
  t594 = 0.1e1 / t376 / t51;
  t595 = t568 * t594;
  t598 = -t142 * t584 - 0.3e1 * t557 * t147 - 0.3e1 * t358 * t371 + 0.6e1 * t363 * t572 + 0.6e1 * t560 * t365 - 0.6e1 * t375 * t569 - 0.3e1 * t375 * t587 - 0.3e1 * t565 * t378 + t555 * t52 + 0.6e1 * t577 * t578 - 0.2e1 * t592 * t595;
  t599 = t598 * t55;
  t600 = t599 * t58;
  t601 = t348 * t37;
  t602 = t601 * t41;
  t603 = 0.6e1 * t602;
  t604 = t349 * t132;
  t605 = 0.6e1 * t604;
  t606 = t380 * t152;
  t607 = t606 * t58;
  t608 = 0.12e2 * t607;
  t609 = t381 * t157;
  t610 = 0.12e2 * t609;
  t614 = 0.3590361462302034071e-1 * t280 + 0.14644132792782855256e-1 * t58 + 0.21568810534254859484e-3 * t486;
  t616 = t323 * t116;
  t619 = t113 * t329;
  t624 = t113 * t342;
  t627 = t331 * t121;
  t628 = t627 * t122;
  t631 = t123 * t338;
  t635 = 0.1e1 / t341 / t31;
  t636 = t27 * t635;
  t637 = t627 * t345;
  t643 = -0.43721166540053938762e0 * t280 - 0.1276677928125719993e0 * t58 - 0.18382874546586033942e-2 * t486;
  t644 = t643 * t122;
  t647 = t338 * t345 * t121;
  t651 = 0.1e1 / t341 / t115;
  t652 = t27 * t651;
  t654 = 0.1e1 / t344 / t33;
  t655 = t627 * t654;
  t658 = -t117 * t644 - 0.3e1 * t616 * t123 - 0.3e1 * t325 * t339 + 0.6e1 * t330 * t631 + 0.6e1 * t619 * t332 + t614 * t34 - 0.6e1 * t343 * t628 - 0.3e1 * t343 * t647 - 0.3e1 * t624 * t346 + 0.6e1 * t636 * t637 - 0.2e1 * t652 * t655;
  t659 = t658 * t38;
  t660 = t659 * t41;
  t661 = t292 * t132;
  t662 = 0.24e2 * t661;
  t663 = t126 * t58;
  t664 = 0.18e2 * t663;
  t665 = t128 * t58;
  t666 = 0.36e2 * t665;
  t667 = t39 * t157;
  t668 = 0.24e2 * t667;
  t669 = t149 * t38;
  t670 = t669 * t58;
  t671 = 0.36e2 * t670;
  t672 = t489 - t491 + t493 - t535 - t539 + t541 - t545 + t548 - 0.2e1 * t550 + t600 + t603 - t605 + t608 - t610 + t660 - t662 + t664 + t666 - t668 + t671;
  t673 = t302 * t157;
  t674 = 0.96e2 * t673;
  t675 = t150 * t260;
  t676 = 0.6e2 * t675;
  t677 = t54 * t37;
  t678 = t677 * t58;
  t679 = 0.24e2 * t678;
  t680 = t307 * t157;
  t681 = 0.144e3 * t680;
  t682 = t153 * t260;
  t683 = 0.24e3 * t682;
  t684 = t56 * t529;
  t685 = 0.12e3 * t684;
  t687 = 0.1e1 / t285 / t19;
  t688 = t10 * t687;
  t689 = t221 * t106;
  t690 = t689 * t289;
  t691 = t688 * t690;
  t692 = 0.6e1 * t691;
  t693 = t225 * t314;
  t694 = 0.42608961364562219292e0 * t693;
  t695 = t280 * t61;
  t696 = t695 * t161;
  t697 = 0.32179317759649481856e0 * t696;
  t698 = t63 * t263;
  t699 = t160 * t698;
  t701 = t386 * t97;
  t702 = t701 * t108;
  t703 = 0.3e1 * t702;
  t704 = t267 * t283;
  t705 = 0.3e1 * t704;
  t706 = t94 * t286;
  t707 = t706 * t290;
  t708 = 0.3e1 * t707;
  t710 = 0.1e1/POW_3_2(t14);
  t713 = t710 / t12 / M_PI;
  t722 = -0.10601827511841775327e1 * t280 - 0.96984375e-3 * t713 * t486 + 0.174571875e-1 * t273 * t58 + 0.58190625e-1 * t101 * t280 - 0.6492948720354198876e0 * t58 - 0.41178204683787410302e-1 * t486;
  t723 = t722 * t107;
  t724 = t98 * t723;
  t726 = 0.1e1 / t285 / t96;
  t727 = t10 * t726;
  t729 = 0.1e1 / t288 / t21;
  t730 = t689 * t729;
  t731 = t727 * t730;
  t732 = 0.2e1 * t731;
  t733 = t317 * t314;
  t734 = 0.32179317759649481856e0 * t733;
  t735 = t58 * t61;
  t736 = t735 * t161;
  t737 = 0.40504331260924324145e-1 * t736;
  t738 = t689 * t107;
  t739 = t287 * t738;
  t740 = 0.6e1 * t739;
  t741 = t132 * t61;
  t742 = t741 * t161;
  t743 = 0.21304480682281109646e0 * t742;
  t744 = t94 * t219;
  t745 = t744 * t222;
  t746 = 0.6e1 * t745;
  t747 = -t674 + t676 + t679 - t681 + t683 - t685 + t692 + t694 + t697 - 0.85217922729124438584e0 * t699 - t703 - t705 - t708 - t724 - t732 - t734 - t737 - t740 - t743 + t746;
  t750 = -t473 + t474 - t475 + t476 - 0.17043584545824887717e1 * t315 - t478 + t479 + t480 + t481 + t482 + t390 + t1 * (t672 + t747);
  tv3rho30 = t472 + t750;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t751 = 0.4e1 * t490;
  t752 = 0.2e1 * t492;
  t753 = t494 * t191;
  t756 = t231 * t37;
  t767 = my_piecewise3(t68, 0, -0.3e1 / 0.8e1 * t753 * t232 + 0.3e1 * t756 * t132 * t168 + 0.3e1 / 0.4e1 * t396 * t237 + 0.3e1 * t71 * t132 - 0.9e1 * t399 * t58);
  t769 = t509 * t196;
  t772 = t243 * t37;
  t783 = my_piecewise3(t76, 0, -0.3e1 / 0.8e1 * t769 * t244 - 0.3e1 * t772 * t132 * t173 + 0.3e1 / 0.4e1 * t405 * t247 - 0.3e1 * t77 * t132 + 0.9e1 * t408 * t58);
  t785 = 0.3e1 / 0.2e1 * t132;
  t786 = 0.63e2 / 0.16e2 * t501;
  t787 = 0.63e2 / 0.8e1 * t524;
  t788 = 0.15e2 / 0.8e1 * t526;
  t789 = t767 / 0.2e1 + t783 / 0.2e1 - t785 - t786 + t787 - t788 + t531;
  t791 = t64 * t65 * t789;
  t794 = t64 * t14 * t415;
  t795 = 0.4e1 / 0.3e1 * t794;
  t797 = t64 * t388 * t201;
  t801 = t489 + t751 - t752 - 0.4e1 / 0.3e1 * t791 - t795 + t797 / 0.3e1 - t539 + 0.2e1 / 0.3e1 * t541 - t545 + t548 - 0.2e1 / 0.3e1 * t550;
  t802 = 0.2e1 * t602;
  t803 = 0.4e1 * t607;
  t804 = 0.8e1 * t661;
  t805 = 0.12e2 * t665;
  t806 = 0.12e2 * t670;
  t807 = t600 + t802 - t605 + t803 - t610 + t660 - t804 + t664 + t805 - t668 - t806;
  t809 = 0.32e2 * t673;
  t810 = 0.48e2 * t680;
  t811 = 0.8e2 * t682;
  t812 = t225 * t421;
  t814 = t317 * t421;
  t816 = t63 * t415;
  t817 = t160 * t816;
  t818 = 0.56811948486082959056e0 * t817;
  t820 = -t809 + t676 - t679 + t810 + t811 - t685 + 0.14202987121520739764e0 * t812 - 0.10726439253216493952e0 * t814 - t818 + t692 + 0.28405974243041479528e0 * t693;
  t823 = t697 - 0.28405974243041479528e0 * t699 - t703 - t705 - t708 - t724 - t732 - 0.21452878506432987904e0 * t733 - t737 - t740 - t743 + t746;
  t827 = t1 * (t801 + t807 + t820 + t823) + t482 - t352 + t481 + t294 - t468 - t298 + t470 + t304 - t473 - t309 - t311 + t476;
  t829 = 0.8e1 / 0.3e1 * t417;
  t831 = t479 - t455 + t460 + t461 - t464 - t465 - t466 - 0.11362389697216591811e1 * t315 - t478 - t456 + t390 - t829 - 0.8e1 / 0.3e1 * t229 - t266;
  tv3rho31 = t827 + t831;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t832 = t494 * t431;
  t837 = t231 * t435;
  t842 = -0.2e1 * t132 - 0.6e1 * t501;
  t846 = my_piecewise3(t68, 0, -0.3e1 / 0.8e1 * t832 * t168 + 0.3e1 * t396 * t235 + 0.3e1 / 0.4e1 * t837 * t168 + 0.3e1 / 0.2e1 * t71 * t842);
  t848 = t509 * t441;
  t853 = t243 * t444;
  t856 = -t842;
  t860 = my_piecewise3(t76, 0, -0.3e1 / 0.8e1 * t848 * t173 - 0.3e1 * t405 * t235 + 0.3e1 / 0.4e1 * t853 * t173 + 0.3e1 / 0.2e1 * t77 * t856);
  t862 = t846 / 0.2e1 + t860 / 0.2e1 - t785 + t786 + t787 + t788 + t531;
  t864 = t64 * t65 * t862;
  t867 = t64 * t14 * t450;
  t871 = t489 + t751 - t752 - 0.4e1 / 0.3e1 * t864 - 0.2e1 / 0.3e1 * t867 - t795 + 0.2e1 / 0.3e1 * t797 - t539 + t541 / 0.3e1 - t545 + t548;
  t872 = t600 - t802 - t605 - t803 - t610 + t660 + t804 + t664 - t805 - t668 - t806;
  t874 = t63 * t450;
  t875 = t160 * t874;
  t879 = t809 + t676 + t679 + t810 - t811 - t685 - 0.28405974243041479528e0 * t875 + 0.28405974243041479528e0 * t812 - 0.21452878506432987904e0 * t814 - t818 + t692;
  t882 = 0.14202987121520739764e0 * t693 + t697 - t703 - t705 - t708 - t724 - t732 - 0.10726439253216493952e0 * t733 - t737 - t740 - t743 + t746;
  t886 = t1 * (t871 + t872 + t879 + t882) + t482 - t352 + t481 - t294 - t468 + t298 + t470 - t304 - t473 - t309 + t311 + t476;
  t889 = t479 - 0.11362389697216591811e1 * t422 + t460 + t461 - t464 - t465 - t466 - t316 - t478 - 0.8e1 / 0.3e1 * t425 - t453 + t390 - t829 - t230;
  tv3rho32 = t886 + t889;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t891 = t460 + t461 - 0.4e1 * t452 - t464 - t465 - t466 - t467 - t468 + t469 + t470 - t471 - t473;
  t894 = t431 * t191;
  t900 = -0.6e1 * t132 - 0.6e1 * t501;
  t904 = my_piecewise3(t68, 0, -0.3e1 / 0.8e1 * t494 * t894 + 0.9e1 / 0.4e1 * t396 * t435 + 0.3e1 / 0.2e1 * t71 * t900);
  t906 = t441 * t196;
  t911 = -t900;
  t915 = my_piecewise3(t76, 0, -0.3e1 / 0.8e1 * t509 * t906 + 0.9e1 / 0.4e1 * t405 * t444 + 0.3e1 / 0.2e1 * t77 * t911);
  t917 = t904 / 0.2e1 + t915 / 0.2e1 + t522 + t523 + t525 + t527 + t531;
  t919 = t64 * t65 * t917;
  t920 = 0.4e1 / 0.3e1 * t919;
  t922 = t489 - t491 + t493 - t920 - 0.2e1 * t867 + t797 - t539 - t545 + t548 + t600 - t603 - t605 - t608 - t610 + t660 + t662 + t664 - t666 - t668 + t671;
  t924 = 0.42608961364562219292e0 * t812;
  t925 = 0.32179317759649481856e0 * t814;
  t926 = t674 + t676 - t679 - t681 - t683 - t685 - 0.85217922729124438584e0 * t875 + t924 - t925 + t692 + t697 - t703 - t705 - t708 - t724 - t732 - t737 - t740 - t743 + t746;
  t929 = t474 + t475 + t476 - t478 - 0.17043584545824887717e1 * t422 + t479 + t480 + t481 + t482 + t390 - 0.4e1 * t425 + t1 * (t922 + t926);
  tv3rho33 = t891 + t929;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t930 = t302 * t260;
  t931 = 0.96e3 * t930;
  t933 = 0.48e3 * t150 * t529;
  t934 = t677 * t157;
  t935 = 0.384e3 * t934;
  t936 = t307 * t260;
  t937 = 0.144e4 * t936;
  t938 = t153 * t529;
  t939 = 0.192e4 * t938;
  t940 = t57 * t57;
  t941 = 0.1e1 / t940;
  t943 = 0.84e3 * t56 * t941;
  t953 = t364 * t364;
  t960 = t370 * t370;
  t977 = -0.4e1 * t375 * t583 * t377 * t145 + 0.6e1 * t363 * t960 * t146 + 0.24e2 * t577 * t953 * t146 + 0.8e1 * t363 * t147 * t583 + 0.12e2 * t356 * t362 * t365 - 0.36e2 * t375 * t365 * t370 + 0.36e2 * t577 * t378 * t370 - 0.3e1 * t375 * t960 * t377 + 0.24e2 * t560 * t572 - 0.24e2 * t565 * t569 - 0.12e2 * t565 * t587;
  t1009 = 0.1e1 / t2 / t156;
  t1014 = t373 * t373;
  t1017 = t376 * t376;
  t1027 = -0.12e2 * t592 * t370 * t594 * t364 - 0.4e1 * t555 * t141 * t147 - 0.6e1 * t557 * t371 - 0.6e1 * t356 * t374 * t378 + 0.24e2 * t138 * t576 * t578 - 0.4e1 * t358 * t584 - 0.8e1 * t138 * t591 * t595 - 0.36e2 * t592 * t953 * t377 + 0.24e2 * t46 / t373 / t361 * t953 * t594 - t142 * (0.52734661089905341788e1 * t486 + 0.12336833377377678256e2 * t1009) * t146 - 0.6e1 * t46 / t1014 * t953 / t1017 + (-0.13733661521039856344e0 * t486 + 0.12499494469828670903e0 * t157 - 0.28891383349813237153e0 * t1009) * t52;
  t1030 = (t977 + t1027) * t55 * t58;
  t1035 = (0.31957559837770623688e0 * t486 + 0.43726916614421481536e0 * t157 + 0.35670619807330844177e-1 * t1009) * t22;
  t1036 = t348 * t41;
  t1037 = 0.12e2 * t1036;
  t1039 = 0.24e2 * t54 * t58;
  t1040 = t36 * t58;
  t1041 = 0.72e2 * t1040;
  t1042 = t125 * t132;
  t1043 = 0.48e2 * t1042;
  t1044 = t282 * t282;
  t1047 = 0.6e1 * t220 * t1044 * t107;
  t1050 = 0.3e1 * t287 * t1044 * t289;
  t1051 = t735 * t314;
  t1055 = 0.15294925111357257807e-1 * t1009 * t61 * t161;
  t1056 = t931 - t933 - t935 + t937 - t939 + t943 + t1030 + t1035 + t1037 + t1039 + t1041 - t1043 + t1047 - t1050 - 0.16201732504369729658e0 * t1051 - t1055;
  t1057 = t221 * t221;
  t1060 = 0.24e2 * t688 * t1057 * t107;
  t1066 = 0.24e2 * t10 / t285 / t218 * t1057 * t729;
  t1067 = t695 * t314;
  t1071 = 0.28353031882647026902e0 * t157 * t61 * t161;
  t1073 = t160 * t63 * t532;
  t1075 = t317 * t698;
  t1079 = 0.4e1 * t488 * t97 * t108;
  t1081 = 0.6e1 * t701 * t283;
  t1084 = 0.6e1 * t386 * t286 * t290;
  t1086 = 0.4e1 * t267 * t723;
  t1089 = 0.8e1 * t94 * t726 * t730;
  t1091 = pow(t14, -0.25e1);
  t1092 = M_PI * M_PI;
  t1107 = t98 * (0.37106396291446213644e1 * t486 - 0.7273828125e-3 * t1091 / t1092 * t260 + 0.872859375e-2 * t713 * t1009 - 0.8437640625e-1 * t273 * t157 - 0.2036671875e0 * t101 * t486 + 0.25971794881416795504e1 * t157 + 0.18530192107704334636e0 * t1009) * t107;
  t1108 = t285 * t285;
  t1111 = t288 * t288;
  t1115 = 0.6e1 * t10 / t1108 * t1057 / t1111;
  t1117 = 0.24e2 * t706 * t738;
  t1120 = 0.36e2 * t727 * t1057 * t289;
  t1121 = t741 * t314;
  t1123 = t1060 + t1066 + 0.12871727103859792742e1 * t1067 + t1071 - 0.11362389697216591811e1 * t1073 - 0.64358635519298963712e0 * t1075 - t1079 - t1081 - t1084 - t1086 - t1089 - t1107 - t1115 - t1117 - t1120 - 0.85217922729124438584e0 * t1121;
  t1127 = 0.12067244159868555696e1 * t486 * t61 * t161;
  t1128 = t225 * t698;
  t1132 = 0.12e2 * t386 * t219 * t222;
  t1135 = 0.24e2 * t94 * t687 * t690;
  t1137 = 0.8e1 * t659 * t132;
  t1139 = t598 * t152 * t58;
  t1140 = 0.16e2 * t1139;
  t1142 = 0.16e2 * t599 * t157;
  t1152 = t331 * t331;
  t1159 = t338 * t338;
  t1176 = -0.4e1 * t343 * t643 * t345 * t121 + 0.24e2 * t636 * t1152 * t122 + 0.6e1 * t330 * t1159 * t122 - 0.3e1 * t343 * t1159 * t345 + 0.8e1 * t330 * t123 * t643 + 0.12e2 * t323 * t329 * t332 - 0.36e2 * t343 * t332 * t338 + 0.36e2 * t636 * t346 * t338 + 0.24e2 * t619 * t631 - 0.24e2 * t624 * t628 - 0.12e2 * t624 * t647;
  t1212 = t341 * t341;
  t1215 = t344 * t344;
  t1225 = -0.12e2 * t652 * t338 * t654 * t331 - 0.4e1 * t614 * t116 * t123 - 0.6e1 * t616 * t339 - 0.6e1 * t323 * t342 * t346 + 0.24e2 * t113 * t635 * t637 - 0.4e1 * t325 * t644 - 0.8e1 * t113 * t651 * t655 - 0.36e2 * t652 * t1152 * t345 + 0.24e2 * t27 / t341 / t328 * t1152 * t654 - t117 * (0.15302408289018878567e1 * t486 + 0.5106711712502879972e0 * t157 + 0.82722935459637152739e-2 * t1009) * t122 - 0.6e1 * t27 / t1212 * t1152 / t1215 + (-0.12566265118057119248e0 * t486 - 0.58576531171131421024e-1 * t157 - 0.97059647404146867678e-3 * t1009) * t34;
  t1228 = (t1176 + t1225) * t38 * t41;
  t1230 = t658 * t37 * t41;
  t1231 = 0.8e1 * t1230;
  t1233 = t149 * t37 * t58;
  t1234 = 0.96e2 * t1233;
  t1235 = t669 * t157;
  t1236 = 0.576e3 * t1235;
  t1237 = t601 * t132;
  t1238 = 0.48e2 * t1237;
  t1240 = 0.36e2 * t349 * t58;
  t1242 = t380 * t38 * t58;
  t1243 = 0.72e2 * t1242;
  t1244 = t606 * t157;
  t1245 = 0.192e3 * t1244;
  t1247 = 0.12e3 * t381 * t260;
  t1248 = -t1127 + 0.85217922729124438584e0 * t1128 + t1132 + t1135 - t1137 + t1140 - t1142 + t1228 + t1231 + t1234 - t1236 - t1238 + t1240 + t1243 - t1245 + t1247;
  t1249 = t292 * t58;
  t1250 = 0.144e3 * t1249;
  t1252 = 0.96e2 * t126 * t157;
  t1253 = t128 * t157;
  t1254 = 0.192e3 * t1253;
  t1256 = 0.12e3 * t39 * t260;
  t1258 = t64 * t542 * t185;
  t1263 = 0.5e1 / 0.4e1 * t64 * t13 * t280 * t85;
  t1266 = 0.36e2 * t287 * t222 * t282;
  t1268 = 0.24e2 * t744 * t546;
  t1271 = 0.8e1 * t220 * t108 * t722;
  t1274 = 0.36e2 * t688 * t290 * t282;
  t1276 = t64 * t14 * t532;
  t1279 = 0.12e2 * t706 * t537;
  t1283 = 0.4e1 * t287 * t722 * t289 * t106;
  t1287 = 0.12e2 * t727 * t221 * t729 * t282;
  t1288 = t67 * t67;
  t1290 = 0.1e1 / t71 / t1288;
  t1291 = t232 * t232;
  t1297 = t237 * t237;
  t1302 = t37 * t157;
  t1304 = -0.24e2 * t58 + 0.24e2 * t1302;
  t1308 = my_piecewise3(t68, 0, 0.9e1 / 0.16e2 * t1290 * t1291 - 0.9e1 / 0.4e1 * t494 * t232 * t237 + 0.9e1 / 0.4e1 * t231 * t1297 + 0.3e1 * t498 * t503 + 0.3e1 / 0.2e1 * t71 * t1304);
  t1310 = t75 * t75;
  t1312 = 0.1e1 / t77 / t1310;
  t1313 = t244 * t244;
  t1319 = t247 * t247;
  t1328 = my_piecewise3(t76, 0, 0.9e1 / 0.16e2 * t1312 * t1313 - 0.9e1 / 0.4e1 * t509 * t244 * t247 + 0.9e1 / 0.4e1 * t243 * t1319 + 0.3e1 * t513 * t516 - 0.3e1 / 0.2e1 * t77 * t1304);
  t1330 = 0.441e3 / 0.16e2 * t58;
  t1331 = 0.81e2 * t1302;
  t1332 = t38 * t260;
  t1333 = 0.315e3 / 0.4e1 * t1332;
  t1334 = t152 * t529;
  t1335 = 0.45e2 * t1334;
  t1337 = 0.315e3 / 0.16e2 * t55 * t941;
  t1343 = t64 * t388 * t263;
  t1345 = 0.53261201705702774115e0 * t736;
  t1346 = t1250 - t1252 - t1254 + t1256 - 0.2e1 * t1258 + t1263 - t1266 + t1268 + t1271 + t1274 - 0.8e1 / 0.3e1 * t1276 - t1279 - t1283 - t1287 - 0.4e1 / 0.3e1 * t64 * t65 * (t1308 / 0.2e1 + t1328 / 0.2e1 - t1330 + t1331 - t1333 + t1335 - t1337) + 0.2e1 * t1343 + t1345;
  t1350 = 0.4e1 * t489;
  t1351 = 0.48e2 * t490;
  t1352 = 0.24e2 * t492;
  t1354 = 0.12e2 * t538;
  t1356 = 0.2e1 * t544;
  t1357 = 0.24e2 * t547;
  t1359 = 0.4e1 * t600;
  t1360 = 0.24e2 * t602;
  t1361 = 0.24e2 * t604;
  t1362 = 0.48e2 * t607;
  t1363 = 0.48e2 * t609;
  t1364 = 0.4e1 * t660;
  t1365 = 0.96e2 * t661;
  t1366 = 0.72e2 * t663;
  t1367 = 0.144e3 * t665;
  t1368 = 0.96e2 * t667;
  t1369 = t1 * (t1056 + t1123 + t1248 + t1346) + t1350 - t1351 + t1352 - 0.16e2 / 0.3e1 * t534 - t1354 + 0.4e1 * t541 - t1356 + t1357 - 0.8e1 * t550 + t1359 + t1360 - t1361 + t1362 - t1363 + t1364 - t1365 + t1366 + t1367 - t1368;
  t1370 = 0.144e3 * t670;
  t1371 = 0.384e3 * t673;
  t1372 = 0.24e3 * t675;
  t1373 = 0.96e2 * t678;
  t1374 = 0.576e3 * t680;
  t1375 = 0.96e3 * t682;
  t1376 = 0.48e3 * t684;
  t1377 = 0.24e2 * t691;
  t1379 = 0.12871727103859792742e1 * t696;
  t1382 = 0.12e2 * t702;
  t1383 = 0.12e2 * t704;
  t1384 = 0.12e2 * t707;
  t1385 = 0.4e1 * t724;
  t1386 = 0.8e1 * t731;
  t1388 = 0.16201732504369729658e0 * t736;
  t1389 = 0.24e2 * t739;
  t1390 = 0.85217922729124438584e0 * t742;
  t1391 = 0.24e2 * t745;
  t1392 = -0.34087169091649775433e1 * t699 - t1382 - t1383 - t1384 - t1385 - t1386 - 0.12871727103859792742e1 * t733 - t1388 - t1389 - t1390 + t1391;
  tv4rho40 = t1369 + t1370 - t1371 + t1372 + t1373 - t1374 + t1375 - t1376 + t1377 + 0.17043584545824887717e1 * t693 + t1379 + t1392;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1395 = t64 * t388 * t415;
  t1397 = t64 * t542 * t201;
  t1400 = t64 * t14 * t789;
  t1426 = 0.36e2 * t399 * t157;
  t1428 = my_piecewise3(t68, 0, 0.9e1 / 0.16e2 * t1290 * t191 * t495 - 0.9e1 / 0.4e1 * t494 * t37 * t132 * t232 - 0.9e1 / 0.8e1 * t753 * t168 * t237 + 0.9e1 / 0.2e1 * t231 * t132 * t168 - 0.27e2 / 0.2e1 * t756 * t58 * t168 + 0.9e1 / 0.2e1 * t756 * t132 * t237 + 0.3e1 / 0.4e1 * t396 * t503 - 0.18e2 * t71 * t58 + t1426);
  t1454 = 0.36e2 * t408 * t157;
  t1456 = my_piecewise3(t76, 0, 0.9e1 / 0.16e2 * t1312 * t196 * t510 + 0.9e1 / 0.4e1 * t509 * t37 * t132 * t244 - 0.9e1 / 0.8e1 * t769 * t173 * t247 - 0.9e1 / 0.2e1 * t243 * t132 * t173 + 0.27e2 / 0.2e1 * t772 * t58 * t173 - 0.9e1 / 0.2e1 * t772 * t132 * t247 + 0.3e1 / 0.4e1 * t405 * t516 + 0.18e2 * t77 * t58 - t1454);
  t1458 = 0.9e1 / 0.16e2 * t58;
  t1459 = 0.63e2 / 0.2e1 * t1302;
  t1460 = 0.45e2 * t1332;
  t1461 = 0.45e2 / 0.2e1 * t1334;
  t1466 = 0.48e3 * t930;
  t1467 = 0.192e3 * t934;
  t1468 = 0.96e3 * t938;
  t1470 = t160 * t63 * t789;
  t1472 = t317 * t816;
  t1473 = 0.32179317759649481856e0 * t1472;
  t1474 = t741 * t421;
  t1476 = t695 * t421;
  t1478 = t735 * t421;
  t1480 = t1395 - t1397 / 0.2e1 - 0.2e1 * t1400 - 0.4e1 / 0.3e1 * t64 * t65 * (t1428 / 0.2e1 + t1456 / 0.2e1 + t1458 + t1459 - t1460 + t1461 - t1337) + t1466 - t933 + t1467 - t1468 + t943 + t1030 + t1035 - t1039 - 0.85217922729124438584e0 * t1470 - t1473 - 0.21304480682281109646e0 * t1474 + 0.32179317759649481856e0 * t1476 - 0.40504331260924324145e-1 * t1478;
  t1481 = t225 * t816;
  t1482 = 0.42608961364562219292e0 * t1481;
  t1487 = t1482 + t1047 - t1050 - 0.12151299378277297244e0 * t1051 - t1055 + t1060 + t1066 + 0.96537953278948445568e0 * t1067 + t1071 - 0.28405974243041479528e0 * t1073 - 0.32179317759649481856e0 * t1075 - t1079 - t1081 - t1084 - t1086 - t1089 - t1107;
  t1491 = 0.8e1 * t1139;
  t1492 = 0.4e1 * t1230;
  t1493 = 0.48e2 * t1233;
  t1494 = 0.24e2 * t1237;
  t1495 = 0.96e2 * t1244;
  t1496 = -t1115 - t1117 - t1120 - 0.63913442046843328938e0 * t1121 - t1127 + 0.42608961364562219292e0 * t1128 + t1132 + t1135 - t1137 + t1491 - t1142 + t1228 + t1492 - t1493 - t1494 + t1240 - t1495;
  t1497 = 0.72e2 * t1249;
  t1498 = 0.96e2 * t1253;
  t1501 = t1247 + t1497 - t1252 - t1498 + t1256 - 0.3e1 / 0.2e1 * t1258 + t1263 - t1266 + t1268 + t1271 + t1274 - 0.2e1 / 0.3e1 * t1276 - t1279 - t1283 - t1287 + t1343 + t1345;
  t1506 = 0.4e1 * t794;
  t1510 = 0.12e2 * t602;
  t1511 = 0.24e2 * t607;
  t1512 = 0.48e2 * t661;
  t1513 = 0.72e2 * t665;
  t1514 = -0.4e1 * t550 + t1359 + t1510 - t1361 + t1511 - t1363 + t1364 - t1512 + t1366 + t1513 - t1368;
  t1516 = 0.192e3 * t673;
  t1517 = 0.48e2 * t678;
  t1518 = 0.48e3 * t682;
  t1519 = 0.17043584545824887717e1 * t817;
  t1521 = -t1516 + t1372 - t1517 + t1518 - t1376 + t924 - t925 - t1519 + t1377 + 0.12782688409368665787e1 * t693 + t1379;
  t1524 = -0.17043584545824887717e1 * t699 - t1382 - t1383 - t1384 - t1385 - t1386 - 0.96537953278948445567e0 * t733 - t1388 - t1389 - t1390 + t1391;
  tv4rho41 = t1 * (t1480 + t1487 + t1496 + t1501) + t1350 - 0.4e1 * t791 - t1506 + t797 - t535 - t1354 + 0.3e1 * t541 - t1356 + t1357 + t1514 + t1521 + t1524;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1537 = -t1356 + t1357 - 0.4e1 / 0.3e1 * t550 + t1359 - t1361 - t1363 + t1364 + t1366 - t1368 - 0.48e2 * t670 + t1372;
  t1573 = my_piecewise3(t68, 0, 0.9e1 / 0.16e2 * t1290 * t431 * t232 - 0.3e1 * t753 * t168 * t37 * t132 - 0.3e1 / 0.8e1 * t832 * t237 + 0.6e1 * t231 * t38 * t260 + 0.3e1 * t396 * t132 - 0.9e1 * t396 * t501 - 0.3e1 / 0.8e1 * t494 * t435 * t232 + 0.3e1 / 0.2e1 * t231 * t842 * t168 + 0.3e1 / 0.4e1 * t837 * t237 + t1426);
  t1600 = my_piecewise3(t76, 0, 0.9e1 / 0.16e2 * t1312 * t441 * t244 + 0.3e1 * t769 * t173 * t37 * t132 - 0.3e1 / 0.8e1 * t848 * t247 + 0.6e1 * t243 * t38 * t260 - 0.3e1 * t405 * t132 + 0.9e1 * t405 * t501 - 0.3e1 / 0.8e1 * t509 * t444 * t244 + 0.3e1 / 0.2e1 * t243 * t856 * t173 + 0.3e1 / 0.4e1 * t853 * t247 - t1454);
  t1609 = t64 * t388 * t450;
  t1612 = t64 * t14 * t862;
  t1620 = t317 * t874;
  t1622 = -0.4e1 / 0.3e1 * t64 * t65 * (t1573 / 0.2e1 + t1600 / 0.2e1 + 0.135e3 / 0.16e2 * t58 - 0.135e3 / 0.4e1 * t1332 - t1337) + t1609 / 0.3e1 - 0.4e1 / 0.3e1 * t1612 + 0.4e1 / 0.3e1 * t1395 - t1397 - 0.4e1 / 0.3e1 * t1400 - t933 - 0.48e3 * t936 + t943 + t1030 + t1035 - 0.4e1 * t1036 + t1039 - 0.24e2 * t1040 + 0.16e2 * t1042 - 0.10726439253216493952e0 * t1620;
  t1632 = -0.56811948486082959056e0 * t1470 - 0.42905757012865975808e0 * t1472 - 0.42608961364562219292e0 * t1474 + 0.64358635519298963712e0 * t1476 - 0.81008662521848648291e-1 * t1478 + 0.56811948486082959056e0 * t1481 + t1047 - t1050 - 0.8100866252184864829e-1 * t1051 - t1055 + t1060 + t1066 + 0.64358635519298963712e0 * t1067 + t1071 - 0.10726439253216493952e0 * t1075 - t1079 - t1081;
  t1637 = -t1084 - t1086 - t1089 - t1107 - t1115 - t1117 - t1120 - 0.42608961364562219292e0 * t1121 - t1127 + 0.14202987121520739764e0 * t1128 + t1132 + t1135 - t1137 - t1142 + t1228 + 0.192e3 * t1235 + t1240;
  t1641 = t160 * t63 * t862;
  t1643 = t225 * t874;
  t1645 = -0.24e2 * t1242 + t1247 - t1252 + t1256 - t1258 + t1263 - t1266 + t1268 + t1271 + t1274 - t1279 - t1283 - t1287 + t1343 / 0.3e1 + t1345 - 0.56811948486082959056e0 * t1641 + 0.14202987121520739764e0 * t1643;
  t1649 = -t1382 - t1383 - t1384 - t1385 - t1386 - 0.64358635519298963712e0 * t733 - t1388 - t1389 - t1390 + t1391 + t1 * (t1622 + t1632 + t1637 + t1645);
  tv4rho42 = t1350 + 0.16e2 * t490 - 0.8e1 * t492 - 0.8e1 / 0.3e1 * t864 - 0.4e1 / 0.3e1 * t867 - 0.8e1 / 0.3e1 * t791 - 0.16e2 / 0.3e1 * t794 + 0.2e1 * t797 - t1354 + 0.2e1 * t541 + t1537 + 0.192e3 * t680 - t1376 - 0.56811948486082959056e0 * t875 + 0.85217922729124438582e0 * t812 - 0.64358635519298963711e0 * t814 - 0.22724779394433183623e1 * t817 + t1377 + 0.85217922729124438584e0 * t693 + t1379 - 0.56811948486082959056e0 * t699 + t1649;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t1655 = t1359 - t1510 - t1361 - t1511 - t1363 + t1364 + t1512 + t1366 - t1513 - t1368 + t1516;
  t1660 = t1372 + t1517 - t1518 - t1376 - 0.17043584545824887717e1 * t875 + 0.12782688409368665788e1 * t812 - 0.96537953278948445569e0 * t814 - t1519 + t1377 + t694 + t1379;
  t1662 = t64 * t14 * t917;
  t1682 = 0.12e2 * t58 + 0.24e2 * t1302;
  t1686 = my_piecewise3(t68, 0, 0.9e1 / 0.16e2 * t1290 * t894 * t168 - 0.9e1 / 0.4e1 * t832 * t235 - 0.9e1 / 0.8e1 * t753 * t435 * t168 + 0.9e1 / 0.2e1 * t756 * t132 * t435 + 0.9e1 / 0.4e1 * t396 * t842 + 0.3e1 / 0.4e1 * t231 * t900 * t168 + 0.3e1 / 0.2e1 * t71 * t1682);
  t1708 = my_piecewise3(t76, 0, 0.9e1 / 0.16e2 * t1312 * t906 * t173 + 0.9e1 / 0.4e1 * t848 * t235 - 0.9e1 / 0.8e1 * t769 * t444 * t173 - 0.9e1 / 0.2e1 * t772 * t132 * t444 + 0.9e1 / 0.4e1 * t405 * t856 + 0.3e1 / 0.4e1 * t243 * t911 * t173 - 0.3e1 / 0.2e1 * t77 * t1682);
  t1718 = -0.2e1 / 0.3e1 * t1662 + t1609 - 0.4e1 / 0.3e1 * t64 * t65 * (t1686 / 0.2e1 + t1708 / 0.2e1 + t1458 - t1459 - t1460 - t1461 - t1337) - 0.2e1 * t1612 + t1395 - 0.3e1 / 0.2e1 * t1397 - t1466 - t933 - t1467 + t1468 + t943 + t1030 + t1035 - t1039 - 0.32179317759649481856e0 * t1620 - t1473 - 0.63913442046843328938e0 * t1474;
  t1723 = 0.96537953278948445568e0 * t1476 - 0.12151299378277297244e0 * t1478 + t1482 + t1047 - t1050 - 0.40504331260924324145e-1 * t1051 - t1055 + t1060 + t1066 + 0.32179317759649481856e0 * t1067 + t1071 - t1079 - t1081 - t1084 - t1086 - t1089 - t1107;
  t1726 = -t1115 - t1117 - t1120 - 0.21304480682281109646e0 * t1121 - t1127 + t1132 + t1135 - t1137 - t1491 - t1142 + t1228 - t1492 + t1493 + t1494 + t1240 + t1495 + t1247;
  t1731 = t160 * t63 * t917;
  t1733 = -t1497 - t1252 + t1498 + t1256 - t1258 / 0.2e1 + t1263 - t1266 + t1268 + t1271 + t1274 - t1279 - t1283 - t1287 + t1345 - 0.85217922729124438584e0 * t1641 + 0.42608961364562219292e0 * t1643 - 0.28405974243041479528e0 * t1731;
  t1737 = -t1382 - t1383 - t1384 - t1385 - t1386 - t734 - t1388 - t1389 - t1390 + t1391 + t1 * (t1718 + t1723 + t1726 + t1733);
  tv4rho43 = t1350 - t920 - 0.4e1 * t864 - 0.4e1 * t867 - t1506 + 0.3e1 * t797 - t1354 + t541 - t1356 + t1357 + t1655 + t1660 + t1737;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t1739 = t431 * t431;
  t1744 = t435 * t435;
  t1750 = 0.24e2 * t58 + 0.24e2 * t1302;
  t1754 = my_piecewise3(t68, 0, 0.9e1 / 0.16e2 * t1290 * t1739 - 0.9e1 / 0.4e1 * t832 * t435 + 0.9e1 / 0.4e1 * t231 * t1744 + 0.3e1 * t396 * t900 + 0.3e1 / 0.2e1 * t71 * t1750);
  t1756 = t441 * t441;
  t1761 = t444 * t444;
  t1770 = my_piecewise3(t76, 0, 0.9e1 / 0.16e2 * t1312 * t1756 - 0.9e1 / 0.4e1 * t848 * t444 + 0.9e1 / 0.4e1 * t243 * t1761 + 0.3e1 * t405 * t911 - 0.3e1 / 0.2e1 * t77 * t1750);
  t1779 = -0.4e1 / 0.3e1 * t64 * t65 * (t1754 / 0.2e1 + t1770 / 0.2e1 - t1330 - t1331 - t1333 - t1335 - t1337) - 0.8e1 / 0.3e1 * t1662 + 0.2e1 * t1609 - 0.2e1 * t1397 - t931 - t933 + t935 + t937 + t939 + t943 + t1030 + t1035 + t1037 + t1039 + t1041 - t1043;
  t1784 = -0.64358635519298963712e0 * t1620 - 0.85217922729124438584e0 * t1474 + 0.12871727103859792742e1 * t1476 - 0.16201732504369729658e0 * t1478 + t1047 - t1050 - t1055 + t1060 + t1066 + t1071 - t1079 - t1081 - t1084 - t1086 - t1089 - t1107;
  t1786 = -t1115 - t1117 - t1120 - t1127 + t1132 + t1135 - t1137 - t1140 - t1142 + t1228 - t1231 - t1234 - t1236 + t1238 + t1240 + t1243;
  t1789 = t1245 + t1247 - t1250 - t1252 + t1254 + t1256 + t1263 - t1266 + t1268 + t1271 + t1274 - t1279 - t1283 - t1287 + t1345 + 0.85217922729124438584e0 * t1643 - 0.11362389697216591811e1 * t1731;
  t1796 = t1 * (t1779 + t1784 + t1786 + t1789) + t1350 - t1351 + t1352 - 0.16e2 / 0.3e1 * t919 - 0.8e1 * t867 + 0.4e1 * t797 - t1354 - t1356 + t1357 + t1359 - t1360 - t1361 - t1362 - t1363 + t1364 + t1365 + t1366 - t1367 - t1368;
  t1801 = t1377 + t1379 - t1382 - t1383 - t1384 - t1385 - t1386 - t1388 - t1389 - t1390 + t1391;
  tv4rho44 = t1796 + t1370 + t1371 + t1372 - t1373 - t1374 - t1375 - t1376 - 0.34087169091649775433e1 * t875 + 0.17043584545824887717e1 * t812 - 0.12871727103859792742e1 * t814 + t1801;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

}

#endif

