/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.layouter.model;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jd.core.v1.model.fragment.FixedFragment;
import org.jd.core.v1.model.fragment.FlexibleFragment;
import org.jd.core.v1.service.layouter.util.VisitorsHolder;
import org.jd.core.v1.service.layouter.visitor.AbstractSearchMovableBlockFragmentVisitor;
import org.jd.core.v1.service.layouter.visitor.AbstractStoreMovableBlockFragmentIndexVisitorAbstract;
import org.jd.core.v1.util.DefaultList;

public class Section {
    protected final DefaultList<FlexibleFragment> flexibleFragments;
    protected final FixedFragment fixedFragment;
    protected final Section previousSection;
    protected Section nextSection;
    protected final int targetLineCount;
    protected int rate = 0;
    protected int lastLineCount = -1;
    protected int delta;

    public Section(DefaultList<FlexibleFragment> flexibleFragments, FixedFragment fixedFragment, Section previousSection) {
        int previousLineNumber;
        this.flexibleFragments = flexibleFragments;
        this.fixedFragment = fixedFragment;
        this.previousSection = previousSection;
        assert (flexibleFragments != null && flexibleFragments.size() > 0) : "Section must contain flexible fragments";
        if (previousSection == null) {
            previousLineNumber = 1;
        } else {
            previousSection.nextSection = this;
            previousLineNumber = previousSection.fixedFragment.getLastLineNumber();
        }
        this.targetLineCount = fixedFragment == null ? 0 : fixedFragment.getFirstLineNumber() - previousLineNumber;
    }

    public DefaultList<FlexibleFragment> getFlexibleFragments() {
        return this.flexibleFragments;
    }

    public FixedFragment getFixedFragment() {
        return this.fixedFragment;
    }

    public Section getPreviousSection() {
        return this.previousSection;
    }

    public Section getNextSection() {
        return this.nextSection;
    }

    public int getRate() {
        return this.rate;
    }

    public void updateRate() {
        this.rate = 0;
        for (FlexibleFragment flexibleFragment : this.flexibleFragments) {
            if (flexibleFragment.getInitialLineCount() <= flexibleFragment.getLineCount()) continue;
            this.rate += flexibleFragment.getInitialLineCount() - flexibleFragment.getLineCount();
        }
    }

    public boolean layout(boolean force) {
        if (this.fixedFragment != null) {
            int currentLineCount = 0;
            for (FlexibleFragment flexibleFragment : this.flexibleFragments) {
                currentLineCount += flexibleFragment.getLineCount();
            }
            if (force || this.lastLineCount != currentLineCount) {
                this.lastLineCount = currentLineCount;
                if (this.targetLineCount != currentLineCount) {
                    AutoGrowthList filteredFlexibleFragments = new AutoGrowthList();
                    DefaultList<FlexibleFragment> constrainedFlexibleFragments = new DefaultList<FlexibleFragment>(this.flexibleFragments.size());
                    if (this.targetLineCount > currentLineCount) {
                        int oldDelta = this.delta = this.targetLineCount - currentLineCount;
                        for (FlexibleFragment flexibleFragment : this.flexibleFragments) {
                            if (flexibleFragment.getLineCount() >= flexibleFragment.getMaximalLineCount()) continue;
                            filteredFlexibleFragments.get(flexibleFragment.getWeight()).add(flexibleFragment);
                        }
                        for (DefaultList flexibleFragments : filteredFlexibleFragments) {
                            constrainedFlexibleFragments.clear();
                            for (FlexibleFragment flexibleFragment : flexibleFragments) {
                                if (flexibleFragment.getLineCount() >= flexibleFragment.getInitialLineCount()) continue;
                                constrainedFlexibleFragments.add(flexibleFragment);
                            }
                            this.expand(constrainedFlexibleFragments, force);
                            if (this.delta != 0) continue;
                            break;
                        }
                        if (this.delta > 0) {
                            for (DefaultList flexibleFragments : filteredFlexibleFragments) {
                                this.expand(flexibleFragments, force);
                                if (this.delta != 0) continue;
                                break;
                            }
                        }
                        return oldDelta != this.delta;
                    }
                    int oldDelta = this.delta = currentLineCount - this.targetLineCount;
                    for (FlexibleFragment flexibleFragment : this.flexibleFragments) {
                        if (flexibleFragment.getMinimalLineCount() >= flexibleFragment.getLineCount()) continue;
                        filteredFlexibleFragments.get(flexibleFragment.getWeight()).add(flexibleFragment);
                    }
                    for (DefaultList flexibleFragments : filteredFlexibleFragments) {
                        constrainedFlexibleFragments.clear();
                        for (FlexibleFragment flexibleFragment : flexibleFragments) {
                            if (flexibleFragment.getLineCount() <= flexibleFragment.getInitialLineCount()) continue;
                            constrainedFlexibleFragments.add(flexibleFragment);
                        }
                        this.compact(constrainedFlexibleFragments, force);
                        if (this.delta != 0) continue;
                        break;
                    }
                    if (this.delta > 0) {
                        for (DefaultList flexibleFragments : filteredFlexibleFragments) {
                            this.compact(flexibleFragments, force);
                            if (this.delta != 0) continue;
                            break;
                        }
                    }
                    return oldDelta != this.delta;
                }
            }
        }
        return false;
    }

    protected void expand(DefaultList<FlexibleFragment> flexibleFragments, boolean force) {
        int oldDelta = Integer.MAX_VALUE;
        while (this.delta > 0 && this.delta < oldDelta) {
            FlexibleFragment flexibleFragment;
            oldDelta = this.delta;
            Iterator iterator = flexibleFragments.iterator();
            while (iterator.hasNext() && (!(flexibleFragment = (FlexibleFragment)iterator.next()).incLineCount(force) || --this.delta != 0)) {
            }
        }
    }

    protected void compact(DefaultList<FlexibleFragment> flexibleFragments, boolean force) {
        int oldDelta = Integer.MAX_VALUE;
        while (this.delta > 0 && this.delta < oldDelta) {
            FlexibleFragment flexibleFragment;
            oldDelta = this.delta;
            Iterator iterator = flexibleFragments.iterator();
            while (iterator.hasNext() && (!(flexibleFragment = (FlexibleFragment)iterator.next()).decLineCount(force) || --this.delta != 0)) {
            }
        }
    }

    public boolean releaseConstraints(VisitorsHolder holder) {
        int flexibleCount = this.flexibleFragments.size();
        AbstractStoreMovableBlockFragmentIndexVisitorAbstract backwardSearchStartIndexesVisitor = holder.getBackwardSearchStartIndexesVisitor();
        AbstractStoreMovableBlockFragmentIndexVisitorAbstract forwardSearchEndIndexesVisitor = holder.getForwardSearchEndIndexesVisitor();
        AbstractSearchMovableBlockFragmentVisitor forwardSearchVisitor = holder.getForwardSearchVisitor();
        AbstractSearchMovableBlockFragmentVisitor backwardSearchVisitor = holder.getBackwardSearchVisitor();
        ListIterator iterator = this.flexibleFragments.listIterator(flexibleCount);
        backwardSearchStartIndexesVisitor.reset();
        forwardSearchEndIndexesVisitor.reset();
        while (iterator.hasPrevious() && backwardSearchStartIndexesVisitor.isEnabled()) {
            ((FlexibleFragment)iterator.previous()).accept(backwardSearchStartIndexesVisitor);
        }
        for (FlexibleFragment flexibleFragment : this.flexibleFragments) {
            flexibleFragment.accept(forwardSearchEndIndexesVisitor);
            if (forwardSearchEndIndexesVisitor.isEnabled()) continue;
            break;
        }
        int size = backwardSearchStartIndexesVisitor.getSize();
        Section nextSection = this.searchNextSection(forwardSearchVisitor);
        if (size > 1 && nextSection != null) {
            int index1 = flexibleCount - 1 - backwardSearchStartIndexesVisitor.getIndex(size / 2);
            int index2 = flexibleCount - 1 - backwardSearchStartIndexesVisitor.getIndex(0);
            int nextIndex = forwardSearchVisitor.getIndex();
            size = forwardSearchEndIndexesVisitor.getSize();
            if (size > 1) {
                int index3 = forwardSearchEndIndexesVisitor.getIndex(0) + 1;
                int index4 = forwardSearchEndIndexesVisitor.getIndex(size / 2) + 1;
                Section previousSection = this.searchPreviousSection(backwardSearchVisitor);
                if (nextSection.getRate() > previousSection.getRate()) {
                    int index = previousSection.getFlexibleFragments().size() - backwardSearchVisitor.getIndex();
                    previousSection.addFragmentsAtEnd(holder, index, this.extract(index3, index4));
                } else {
                    nextSection.addFragmentsAtBeginning(holder, nextIndex, this.extract(index1, index2));
                }
            } else {
                nextSection.addFragmentsAtBeginning(holder, nextIndex, this.extract(index1, index2));
            }
            return true;
        }
        size = forwardSearchEndIndexesVisitor.getSize();
        if (size > 1) {
            int index3 = forwardSearchEndIndexesVisitor.getIndex(0) + 1;
            int index4 = forwardSearchEndIndexesVisitor.getIndex(size / 2) + 1;
            Section previousSection = this.searchPreviousSection(backwardSearchVisitor);
            if (size > 1 && previousSection != null) {
                int index = previousSection.getFlexibleFragments().size() - backwardSearchVisitor.getIndex();
                previousSection.addFragmentsAtEnd(holder, index, this.extract(index3, index4));
                return true;
            }
        }
        return false;
    }

    protected Section searchNextSection(AbstractSearchMovableBlockFragmentVisitor visitor) {
        visitor.reset();
        for (Section section = this.getNextSection(); section != null; section = section.getNextSection()) {
            visitor.resetIndex();
            for (FlexibleFragment flexibleFragment : section.getFlexibleFragments()) {
                flexibleFragment.accept(visitor);
                if (visitor.getDepth() != 0) continue;
                return section;
            }
        }
        return null;
    }

    protected Section searchPreviousSection(AbstractSearchMovableBlockFragmentVisitor visitor) {
        visitor.reset();
        for (Section section = this.getPreviousSection(); section != null; section = section.getPreviousSection()) {
            DefaultList<FlexibleFragment> flexibleFragments = section.getFlexibleFragments();
            ListIterator iterator = flexibleFragments.listIterator(flexibleFragments.size());
            visitor.resetIndex();
            while (iterator.hasPrevious()) {
                ((FlexibleFragment)iterator.previous()).accept(visitor);
                if (visitor.getDepth() != 0) continue;
                return section;
            }
        }
        return null;
    }

    protected void addFragmentsAtBeginning(VisitorsHolder holder, int index, List<FlexibleFragment> flexibleFragments) {
        AbstractSearchMovableBlockFragmentVisitor visitor = holder.getForwardSearchVisitor();
        ListIterator<FlexibleFragment> iterator = flexibleFragments.listIterator(flexibleFragments.size());
        visitor.reset();
        while (iterator.hasPrevious()) {
            iterator.previous().accept(visitor);
            if (visitor.getDepth() != 0) continue;
        }
        assert (visitor.getIndex() < flexibleFragments.size() && visitor.getIndex() > 1);
        int index1 = flexibleFragments.size() + 1 - visitor.getIndex();
        this.flexibleFragments.addAll(index, flexibleFragments.subList(0, index1));
        this.flexibleFragments.addAll(index, flexibleFragments.subList(index1, flexibleFragments.size()));
        this.resetLineCount();
    }

    protected void addFragmentsAtEnd(VisitorsHolder holder, int index, List<FlexibleFragment> flexibleFragments) {
        AbstractSearchMovableBlockFragmentVisitor visitor = holder.getForwardSearchVisitor();
        visitor.reset();
        for (FlexibleFragment flexibleFragment : flexibleFragments) {
            flexibleFragment.accept(visitor);
            if (visitor.getDepth() != 2) continue;
            break;
        }
        assert (visitor.getIndex() < flexibleFragments.size() && visitor.getIndex() > 1);
        int index1 = visitor.getIndex() - 1;
        this.flexibleFragments.addAll(index, flexibleFragments.subList(0, index1));
        this.flexibleFragments.addAll(index, flexibleFragments.subList(index1, flexibleFragments.size()));
        this.resetLineCount();
    }

    protected List<FlexibleFragment> extract(int index1, int index2) {
        this.resetLineCount();
        List subList = this.flexibleFragments.subList(index1, index2);
        DefaultList<FlexibleFragment> fragmentsToMove = new DefaultList<FlexibleFragment>((Collection<FlexibleFragment>)subList);
        subList.clear();
        return fragmentsToMove;
    }

    protected void resetLineCount() {
        for (FlexibleFragment flexibleFragment : this.flexibleFragments) {
            flexibleFragment.resetLineCount();
        }
    }

    public String toString() {
        return "Section{flexibleFragments.size=" + this.flexibleFragments.size() + ", fixedFragment.firstLineNumber=" + (this.fixedFragment == null ? "undefined" : Integer.valueOf(this.fixedFragment.getFirstLineNumber())) + ", rate=" + this.rate + "}";
    }

    protected class AutoGrowthList
    implements Iterable<DefaultList<FlexibleFragment>>,
    Iterator<DefaultList<FlexibleFragment>> {
        protected DefaultList<FlexibleFragment>[] elements = new DefaultList[21];
        protected int iteratorIndex;

        protected AutoGrowthList() {
        }

        public void set(int index, DefaultList<FlexibleFragment> element) {
            this.ensureCapacity(index);
            this.elements[index] = element;
        }

        public DefaultList<FlexibleFragment> get(int index) {
            this.ensureCapacity(index);
            DefaultList<FlexibleFragment> element = this.elements[index];
            if (element == null) {
                this.elements[index] = element = new DefaultList(Section.this.flexibleFragments.size());
            }
            return element;
        }

        public void reverse() {
            int index1 = 0;
            for (int index2 = this.elements.length - 1; index1 < index2; ++index1, --index2) {
                DefaultList<FlexibleFragment> tmp = this.elements[index1];
                this.elements[index1] = this.elements[index2];
                this.elements[index2] = tmp;
            }
        }

        protected void ensureCapacity(int minCapacity) {
            if (this.elements.length <= minCapacity) {
                DefaultList[] tmp = new DefaultList[minCapacity + 10];
                System.arraycopy(this.elements, 0, tmp, 0, this.elements.length);
                this.elements = tmp;
            }
        }

        @Override
        public Iterator<DefaultList<FlexibleFragment>> iterator() {
            int length = this.elements.length;
            this.iteratorIndex = 0;
            while (this.iteratorIndex < length && this.elements[this.iteratorIndex] == null) {
                ++this.iteratorIndex;
            }
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.iteratorIndex < this.elements.length;
        }

        @Override
        public DefaultList<FlexibleFragment> next() {
            DefaultList<FlexibleFragment> element = this.elements[this.iteratorIndex++];
            int length = this.elements.length;
            while (this.iteratorIndex < length && this.elements[this.iteratorIndex] == null) {
                ++this.iteratorIndex;
            }
            return element;
        }

        @Override
        public void remove() {
        }
    }
}

