/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.deserializer.classfile;

import java.io.UTFDataFormatException;

public class ClassFileReader {
    public static final int JAVA_MAGIC_NUMBER = -889275714;
    protected byte[] data;
    protected int offset = 0;

    public ClassFileReader(byte[] data) {
        this.data = data;
    }

    public void skip(int length) {
        this.offset += length;
    }

    public byte readByte() {
        return this.data[this.offset++];
    }

    public int readUnsignedByte() {
        return this.data[this.offset++] & 0xFF;
    }

    public int readUnsignedShort() {
        return (this.data[this.offset++] & 0xFF) << 8 | this.data[this.offset++] & 0xFF;
    }

    public final int readInt() {
        return (this.data[this.offset++] & 0xFF) << 24 | (this.data[this.offset++] & 0xFF) << 16 | (this.data[this.offset++] & 0xFF) << 8 | this.data[this.offset++] & 0xFF;
    }

    public final float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public long readLong() {
        long hi = (this.data[this.offset++] & 0xFF) << 24 | (this.data[this.offset++] & 0xFF) << 16 | (this.data[this.offset++] & 0xFF) << 8 | this.data[this.offset++] & 0xFF;
        long low = (this.data[this.offset++] & 0xFF) << 24 | (this.data[this.offset++] & 0xFF) << 16 | (this.data[this.offset++] & 0xFF) << 8 | this.data[this.offset++] & 0xFF;
        return (hi & 0xFFFFFFFFL) << 32 | low & 0xFFFFFFFFL;
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public void readFully(byte[] target) {
        int length = target.length;
        System.arraycopy(this.data, this.offset, target, 0, length);
        this.offset += length;
    }

    public String readUTF8() throws UTFDataFormatException {
        int utflenx = this.readUnsignedShort();
        char[] charArray = new char[utflenx];
        int maxOffset = this.offset + utflenx;
        int charArrayOffset = 0;
        block5: while (this.offset < maxOffset) {
            int c = this.data[this.offset++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    charArray[charArrayOffset++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    byte char2;
                    if (this.offset + 1 > maxOffset) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    if (((char2 = this.data[this.offset++]) & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + this.offset);
                    }
                    charArray[charArrayOffset++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if (this.offset + 2 > maxOffset) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = this.data[this.offset++];
                    byte char3 = this.data[this.offset++];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (this.offset - 1));
                    }
                    charArray[charArrayOffset++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + this.offset);
        }
        return new String(charArray, 0, charArrayOffset);
    }
}

