/*
 * Decompiled with CFR 0.152.
 */
package eu.bibl.banalysis.analyse;

import eu.bibl.banalysis.analyse.AnalyserCache;
import eu.bibl.banalysis.asm.ClassNode;
import eu.bibl.banalysis.storage.CallbackMappingData;
import eu.bibl.banalysis.storage.ClassMappingData;
import eu.bibl.banalysis.storage.FieldMappingData;
import eu.bibl.banalysis.storage.HookMap;
import eu.bibl.banalysis.storage.Identifiable;
import eu.bibl.banalysis.storage.InterfaceMappingData;
import eu.bibl.banalysis.storage.classes.ClassContainer;
import org.objectweb.asm.Opcodes;

public abstract class Analyser
implements Opcodes {
    protected final String name;
    protected ClassContainer container;
    protected HookMap hookMap;
    protected FieldMappingData[] fieldHooks;
    protected CallbackMappingData[] methodHooks;
    protected ClassMappingData classHook;
    protected ClassNode cn;

    public Analyser(ClassContainer container, HookMap hookMap) {
        this.name = this.getClass().getSimpleName().replace("Analyser", "");
        this.container = container;
        this.hookMap = hookMap;
        this.fieldHooks = new FieldMappingData[0];
        this.methodHooks = new CallbackMappingData[0];
        this.classHook = new ClassMappingData(this.name);
        if (AnalyserCache.currentContext() != null) {
            AnalyserCache.currentContext().cache(this);
        }
    }

    public Analyser(String name, ClassContainer container, HookMap hookMap) {
        this.name = name;
        this.container = container;
        this.hookMap = hookMap;
        this.fieldHooks = new FieldMappingData[0];
        this.methodHooks = new CallbackMappingData[0];
        this.classHook = new ClassMappingData(name);
        if (AnalyserCache.currentContext() != null) {
            AnalyserCache.currentContext().cache(this);
        }
    }

    public void addField(FieldMappingData field) {
        if (field == null) {
            return;
        }
        if (field.getFieldOwner() == null) {
            field.setFieldOwner(this.classHook);
        }
        if (field.getMethodOwner() == null) {
            field.setMethodOwner(this.classHook);
        }
        field.identify();
        this.hookMap.addField(field);
    }

    public void addMethod(CallbackMappingData method) {
        if (method == null) {
            return;
        }
        if (method.getMethodOwner() == null) {
            method.setMethodOwner(this.classHook);
        }
        if (method.getCallbackOwner() == null) {
            method.setCallbackOwner(this.classHook);
        }
        method.identify();
        this.hookMap.addMethod(method);
    }

    public void run(ClassNode cn) {
        this.cn = cn;
        if (this.accept()) {
            this.classHook.setIdentified(true);
            this.classHook.setObfuscatedName(cn.name);
            InterfaceMappingData imd = this.run();
            if (imd != null) {
                this.classHook.setInterfaceData(imd);
            }
            this.classHook.identify();
            this.hookMap.addClass(this.classHook);
        }
    }

    protected final HookMap getHookMap() {
        return this.hookMap;
    }

    protected final ClassNode getNode(String name) {
        return this.container.getNodes().get(name);
    }

    public ClassContainer getContainer() {
        return this.container;
    }

    public void setContainer(ClassContainer container) {
        this.container = container;
    }

    public void setHookMap(HookMap hookMap) {
        this.hookMap = hookMap;
    }

    public FieldMappingData[] getFieldHooks() {
        return this.fieldHooks;
    }

    public CallbackMappingData[] getMethodHooks() {
        return this.methodHooks;
    }

    public ClassMappingData getClassHook() {
        return this.classHook;
    }

    public void setClassHook(ClassMappingData classHook) {
        this.classHook = classHook;
    }

    public abstract boolean accept();

    public abstract InterfaceMappingData run();

    public boolean isAnalysed() {
        if (!this.classHook.isIdentified()) {
            return false;
        }
        for (FieldMappingData fieldMappingData : this.fieldHooks) {
            if (fieldMappingData.isIdentified()) continue;
            return false;
        }
        for (Identifiable identifiable : this.methodHooks) {
            if (identifiable.isIdentified()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }
}

