// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef QUICHE_QUIC_TEST_TOOLS_TEST_CERTIFICATES_H_
#define QUICHE_QUIC_TEST_TOOLS_TEST_CERTIFICATES_H_

#include "net/third_party/quiche/src/quic/platform/api/quic_macros.h"
#include "net/third_party/quiche/src/common/platform/api/quiche_string_piece.h"

namespace quic {
namespace test {

// A test certificate generated by //net/tools/quic/certs/generate-certs.sh.
QUIC_CONST_INIT extern const quiche::QuicheStringPiece kTestCertificate;

// PEM-encoded version of |kTestCertificate|.
QUIC_CONST_INIT extern const char kTestCertificatePem[];

// |kTestCertificatePem| with a PEM-encoded root appended to the end.
QUIC_CONST_INIT extern const char kTestCertificateChainPem[];

// PEM-encoded certificate that contains a subjectAltName with an
// unknown/unsupported type.
QUIC_CONST_INIT extern const char kTestCertWithUnknownSanTypePem[];

// DER-encoded private key for |kTestCertificate|.
QUIC_CONST_INIT extern const quiche::QuicheStringPiece
    kTestCertificatePrivateKey;

// PEM-encoded version of |kTestCertificatePrivateKey|.
QUIC_CONST_INIT extern const char kTestCertificatePrivateKeyPem[];

// The legacy PEM-encoded version of |kTestCertificatePrivateKey| manually
// generated from the one above using der2ascii.
QUIC_CONST_INIT extern const char kTestCertificatePrivateKeyLegacyPem[];

// Another DER-encoded test certificate, valid for foo.test, www.foo.test and
// *.wildcard.test.
QUIC_CONST_INIT extern const quiche::QuicheStringPiece kWildcardCertificate;

// DER-encoded private key for |kWildcardCertificate|.
QUIC_CONST_INIT extern const quiche::QuicheStringPiece
    kWildcardCertificatePrivateKey;

// PEM-encoded P-256 private key using legacy OpenSSL encoding.
QUIC_CONST_INIT extern const char kTestEcPrivateKeyLegacyPem[];

}  // namespace test
}  // namespace quic

#endif  // QUICHE_QUIC_TEST_TOOLS_TEST_CERTIFICATES_H_
