# -*- coding: utf-8 -*-

# Copyright 2012-2013 Calculate Ltd. http://www.calculate-linux.org
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

from itertools import ifilter
from calculate.core.datavars import DataVarsCore
from calculate.core.server.gen_pid import search_worked_process
from calculate.lib.cl_template import SystemIni
from calculate.lib.utils.content import getCfgFiles
from calculate.lib.utils.files import getRunCommands


class UpdateInfo(object):
    """
    Информационный объект о процессе обновления
    """

    def __init__(self, dv=None):
        if dv is None:
            self.dv = DataVarsCore()
            self.dv.importCore()
        else:
            self.dv = dv

    def need_update(self):
        return self.update_ready() or self.check_for_dispatch()

    def update_ready(self):
        """
        Проверить есть ли обновления по ini.env
        """
        return SystemIni().getVar('update', 'packages') == u'on'

    def check_for_dispatch(self):
        """
        Есть ли в системе не примененные файлы для dispatch-conf
        """
        return bool(getCfgFiles(self.dv.Get('cl_config_protect'),
                                prefix=self.dv.Get('cl_chroot_path')))

    def is_console_gui_run(self):
        """
        Проверить есть ли уже запущенная копия console-gui
        """
        return any(ifilter(lambda x: "cl-console-gui" in x, getRunCommands()))

    def update_already_run(self):
        """
        В системе уже есть работающий процесс обновления
        """
        return search_worked_process("update", self.dv)
