# Copyright 2012 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import soaplib, sys, time, os
import threading

from soaplib.serializers.primitive import String, Integer, Any, Boolean
from soaplib.serializers.clazz import Array, ClassSerializer
from soaplib.service import rpc, DefinitionBase
from calculate.core.server.api_types import ReturnedMessage
from calculate.core.server.api_types import ChoiceValue, Table, Option, Field, \
                                           GroupField, ViewInfo, ViewParams
from calculate.lib.datavars import VariableError,DataVarsError
from calculate.update.cl_update import UpdateError

from cl_update import Update,DataVarsUpdate
import cl_update
from calculate.lib.cl_lang import setLocalTranslate,getLazyLocalTranslate
from calculate.core.server.decorators import Dec
from calculate.core.server.func import catchExcept,commonView
core_method = Dec.core_method
setLocalTranslate('cl_update3',sys.modules[__name__])
import traceback
from functools import wraps,WRAPPER_ASSIGNMENTS

__ = getLazyLocalTranslate(_)

class UpdateInfo(ClassSerializer):
    """Parameters for method install"""
    cl_update_rev_set = String
    cl_rebuild_world_set = String

    Default = Array(String)
    CheckOnly = Boolean
    CheckAll = Boolean

updateCatchExcept = catchExcept(VariableError,DataVarsError,
                                 cl_update.UpdateError)

class Wsdl:
    """
    cl-update
    """
    @rpc(Integer, UpdateInfo, _returns = Array(ReturnedMessage))
    @core_method(category=__('Update'),title=__('Update world'),
        image='software-properties,preferences-desktop',
        gui=True,command='cl-update',
        rights=['update'])
    def update(self, sid, info):
        return self.callMethod(sid,info,method_name="update",
                               logicClass=Update,
                               method="update")

    def update_vars(self,dv=None):
        if not dv:
            dv = DataVarsUpdate()
            dv.importUpdate()
            dv.flIniFile()
            dv.Set('cl_action','sync',True)
        dv.addGroup(None,
            normal=('cl_rebuild_world_set','cl_update_rev_set'),
            next_label=_("Update"))
        return dv

    @rpc(Integer, ViewParams,_returns = ViewInfo)
    def update_view (self, sid, params):
        return commonView(self,sid,params,"update")
