# -*- coding: utf-8 -*-

# Copyright 2008-2013 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import sys
from calculate.lib.datavars import (Variable, VariableInterface,
                                    ReadonlyVariable,ReadonlyTableVariable,
                                    FieldValue)
from calculate.lib.utils.files import (process,checkUtils)

from calculate.lib.cl_lang import setLocalTranslate
setLocalTranslate('cl_install3',sys.modules[__name__])

class LvmHelper(VariableInterface):
    def getLvmData(self):
        """Get route table, exclude specifed iface"""
        pvDisplayProg = checkUtils('/sbin/pvdisplay')
        pvDisplay = process(pvDisplayProg,"--noh","-Co",
                                          "lv_name,vg_name,pv_name")
        for line in pvDisplay:
            line = line.split()
            if len(line) == 3:
                yield line

#######################################################
# Devices variables
#######################################################
class VariableOsLvmData(ReadonlyTableVariable,LvmHelper):
    """
    Information about disk devices
    """
    source = ['os_lvm_lvname',
              'os_lvm_vgname',
              'os_lvm_pvname']

    def get(self,hr=False):
        """LVM hash"""
        return list(self.getLvmData()) or [[]]

    setValue = Variable.setValue

class VariableOsLvmLvname(FieldValue,ReadonlyVariable):
    """
    Logical volumes names
    """
    type = "list"
    source_variable = "os_lvm_data"
    column = 0

class VariableOsLvmVgname(FieldValue,ReadonlyVariable):
    """
    Volume groups names
    """
    type = "list"
    source_variable = "os_lvm_data"
    column = 1

class VariableOsLvmPvname(FieldValue,ReadonlyVariable):
    """
    Phisical volumes names
    """
    type = "list"
    source_variable = "os_lvm_data"
    column = 2
