#!/usr/bin/env python2
# -*- coding: utf-8 -*-

# setup.py --- Setup script for calculate-desktop

# Copyright 2012 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

__app__ = "calculate-desktop"
__version__ = "3.2.2"

import os
import stat
from distutils.core import setup, Extension
from calculate.install_data import install_data


data_files = [('/usr/share/calculate/xdm', [('data/cmd_login', 0755),
                                             'data/functions',
                                             ('data/xdm', 0755),
                                             ('data/setbg', 0755)]),
              ('/usr/share/calculate/xdm/login.d',
                                            ['data/login.d/00init',
                                             'data/login.d/20desktop',
                                             'data/login.d/99final']),
              ('/usr/share/calculate/xdm/logout.d',
                                            ['data/logout.d/00init',
                                             'data/logout.d/95syncface',
                                             'data/logout.d/98umount'])]

packages = [
    "calculate."+str('.'.join(root.split(os.sep)[1:]))
    for root, dirs, files in os.walk('pym/desktop')
    if '__init__.py' in files
]

setup(
    name = __app__,
    version = __version__,
    description = "Create and configure user profile",
    author = "Calculate Ltd.",
    author_email = "support@calculate.ru",
    url = "http://calculate-linux.org",
    license = "http://www.apache.org/licenses/LICENSE-2.0",
    package_dir = {'calculate.desktop': "pym/desktop"},
    packages = packages,
    data_files = data_files,
    ext_modules = [Extension('calculate.desktop._cl_keys',
                             library_dirs = ['/usr/lib'],
                             libraries = ['keyutils'],
                             sources = ['./lib/cl_keys.i', './lib/cl_keys.c'])],
    cmdclass={'install_data': install_data})

